/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.audiotoolbox;

import org.robovm.apple.audiotoolbox.AudioPanningMode;
import org.robovm.apple.coreaudio.AudioChannelCoordinate;
import org.robovm.apple.coreaudio.AudioChannelFlags;
import org.robovm.apple.coreaudio.AudioChannelLayout;
import org.robovm.rt.bro.Struct;
import org.robovm.rt.bro.annotation.Array;
import org.robovm.rt.bro.annotation.StructMember;
import org.robovm.rt.bro.ptr.Ptr;

public class AudioPanningInfo
extends Struct<AudioPanningInfo> {
    public AudioPanningInfo() {
    }

    public AudioPanningInfo(AudioPanningMode panningMode, AudioChannelFlags coordinateFlags, float[] coordinates, float gainScale, AudioChannelLayout outputChannelMap) {
        this.setPanningMode(panningMode);
        this.setCoordinateFlags(coordinateFlags);
        this.setCoordinates(coordinates);
        this.setGainScale(gainScale);
        this.setOutputChannelMap(outputChannelMap);
    }

    public float getCoordinate(AudioChannelCoordinate coordinate) {
        return this.getCoordinates()[(int)coordinate.value()];
    }

    public AudioPanningInfo setCoordinate(AudioChannelCoordinate coordinate, float value) {
        float[] coords = this.getCoordinates();
        coords[(int)coordinate.value()] = value;
        this.setCoordinates(coords);
        return this;
    }

    public AudioPanningInfo setCoordinates(float x, float y, float z) {
        float[] coords = new float[]{x, y, z};
        this.setCoordinates(coords);
        return this;
    }

    @StructMember(value=0)
    public native AudioPanningMode getPanningMode();

    @StructMember(value=0)
    public native AudioPanningInfo setPanningMode(AudioPanningMode var1);

    @StructMember(value=1)
    public native AudioChannelFlags getCoordinateFlags();

    @StructMember(value=1)
    public native AudioPanningInfo setCoordinateFlags(AudioChannelFlags var1);

    @StructMember(value=2)
    @Array(value={3})
    public native float[] getCoordinates();

    @StructMember(value=2)
    public native AudioPanningInfo setCoordinates(@Array(value={3}) float[] var1);

    @StructMember(value=3)
    public native float getGainScale();

    @StructMember(value=3)
    public native AudioPanningInfo setGainScale(float var1);

    @StructMember(value=4)
    public native AudioChannelLayout getOutputChannelMap();

    @StructMember(value=4)
    public native AudioPanningInfo setOutputChannelMap(AudioChannelLayout var1);

    public static class AudioPanningInfoPtr
    extends Ptr<AudioPanningInfo, AudioPanningInfoPtr> {
    }
}

