/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.audiotoolbox;

import java.lang.reflect.Method;
import org.robovm.apple.audiotoolbox.AudioServicesProperty;
import org.robovm.apple.corefoundation.OSStatus;
import org.robovm.apple.corefoundation.OSStatusException;
import org.robovm.apple.foundation.CocoaUtility;
import org.robovm.apple.foundation.NSRunLoop;
import org.robovm.apple.foundation.NSURL;
import org.robovm.objc.LongMap;
import org.robovm.objc.annotation.Block;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.Struct;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Callback;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.ptr.BooleanPtr;
import org.robovm.rt.bro.ptr.FunctionPtr;
import org.robovm.rt.bro.ptr.IntPtr;
import org.robovm.rt.bro.ptr.VoidPtr;

@Library(value="AudioToolbox")
public class AudioServices
extends CocoaUtility {
    private static final LongMap<SystemSoundCompletionListener> completionListeners = new LongMap();
    private static final Method cbSystemSoundCompleted;
    public static final int SystemSoundVibrate = 4095;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static void cbSystemSoundCompleted(int systemSoundID, long clientData) {
        LongMap<SystemSoundCompletionListener> longMap = completionListeners;
        synchronized (longMap) {
            ((SystemSoundCompletionListener)completionListeners.get((long)systemSoundID)).onComplete(systemSoundID);
        }
    }

    public static int createSystemSoundID(NSURL fileURL) throws OSStatusException {
        IntPtr ptr = new IntPtr();
        OSStatus status = AudioServices.createSystemSoundID0(fileURL, ptr);
        OSStatusException.throwIfNecessary(status);
        return ptr.get();
    }

    public static void disposeSystemSoundID(int systemSoundID) throws OSStatusException {
        OSStatus status = AudioServices.disposeSystemSoundID0(systemSoundID);
        OSStatusException.throwIfNecessary(status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSystemSoundCompletionListener(int systemSoundID, NSRunLoop runLoop, String runLoopMode, SystemSoundCompletionListener listener) throws OSStatusException {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        OSStatus status = AudioServices.addSystemSoundCompletion0(systemSoundID, runLoop, runLoopMode, new FunctionPtr(cbSystemSoundCompleted), null);
        if (OSStatusException.throwIfNecessary(status)) {
            LongMap<SystemSoundCompletionListener> longMap = completionListeners;
            synchronized (longMap) {
                completionListeners.put((long)systemSoundID, (Object)listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeSystemSoundCompletion(int systemSoundID) {
        AudioServices.removeSystemSoundCompletion0(systemSoundID);
        LongMap<SystemSoundCompletionListener> longMap = completionListeners;
        synchronized (longMap) {
            completionListeners.remove((long)systemSoundID);
        }
    }

    public static int getPropertySize(AudioServicesProperty id) throws OSStatusException {
        IntPtr ptr = new IntPtr();
        OSStatus status = AudioServices.getPropertyInfo0(id, 0, null, ptr, null);
        OSStatusException.throwIfNecessary(status);
        return ptr.get();
    }

    public static boolean isPropertyWritable(AudioServicesProperty id) throws OSStatusException {
        BooleanPtr ptr = new BooleanPtr();
        OSStatus status = AudioServices.getPropertyInfo0(id, 0, null, null, ptr);
        OSStatusException.throwIfNecessary(status);
        return ptr.get();
    }

    public static <T extends Struct<T>> T getProperty(AudioServicesProperty id, Struct<?> specifier, Class<T> type) throws OSStatusException {
        Struct data = Struct.allocate(type);
        IntPtr dataSize = new IntPtr(Struct.sizeOf((Struct)data));
        OSStatus status = AudioServices.getProperty0(id, specifier == null ? 0 : Struct.sizeOf(specifier), specifier == null ? null : (VoidPtr)specifier.as(VoidPtr.class), dataSize, (VoidPtr)data.as(VoidPtr.class));
        OSStatusException.throwIfNecessary(status);
        return (T)data;
    }

    public static <T extends Struct<T>> void setProperty(AudioServicesProperty id, Struct<?> specifier, T data) throws OSStatusException {
        OSStatus status = AudioServices.setProperty0(id, specifier == null ? 0 : Struct.sizeOf(specifier), specifier == null ? null : (VoidPtr)specifier.as(VoidPtr.class), data == null ? 0 : Struct.sizeOf(data), data == null ? null : (VoidPtr)data.as(VoidPtr.class));
        OSStatusException.throwIfNecessary(status);
    }

    public static boolean isUISound(int systemSoundID) throws OSStatusException {
        IntPtr ptr = new IntPtr(systemSoundID);
        IntPtr result = AudioServices.getProperty(AudioServicesProperty.IsUISound, ptr, IntPtr.class);
        return result.get() == 1;
    }

    public static void setUISound(int systemSoundID, boolean ui) throws OSStatusException {
        IntPtr ptr = new IntPtr(systemSoundID);
        AudioServices.setProperty(AudioServicesProperty.IsUISound, ptr, new IntPtr(ui ? 1 : 0));
    }

    public static boolean completesPlaybackIfAppDies(int systemSoundID) throws OSStatusException {
        IntPtr ptr = new IntPtr(systemSoundID);
        IntPtr result = AudioServices.getProperty(AudioServicesProperty.CompletePlaybackIfAppDies, ptr, IntPtr.class);
        return result.get() == 1;
    }

    public static void setCompletesPlaybackIfAppDies(int systemSoundID, boolean ui) throws OSStatusException {
        IntPtr ptr = new IntPtr(systemSoundID);
        AudioServices.setProperty(AudioServicesProperty.CompletePlaybackIfAppDies, ptr, new IntPtr(ui ? 1 : 0));
    }

    @Bridge(symbol="AudioServicesCreateSystemSoundID", optional=true)
    protected static native OSStatus createSystemSoundID0(NSURL var0, IntPtr var1);

    @Bridge(symbol="AudioServicesDisposeSystemSoundID", optional=true)
    protected static native OSStatus disposeSystemSoundID0(int var0);

    @Bridge(symbol="AudioServicesPlayAlertSoundWithCompletion", optional=true)
    protected static native void playAlertSoundWithCompletion0(int var0, @Block Runnable var1);

    @Bridge(symbol="AudioServicesPlaySystemSoundWithCompletion", optional=true)
    protected static native void playSystemSoundWithCompletion0(int var0, @Block Runnable var1);

    @Bridge(symbol="AudioServicesGetPropertyInfo", optional=true)
    protected static native OSStatus getPropertyInfo0(AudioServicesProperty var0, int var1, VoidPtr var2, IntPtr var3, BooleanPtr var4);

    @Bridge(symbol="AudioServicesGetProperty", optional=true)
    protected static native OSStatus getProperty0(AudioServicesProperty var0, int var1, VoidPtr var2, IntPtr var3, VoidPtr var4);

    @Bridge(symbol="AudioServicesSetProperty", optional=true)
    protected static native OSStatus setProperty0(AudioServicesProperty var0, int var1, VoidPtr var2, int var3, VoidPtr var4);

    @Bridge(symbol="AudioServicesPlayAlertSound", optional=true)
    public static native void playAlertSound(int var0);

    @Bridge(symbol="AudioServicesPlaySystemSound", optional=true)
    public static native void playSystemSound(int var0);

    @Bridge(symbol="AudioServicesAddSystemSoundCompletion", optional=true)
    protected static native OSStatus addSystemSoundCompletion0(int var0, NSRunLoop var1, String var2, FunctionPtr var3, VoidPtr var4);

    @Bridge(symbol="AudioServicesRemoveSystemSoundCompletion", optional=true)
    protected static native void removeSystemSoundCompletion0(int var0);

    static {
        try {
            cbSystemSoundCompleted = AudioServices.class.getDeclaredMethod("cbSystemSoundCompleted", Integer.TYPE, Long.TYPE);
        }
        catch (Throwable e) {
            throw new Error(e);
        }
        Bro.bind(AudioServices.class);
    }

    public static interface SystemSoundCompletionListener {
        public void onComplete(int var1);
    }
}

