/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.audiotoolbox;

import org.robovm.apple.audiotoolbox.CAFMarker;
import org.robovm.apple.audiotoolbox.CAFRegionFlags;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.Struct;
import org.robovm.rt.bro.annotation.Packed;
import org.robovm.rt.bro.annotation.StructMember;
import org.robovm.rt.bro.ptr.Ptr;

@Packed(value=1)
public class CAFRegion
extends Struct<CAFRegion> {
    public CAFRegion() {
    }

    public CAFRegion(int regionID, CAFRegionFlags flags) {
        this.setRegionID(regionID);
        this.setFlags(flags);
    }

    public int getMarkerCount() {
        return this.getNumberMarkers();
    }

    public CAFMarker getMarker(int index) {
        if (index >= this.getMarkerCount()) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return (CAFMarker)((CAFMarker.CAFMarkerPtr)this.getMarkers0().next(index)).get();
    }

    public CAFRegion setMarker(int index, CAFMarker value) {
        if (index >= this.getMarkerCount()) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        ((CAFMarker.CAFMarkerPtr)this.getMarkers0().next(index)).set((NativeObject)value);
        return this;
    }

    public CAFMarker[] getMarkers() {
        int count = this.getMarkerCount();
        CAFMarker[] array = new CAFMarker[count];
        CAFMarker.CAFMarkerPtr ptr = this.getMarkers0();
        for (int i = 0; i < count; ++i) {
            array[i] = (CAFMarker)((CAFMarker.CAFMarkerPtr)ptr.next(i)).get();
        }
        return array;
    }

    public CAFRegion setMarkers(CAFMarker[] markers) {
        this.setNumberMarkers(markers.length);
        this.getMarkers0().set((NativeObject[])markers);
        return this;
    }

    @StructMember(value=0)
    public native int getRegionID();

    @StructMember(value=0)
    public native CAFRegion setRegionID(int var1);

    @StructMember(value=1)
    public native CAFRegionFlags getFlags();

    @StructMember(value=1)
    public native CAFRegion setFlags(CAFRegionFlags var1);

    @StructMember(value=2)
    protected native int getNumberMarkers();

    @StructMember(value=2)
    protected native CAFRegion setNumberMarkers(int var1);

    @StructMember(value=3)
    protected native CAFMarker.CAFMarkerPtr getMarkers0();

    @StructMember(value=3)
    protected native CAFRegion setMarkers0(CAFMarker.CAFMarkerPtr var1);

    public static class CAFRegionPtr
    extends Ptr<CAFRegion, CAFRegionPtr> {
    }
}

