/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.audiotoolbox;

import org.robovm.apple.audiotoolbox.AudioFile;
import org.robovm.apple.audiotoolbox.AudioFileFlags;
import org.robovm.apple.audiotoolbox.AudioFileType;
import org.robovm.apple.audiotoolbox.ExtAudioFileProperty;
import org.robovm.apple.coreaudio.AudioBufferList;
import org.robovm.apple.coreaudio.AudioChannelLayout;
import org.robovm.apple.coreaudio.AudioStreamBasicDescription;
import org.robovm.apple.corefoundation.OSStatus;
import org.robovm.apple.corefoundation.OSStatusException;
import org.robovm.apple.foundation.NSURL;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.Struct;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.ptr.BooleanPtr;
import org.robovm.rt.bro.ptr.DoublePtr;
import org.robovm.rt.bro.ptr.FloatPtr;
import org.robovm.rt.bro.ptr.IntPtr;
import org.robovm.rt.bro.ptr.LongPtr;
import org.robovm.rt.bro.ptr.Ptr;
import org.robovm.rt.bro.ptr.VoidPtr;

@Library(value="AudioToolbox")
public class ExtAudioFile
extends NativeObject {
    protected ExtAudioFile() {
    }

    public static ExtAudioFile openURL(NSURL url) throws OSStatusException {
        ExtAudioFilePtr ptr = new ExtAudioFilePtr();
        OSStatus status = ExtAudioFile.openURL0(url, ptr);
        OSStatusException.throwIfNecessary(status);
        return (ExtAudioFile)ptr.get();
    }

    public static ExtAudioFile wrapAudioFile(AudioFile audioFile, boolean forWriting) throws OSStatusException {
        ExtAudioFilePtr ptr = new ExtAudioFilePtr();
        OSStatus status = ExtAudioFile.wrapAudioFile0(audioFile, forWriting, ptr);
        OSStatusException.throwIfNecessary(status);
        return (ExtAudioFile)ptr.get();
    }

    public static ExtAudioFile create(NSURL url, AudioFileType fileType, AudioStreamBasicDescription streamDesc, AudioChannelLayout channelLayout, AudioFileFlags flags) throws OSStatusException {
        ExtAudioFilePtr ptr = new ExtAudioFilePtr();
        OSStatus status = ExtAudioFile.create0(url, fileType, streamDesc, channelLayout, flags, ptr);
        OSStatusException.throwIfNecessary(status);
        return (ExtAudioFile)ptr.get();
    }

    public void dispose() throws OSStatusException {
        OSStatus status = this.dispose0();
        OSStatusException.throwIfNecessary(status);
    }

    public int read(int numberFrames, AudioBufferList data) throws OSStatusException {
        IntPtr ptr = new IntPtr(numberFrames);
        OSStatus status = this.read0(ptr, data);
        OSStatusException.throwIfNecessary(status);
        return ptr.get();
    }

    public void write(int numberFrames, AudioBufferList data) throws OSStatusException {
        OSStatus status = this.write0(numberFrames, data);
        OSStatusException.throwIfNecessary(status);
    }

    public void writeAsync(int numberFrames, AudioBufferList data) throws OSStatusException {
        OSStatus status = this.writeAsync0(numberFrames, data);
        OSStatusException.throwIfNecessary(status);
    }

    public void seek(long frameOffset) throws OSStatusException {
        OSStatus status = this.seek0(frameOffset);
        OSStatusException.throwIfNecessary(status);
    }

    public long tell() throws OSStatusException {
        LongPtr ptr = new LongPtr();
        OSStatus status = this.tell0(ptr);
        OSStatusException.throwIfNecessary(status);
        return ptr.get();
    }

    public int getPropertySize(ExtAudioFileProperty id) throws OSStatusException {
        IntPtr ptr = new IntPtr();
        OSStatus status = this.getPropertyInfo0(id, ptr, null);
        OSStatusException.throwIfNecessary(status);
        return ptr.get();
    }

    public boolean isPropertyWritable(ExtAudioFileProperty id) throws OSStatusException {
        BooleanPtr ptr = new BooleanPtr();
        OSStatus status = this.getPropertyInfo0(id, null, ptr);
        OSStatusException.throwIfNecessary(status);
        return ptr.get();
    }

    public <T extends Struct<T>> T getProperty(ExtAudioFileProperty id, Class<T> type) throws OSStatusException {
        Struct data = Struct.allocate(type);
        IntPtr dataSize = new IntPtr(Struct.sizeOf((Struct)data));
        OSStatus status = this.getProperty0(id, dataSize, (VoidPtr)data.as(VoidPtr.class));
        OSStatusException.throwIfNecessary(status);
        return (T)data;
    }

    public <T extends Struct<T>> void setProperty(ExtAudioFileProperty id, T data) throws OSStatusException {
        OSStatus status = this.setProperty0(id, data == null ? 0 : Struct.sizeOf(data), data == null ? null : (VoidPtr)data.as(VoidPtr.class));
        OSStatusException.throwIfNecessary(status);
    }

    public int getPropertyAsInt(ExtAudioFileProperty id) throws OSStatusException {
        IntPtr ptr = this.getProperty(id, IntPtr.class);
        return ptr.get();
    }

    public long getPropertyAsLong(ExtAudioFileProperty id) throws OSStatusException {
        LongPtr ptr = this.getProperty(id, LongPtr.class);
        return ptr.get();
    }

    public float getPropertyAsFloat(ExtAudioFileProperty id) throws OSStatusException {
        FloatPtr ptr = this.getProperty(id, FloatPtr.class);
        return ptr.get();
    }

    public double getPropertyAsDouble(ExtAudioFileProperty id) throws OSStatusException {
        DoublePtr ptr = this.getProperty(id, DoublePtr.class);
        return ptr.get();
    }

    public void setProperty(ExtAudioFileProperty id, int value) throws OSStatusException {
        this.setProperty(id, new IntPtr(value));
    }

    public void setProperty(ExtAudioFileProperty id, long value) throws OSStatusException {
        this.setProperty(id, new LongPtr(value));
    }

    public void setProperty(ExtAudioFileProperty id, float value) throws OSStatusException {
        this.setProperty(id, new FloatPtr(value));
    }

    public void setProperty(ExtAudioFileProperty id, double value) throws OSStatusException {
        this.setProperty(id, new DoublePtr(value));
    }

    @Bridge(symbol="ExtAudioFileOpenURL", optional=true)
    protected static native OSStatus openURL0(NSURL var0, ExtAudioFilePtr var1);

    @Bridge(symbol="ExtAudioFileWrapAudioFileID", optional=true)
    protected static native OSStatus wrapAudioFile0(AudioFile var0, boolean var1, ExtAudioFilePtr var2);

    @Bridge(symbol="ExtAudioFileCreateWithURL", optional=true)
    protected static native OSStatus create0(NSURL var0, AudioFileType var1, AudioStreamBasicDescription var2, AudioChannelLayout var3, AudioFileFlags var4, ExtAudioFilePtr var5);

    @Bridge(symbol="ExtAudioFileDispose", optional=true)
    protected native OSStatus dispose0();

    @Bridge(symbol="ExtAudioFileRead", optional=true)
    protected native OSStatus read0(IntPtr var1, AudioBufferList var2);

    @Bridge(symbol="ExtAudioFileWrite", optional=true)
    protected native OSStatus write0(int var1, AudioBufferList var2);

    @Bridge(symbol="ExtAudioFileWriteAsync", optional=true)
    protected native OSStatus writeAsync0(int var1, AudioBufferList var2);

    @Bridge(symbol="ExtAudioFileSeek", optional=true)
    protected native OSStatus seek0(long var1);

    @Bridge(symbol="ExtAudioFileTell", optional=true)
    protected native OSStatus tell0(LongPtr var1);

    @Bridge(symbol="ExtAudioFileGetPropertyInfo", optional=true)
    protected native OSStatus getPropertyInfo0(ExtAudioFileProperty var1, IntPtr var2, BooleanPtr var3);

    @Bridge(symbol="ExtAudioFileGetProperty", optional=true)
    protected native OSStatus getProperty0(ExtAudioFileProperty var1, IntPtr var2, VoidPtr var3);

    @Bridge(symbol="ExtAudioFileSetProperty", optional=true)
    protected native OSStatus setProperty0(ExtAudioFileProperty var1, int var2, VoidPtr var3);

    static {
        Bro.bind(ExtAudioFile.class);
    }

    public static class ExtAudioFilePtr
    extends Ptr<ExtAudioFile, ExtAudioFilePtr> {
    }
}

