/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.audiotoolbox;

import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicLong;
import org.robovm.apple.audiotoolbox.AUGraph;
import org.robovm.apple.audiotoolbox.AudioFileInfoDictionary;
import org.robovm.apple.audiotoolbox.CABarBeatTime;
import org.robovm.apple.audiotoolbox.MusicEventUserData;
import org.robovm.apple.audiotoolbox.MusicSequenceFileFlags;
import org.robovm.apple.audiotoolbox.MusicSequenceFileTypeID;
import org.robovm.apple.audiotoolbox.MusicSequenceLoadFlags;
import org.robovm.apple.audiotoolbox.MusicSequenceType;
import org.robovm.apple.audiotoolbox.MusicTrack;
import org.robovm.apple.corefoundation.OSStatus;
import org.robovm.apple.corefoundation.OSStatusException;
import org.robovm.apple.coremidi.MIDIEndpoint;
import org.robovm.apple.foundation.NSData;
import org.robovm.apple.foundation.NSURL;
import org.robovm.objc.LongMap;
import org.robovm.rt.annotation.WeaklyLinked;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Callback;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.DoublePtr;
import org.robovm.rt.bro.ptr.FunctionPtr;
import org.robovm.rt.bro.ptr.IntPtr;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="AudioToolbox")
public class MusicSequence
extends NativeObject {
    private static AtomicLong callbackId = new AtomicLong();
    private static final LongMap<UserCallback> userCallbacks = new LongMap();
    private static final Method cbUser;
    private long cid;

    protected MusicSequence() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static void cbUser(@Pointer long clientData, MusicSequence sequence, MusicTrack track, double eventTime, MusicEventUserData eventData, double startSliceBeat, double endSliceBeat) {
        LongMap<UserCallback> longMap = userCallbacks;
        synchronized (longMap) {
            ((UserCallback)userCallbacks.get(clientData)).invoke(sequence, track, eventTime, eventData, startSliceBeat, endSliceBeat);
        }
    }

    public static MusicSequence create() throws OSStatusException {
        MusicSequencePtr ptr = new MusicSequencePtr();
        OSStatus status = MusicSequence.create0(ptr);
        OSStatusException.throwIfNecessary(status);
        MusicSequence result = (MusicSequence)ptr.get();
        result.cid = callbackId.getAndIncrement();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() throws OSStatusException {
        OSStatus status = this.dispose0();
        if (OSStatusException.throwIfNecessary(status)) {
            LongMap<UserCallback> longMap = userCallbacks;
            synchronized (longMap) {
                userCallbacks.remove(this.cid);
            }
        }
    }

    public MusicTrack newTrack() throws OSStatusException {
        MusicTrack.MusicTrackPtr ptr = new MusicTrack.MusicTrackPtr();
        OSStatus status = this.newTrack0(ptr);
        OSStatusException.throwIfNecessary(status);
        return (MusicTrack)ptr.get();
    }

    public void disposeTrack(MusicTrack track) throws OSStatusException {
        OSStatus status = this.disposeTrack0(track);
        OSStatusException.throwIfNecessary(status);
    }

    public int getTrackCount() throws OSStatusException {
        IntPtr ptr = new IntPtr();
        OSStatus status = this.getTrackCount0(ptr);
        OSStatusException.throwIfNecessary(status);
        return ptr.get();
    }

    public MusicTrack getIndTrack(int trackIndex) throws OSStatusException {
        MusicTrack.MusicTrackPtr ptr = new MusicTrack.MusicTrackPtr();
        OSStatus status = this.getIndTrack0(trackIndex, ptr);
        OSStatusException.throwIfNecessary(status);
        return (MusicTrack)ptr.get();
    }

    public int getTrackIndex(MusicTrack track) throws OSStatusException {
        IntPtr ptr = new IntPtr();
        OSStatus status = this.getTrackIndex0(track, ptr);
        OSStatusException.throwIfNecessary(status);
        return ptr.get();
    }

    public MusicTrack getTempoTrack() throws OSStatusException {
        MusicTrack.MusicTrackPtr ptr = new MusicTrack.MusicTrackPtr();
        OSStatus status = this.getTempoTrack0(ptr);
        OSStatusException.throwIfNecessary(status);
        return (MusicTrack)ptr.get();
    }

    public void setAUGraph(AUGraph graph) throws OSStatusException {
        OSStatus status = this.setAUGraph0(graph);
        OSStatusException.throwIfNecessary(status);
    }

    public AUGraph getAUGraph() throws OSStatusException {
        AUGraph.AUGraphPtr ptr = new AUGraph.AUGraphPtr();
        OSStatus status = this.getAUGraph0(ptr);
        OSStatusException.throwIfNecessary(status);
        return (AUGraph)ptr.get();
    }

    @WeaklyLinked
    public void setMIDIEndpoint(MIDIEndpoint endpoint) throws OSStatusException {
        OSStatus status = this.setMIDIEndpoint0(endpoint);
        OSStatusException.throwIfNecessary(status);
    }

    public void setSequenceType(MusicSequenceType type) throws OSStatusException {
        OSStatus status = this.setSequenceType0(type);
        OSStatusException.throwIfNecessary(status);
    }

    public MusicSequenceType getSequenceType() throws OSStatusException {
        IntPtr ptr = new IntPtr();
        OSStatus status = this.getSequenceType0(ptr);
        OSStatusException.throwIfNecessary(status);
        return MusicSequenceType.valueOf(ptr.get());
    }

    public void loadFile(NSURL fileRef, MusicSequenceFileTypeID fileTypeHint, MusicSequenceLoadFlags flags) throws OSStatusException {
        OSStatus status = this.loadFile0(fileRef, fileTypeHint, flags);
        OSStatusException.throwIfNecessary(status);
    }

    public void loadFileData(NSData data, MusicSequenceFileTypeID fileTypeHint, MusicSequenceLoadFlags flags) throws OSStatusException {
        OSStatus status = this.loadFileData0(data, fileTypeHint, flags);
        OSStatusException.throwIfNecessary(status);
    }

    public void createFile(NSURL fileRef, MusicSequenceFileTypeID fileType, MusicSequenceFileFlags flags, short resolution) throws OSStatusException {
        OSStatus status = this.createFile0(fileRef, fileType, flags, resolution);
        OSStatusException.throwIfNecessary(status);
    }

    public NSData createFileData(MusicSequenceFileTypeID fileType, MusicSequenceFileFlags flags, short resolution) throws OSStatusException {
        NSData.NSDataPtr ptr = new NSData.NSDataPtr();
        OSStatus status = this.createFileData0(fileType, flags, resolution, ptr);
        OSStatusException.throwIfNecessary(status);
        return (NSData)ptr.get();
    }

    public void reverse() throws OSStatusException {
        OSStatus status = this.reverse0();
        OSStatusException.throwIfNecessary(status);
    }

    public double getSecondsForBeats(double beats) throws OSStatusException {
        DoublePtr ptr = new DoublePtr();
        OSStatus status = this.getSecondsForBeats0(beats, ptr);
        OSStatusException.throwIfNecessary(status);
        return ptr.get();
    }

    public double getBeatsForSeconds(double seconds) throws OSStatusException {
        DoublePtr ptr = new DoublePtr();
        OSStatus status = this.getBeatsForSeconds0(seconds, ptr);
        OSStatusException.throwIfNecessary(status);
        return ptr.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserCallback(UserCallback callback) throws OSStatusException {
        if (callback == null) {
            LongMap<UserCallback> longMap = userCallbacks;
            synchronized (longMap) {
                userCallbacks.remove(this.cid);
            }
            OSStatus status = this.setUserCallback0(null, this.cid);
            OSStatusException.throwIfNecessary(status);
        } else {
            OSStatus status = this.setUserCallback0(new FunctionPtr(cbUser), this.cid);
            if (OSStatusException.throwIfNecessary(status)) {
                LongMap<UserCallback> longMap = userCallbacks;
                synchronized (longMap) {
                    userCallbacks.put(this.cid, (Object)callback);
                }
            }
        }
    }

    public CABarBeatTime convertBeatsToBarBeatTime(double beats, int subbeatDivisor) throws OSStatusException {
        CABarBeatTime.CABarBeatTimePtr ptr = new CABarBeatTime.CABarBeatTimePtr();
        OSStatus status = this.convertBeatsToBarBeatTime0(beats, subbeatDivisor, ptr);
        OSStatusException.throwIfNecessary(status);
        return (CABarBeatTime)ptr.get();
    }

    public double convertBarBeatTimeToBeats(CABarBeatTime barBeatTime) throws OSStatusException {
        DoublePtr ptr = new DoublePtr();
        OSStatus status = this.convertBarBeatTimeToBeats0(barBeatTime, ptr);
        OSStatusException.throwIfNecessary(status);
        return ptr.get();
    }

    @Bridge(symbol="NewMusicSequence", optional=true)
    protected static native OSStatus create0(MusicSequencePtr var0);

    @Bridge(symbol="DisposeMusicSequence", optional=true)
    protected native OSStatus dispose0();

    @Bridge(symbol="MusicSequenceNewTrack", optional=true)
    protected native OSStatus newTrack0(MusicTrack.MusicTrackPtr var1);

    @Bridge(symbol="MusicSequenceDisposeTrack", optional=true)
    protected native OSStatus disposeTrack0(MusicTrack var1);

    @Bridge(symbol="MusicSequenceGetTrackCount", optional=true)
    protected native OSStatus getTrackCount0(IntPtr var1);

    @Bridge(symbol="MusicSequenceGetIndTrack", optional=true)
    protected native OSStatus getIndTrack0(int var1, MusicTrack.MusicTrackPtr var2);

    @Bridge(symbol="MusicSequenceGetTrackIndex", optional=true)
    protected native OSStatus getTrackIndex0(MusicTrack var1, IntPtr var2);

    @Bridge(symbol="MusicSequenceGetTempoTrack", optional=true)
    protected native OSStatus getTempoTrack0(MusicTrack.MusicTrackPtr var1);

    @Bridge(symbol="MusicSequenceSetAUGraph", optional=true)
    protected native OSStatus setAUGraph0(AUGraph var1);

    @Bridge(symbol="MusicSequenceGetAUGraph", optional=true)
    protected native OSStatus getAUGraph0(AUGraph.AUGraphPtr var1);

    @Bridge(symbol="MusicSequenceSetMIDIEndpoint", optional=true)
    @WeaklyLinked
    public native OSStatus setMIDIEndpoint0(MIDIEndpoint var1);

    @Bridge(symbol="MusicSequenceSetSequenceType", optional=true)
    protected native OSStatus setSequenceType0(MusicSequenceType var1);

    @Bridge(symbol="MusicSequenceGetSequenceType", optional=true)
    protected native OSStatus getSequenceType0(IntPtr var1);

    @Bridge(symbol="MusicSequenceFileLoad", optional=true)
    protected native OSStatus loadFile0(NSURL var1, MusicSequenceFileTypeID var2, MusicSequenceLoadFlags var3);

    @Bridge(symbol="MusicSequenceFileLoadData", optional=true)
    protected native OSStatus loadFileData0(NSData var1, MusicSequenceFileTypeID var2, MusicSequenceLoadFlags var3);

    @Bridge(symbol="MusicSequenceFileCreate", optional=true)
    protected native OSStatus createFile0(NSURL var1, MusicSequenceFileTypeID var2, MusicSequenceFileFlags var3, short var4);

    @Bridge(symbol="MusicSequenceFileCreateData", optional=true)
    protected native OSStatus createFileData0(MusicSequenceFileTypeID var1, MusicSequenceFileFlags var2, short var3, NSData.NSDataPtr var4);

    @Bridge(symbol="MusicSequenceReverse", optional=true)
    protected native OSStatus reverse0();

    @Bridge(symbol="MusicSequenceGetSecondsForBeats", optional=true)
    protected native OSStatus getSecondsForBeats0(double var1, DoublePtr var3);

    @Bridge(symbol="MusicSequenceGetBeatsForSeconds", optional=true)
    protected native OSStatus getBeatsForSeconds0(double var1, DoublePtr var3);

    @Bridge(symbol="MusicSequenceSetUserCallback", optional=true)
    public native OSStatus setUserCallback0(FunctionPtr var1, @Pointer long var2);

    @Bridge(symbol="MusicSequenceBeatsToBarBeatTime", optional=true)
    protected native OSStatus convertBeatsToBarBeatTime0(double var1, int var3, CABarBeatTime.CABarBeatTimePtr var4);

    @Bridge(symbol="MusicSequenceBarBeatTimeToBeats", optional=true)
    protected native OSStatus convertBarBeatTimeToBeats0(CABarBeatTime var1, DoublePtr var2);

    @Bridge(symbol="MusicSequenceGetInfoDictionary", optional=true)
    public native AudioFileInfoDictionary getInfoDictionary();

    static {
        try {
            cbUser = MusicSequence.class.getDeclaredMethod("cbUser", Long.TYPE, MusicSequence.class, MusicTrack.class, Double.TYPE, MusicEventUserData.class, Double.TYPE, Double.TYPE);
        }
        catch (Throwable e) {
            throw new Error(e);
        }
        Bro.bind(MusicSequence.class);
    }

    public static interface UserCallback {
        public void invoke(MusicSequence var1, MusicTrack var2, double var3, MusicEventUserData var5, double var6, double var8);
    }

    public static class MusicSequencePtr
    extends Ptr<MusicSequence, MusicSequencePtr> {
    }
}

