/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.avfoundation;

import java.util.List;
import org.robovm.apple.avfoundation.AVCaptureOutput;
import org.robovm.apple.avfoundation.AVCaptureVideoDataOutputSampleBufferDelegate;
import org.robovm.apple.avfoundation.AVPixelBufferAttributes;
import org.robovm.apple.avfoundation.AVVideoCodecType;
import org.robovm.apple.avfoundation.AVVideoSettings;
import org.robovm.apple.corefoundation.CFDictionary;
import org.robovm.apple.coremedia.CMVideoCodecType;
import org.robovm.apple.corevideo.CVPixelFormatType;
import org.robovm.apple.dispatch.DispatchQueue;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.rt.annotation.WeaklyLinked;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="AVFoundation")
@NativeClass
public class AVCaptureVideoDataOutput
extends AVCaptureOutput {
    protected AVCaptureVideoDataOutput(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected AVCaptureVideoDataOutput(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    public AVCaptureVideoDataOutput() {
        super(null, AVCaptureVideoDataOutput.create());
        AVCaptureVideoDataOutput.retain(this.getHandle());
    }

    public AVVideoSettings getVideoSettings() {
        return new AVVideoSettings(this.getVideoSettings0());
    }

    public void setVideoSettings(AVVideoSettings videoSettings) {
        this.setVideoSettings0(videoSettings.getDictionary());
    }

    @WeaklyLinked
    public AVPixelBufferAttributes getPixelBufferSettings() {
        return new AVPixelBufferAttributes((CFDictionary)this.getVideoSettings0().as(CFDictionary.class));
    }

    public void setPixelBufferSettings(AVPixelBufferAttributes videoSettings) {
        this.setVideoSettings0((NSDictionary)videoSettings.getDictionary().as(NSDictionary.class));
    }

    @Property(selector="sampleBufferDelegate")
    public native AVCaptureVideoDataOutputSampleBufferDelegate getSampleBufferDelegate();

    @Property(selector="sampleBufferCallbackQueue")
    @WeaklyLinked
    public native DispatchQueue getSampleBufferCallbackQueue();

    @Property(selector="videoSettings")
    protected native NSDictionary<NSString, ?> getVideoSettings0();

    @Property(selector="setVideoSettings:")
    protected native void setVideoSettings0(NSDictionary<NSString, ?> var1);

    @Property(selector="availableVideoCVPixelFormatTypes")
    @Marshaler(value=CVPixelFormatType.AsListMarshaler.class)
    @WeaklyLinked
    public native List<CVPixelFormatType> getAvailableVideoCVPixelFormatTypes();

    @Property(selector="availableVideoCodecTypes")
    @Marshaler(value=CMVideoCodecType.AsListMarshaler.class)
    public native List<CMVideoCodecType> getAvailableVideoCodecTypes();

    @Property(selector="alwaysDiscardsLateVideoFrames")
    public native boolean alwaysDiscardsLateVideoFrames();

    @Property(selector="setAlwaysDiscardsLateVideoFrames:")
    public native void setAlwaysDiscardsLateVideoFrames(boolean var1);

    @Property(selector="automaticallyConfiguresOutputBufferDimensions")
    public native boolean automaticallyConfiguresOutputBufferDimensions();

    @Property(selector="setAutomaticallyConfiguresOutputBufferDimensions:")
    public native void setAutomaticallyConfiguresOutputBufferDimensions(boolean var1);

    @Property(selector="deliversPreviewSizedOutputBuffers")
    public native boolean isDeliversPreviewSizedOutputBuffers();

    @Property(selector="setDeliversPreviewSizedOutputBuffers:")
    public native void setDeliversPreviewSizedOutputBuffers(boolean var1);

    public AVVideoSettings getRecommendedVideoSettings(String outputFileType) {
        return new AVVideoSettings(this.getRecommendedVideoSettings0(outputFileType));
    }

    @WeaklyLinked
    public AVPixelBufferAttributes getRecommendedPixelBufferSettings(String outputFileType) {
        return new AVPixelBufferAttributes((CFDictionary)this.getRecommendedVideoSettings0(outputFileType).as(CFDictionary.class));
    }

    @Method(selector="setSampleBufferDelegate:queue:")
    @WeaklyLinked
    public native void setSampleBufferDelegate(AVCaptureVideoDataOutputSampleBufferDelegate var1, DispatchQueue var2);

    @Method(selector="recommendedVideoSettingsForAssetWriterWithOutputFileType:")
    protected native NSDictionary<NSString, ?> getRecommendedVideoSettings0(String var1);

    @Method(selector="availableVideoCodecTypesForAssetWriterWithOutputFileType:")
    public native NSArray<NSString> getAvailableVideoCodecTypes(String var1);

    @Method(selector="recommendedVideoSettingsForVideoCodecType:assetWriterOutputFileType:")
    public native NSDictionary<?, ?> getRecommendedVideoSettings(AVVideoCodecType var1, String var2);

    @Method(selector="new")
    @Pointer
    protected static native long create();

    static {
        ObjCRuntime.bind(AVCaptureVideoDataOutput.class);
    }

    public static class AVCaptureVideoDataOutputPtr
    extends Ptr<AVCaptureVideoDataOutput, AVCaptureVideoDataOutputPtr> {
    }
}

