/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.avfoundation;

import org.robovm.apple.avfoundation.AVTimeRamp;
import org.robovm.apple.coregraphics.CGAffineTransform;
import org.robovm.apple.coregraphics.CGRect;
import org.robovm.apple.coremedia.CMTime;
import org.robovm.apple.coremedia.CMTimeRange;
import org.robovm.apple.foundation.NSCoder;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSSecureCoding;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.FloatPtr;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="AVFoundation")
@NativeClass
public class AVVideoCompositionLayerInstruction
extends NSObject
implements NSSecureCoding {
    public AVVideoCompositionLayerInstruction() {
    }

    @Deprecated
    protected AVVideoCompositionLayerInstruction(long handle) {
        super(handle);
    }

    protected AVVideoCompositionLayerInstruction(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected AVVideoCompositionLayerInstruction(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Method(selector="initWithCoder:")
    public AVVideoCompositionLayerInstruction(NSCoder coder) {
        super(null);
        this.initObject(this.init(coder));
    }

    @Property(selector="trackID")
    public native int getTrackID();

    @Property(selector="supportsSecureCoding")
    public static native boolean supportsSecureCoding();

    public AVTimeRamp<CGAffineTransform> getTransformRamp(CMTime time) {
        CGAffineTransform.CGAffineTransformPtr start = new CGAffineTransform.CGAffineTransformPtr();
        CGAffineTransform.CGAffineTransformPtr end = new CGAffineTransform.CGAffineTransformPtr();
        CMTimeRange.CMTimeRangePtr timeRange = new CMTimeRange.CMTimeRangePtr();
        boolean valid = this.getTransformRamp(time, start, end, timeRange);
        if (valid) {
            return new AVTimeRamp<CGAffineTransform>((CGAffineTransform)start.get(), (CGAffineTransform)end.get(), (CMTimeRange)timeRange.get());
        }
        return null;
    }

    public AVTimeRamp<Float> getOpacityRamp(CMTime time) {
        FloatPtr start = new FloatPtr();
        FloatPtr end = new FloatPtr();
        CMTimeRange.CMTimeRangePtr timeRange = new CMTimeRange.CMTimeRangePtr();
        boolean valid = this.getOpacityRamp(time, start, end, timeRange);
        if (valid) {
            return new AVTimeRamp<Float>(Float.valueOf(start.get()), Float.valueOf(end.get()), (CMTimeRange)timeRange.get());
        }
        return null;
    }

    public AVTimeRamp<CGRect> getCropRectangleRamp(CMTime time) {
        CGRect.CGRectPtr start = new CGRect.CGRectPtr();
        CGRect.CGRectPtr end = new CGRect.CGRectPtr();
        CMTimeRange.CMTimeRangePtr timeRange = new CMTimeRange.CMTimeRangePtr();
        boolean valid = this.getCropRectangleRamp(time, start, end, timeRange);
        if (valid) {
            return new AVTimeRamp<CGRect>((CGRect)start.get(), (CGRect)end.get(), (CMTimeRange)timeRange.get());
        }
        return null;
    }

    @Method(selector="getTransformRampForTime:startTransform:endTransform:timeRange:")
    protected native boolean getTransformRamp(@ByVal CMTime var1, CGAffineTransform.CGAffineTransformPtr var2, CGAffineTransform.CGAffineTransformPtr var3, CMTimeRange.CMTimeRangePtr var4);

    @Method(selector="getOpacityRampForTime:startOpacity:endOpacity:timeRange:")
    protected native boolean getOpacityRamp(@ByVal CMTime var1, FloatPtr var2, FloatPtr var3, CMTimeRange.CMTimeRangePtr var4);

    @Method(selector="getCropRectangleRampForTime:startCropRectangle:endCropRectangle:timeRange:")
    protected native boolean getCropRectangleRamp(@ByVal CMTime var1, CGRect.CGRectPtr var2, CGRect.CGRectPtr var3, CMTimeRange.CMTimeRangePtr var4);

    @Override
    @Method(selector="encodeWithCoder:")
    public native void encode(NSCoder var1);

    @Method(selector="initWithCoder:")
    @Pointer
    protected native long init(NSCoder var1);

    static {
        ObjCRuntime.bind(AVVideoCompositionLayerInstruction.class);
    }

    public static class AVVideoCompositionLayerInstructionPtr
    extends Ptr<AVVideoCompositionLayerInstruction, AVVideoCompositionLayerInstructionPtr> {
    }
}

