/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coreaudio;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.robovm.rt.VM;
import org.robovm.rt.bro.BufferMarshalers;
import org.robovm.rt.bro.Struct;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.annotation.StructMember;
import org.robovm.rt.bro.ptr.Ptr;

public class AudioBuffer
extends Struct<AudioBuffer> {
    public AudioBuffer() {
    }

    public AudioBuffer(int numberChannels) {
        this.setNumberChannels(numberChannels);
    }

    public AudioBuffer(long handle) {
        super(handle);
    }

    public AudioBuffer setData(long dataPointer, int length) {
        this.setData0(dataPointer);
        this.setDataByteSize(length);
        return this;
    }

    public AudioBuffer setData(byte[] data) {
        this.setArrayData(data, data.length);
        return this;
    }

    public AudioBuffer setData(short[] data) {
        this.setArrayData(data, data.length);
        return this;
    }

    public AudioBuffer setData(int[] data) {
        this.setArrayData(data, data.length);
        return this;
    }

    public AudioBuffer setData(float[] data) {
        this.setArrayData(data, data.length);
        return this;
    }

    public AudioBuffer setData(Buffer data) {
        this.setDataByteSize(data.capacity());
        this.setData0(BufferMarshalers.BufferMarshaler.toNative((Buffer)data, (long)0L));
        return this;
    }

    private AudioBuffer setArrayData(Object array, int length) {
        this.setDataByteSize(length);
        this.setData0(VM.getArrayValuesAddress((Object)array));
        return this;
    }

    public <T extends Buffer> T getDataAsBuffer(Class<T> bufferType) {
        long dataPointer = this.getDataPointer();
        if (bufferType == ByteBuffer.class) {
            return (T)VM.newDirectByteBuffer((long)dataPointer, (long)this.getDataByteSize());
        }
        if (bufferType == ShortBuffer.class) {
            return (T)VM.newDirectByteBuffer((long)dataPointer, (long)(this.getDataByteSize() << 1)).order(ByteOrder.nativeOrder()).asShortBuffer();
        }
        if (bufferType == IntBuffer.class) {
            return (T)VM.newDirectByteBuffer((long)dataPointer, (long)(this.getDataByteSize() << 2)).order(ByteOrder.nativeOrder()).asIntBuffer();
        }
        if (bufferType == FloatBuffer.class) {
            return (T)VM.newDirectByteBuffer((long)dataPointer, (long)(this.getDataByteSize() << 2)).order(ByteOrder.nativeOrder()).asFloatBuffer();
        }
        throw new UnsupportedOperationException("Buffer type not supported: " + bufferType);
    }

    public byte[] getDataAsByteArray() {
        int length = this.getDataByteSize();
        byte[] data = new byte[length];
        this.getDataAsBuffer(ByteBuffer.class).get(data, 0, length);
        return data;
    }

    public short[] getDataAsShortArray() {
        int length = this.getDataByteSize();
        short[] data = new short[length];
        this.getDataAsBuffer(ShortBuffer.class).get(data, 0, length);
        return data;
    }

    public int[] getDataAsIntArray() {
        int length = this.getDataByteSize();
        int[] data = new int[length];
        this.getDataAsBuffer(IntBuffer.class).get(data, 0, length);
        return data;
    }

    public float[] getDataAsFloatArray() {
        int length = this.getDataByteSize();
        float[] data = new float[length];
        this.getDataAsBuffer(FloatBuffer.class).get(data, 0, length);
        return data;
    }

    @StructMember(value=0)
    public native int getNumberChannels();

    @StructMember(value=0)
    public native AudioBuffer setNumberChannels(int var1);

    @StructMember(value=1)
    private native int getDataByteSize();

    @StructMember(value=1)
    private native AudioBuffer setDataByteSize(int var1);

    @StructMember(value=2)
    @Pointer
    public native long getDataPointer();

    @StructMember(value=2)
    private native AudioBuffer setData0(@Pointer long var1);

    public static class AudioBufferPtr
    extends Ptr<AudioBuffer, AudioBufferPtr> {
    }
}

