/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coreaudio;

import org.robovm.apple.coreaudio.AudioBuffer;
import org.robovm.rt.VM;
import org.robovm.rt.bro.Struct;
import org.robovm.rt.bro.annotation.Array;
import org.robovm.rt.bro.annotation.StructMember;
import org.robovm.rt.bro.ptr.Ptr;

public class AudioBufferList
extends Struct<AudioBufferList> {
    public AudioBufferList(int bufferCount) {
        super(VM.allocateMemory((int)(AudioBufferList.sizeOf() + (bufferCount - 1) * AudioBuffer.sizeOf())));
        this.setNumberBuffers(bufferCount);
    }

    public AudioBufferList(AudioBuffer ... buffers) {
        this(buffers.length);
        this.getBuffers0().update(buffers);
    }

    public int getBufferCount() {
        return this.getNumberBuffers();
    }

    public AudioBuffer getBuffer(int index) {
        if (index >= this.getBufferCount()) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return (AudioBuffer)this.getBuffers0().next(index);
    }

    public AudioBufferList setBuffer(int index, AudioBuffer buffer) {
        if (index >= this.getBufferCount()) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        ((AudioBuffer)this.getBuffers0().next(index)).update(buffer);
        return this;
    }

    public AudioBuffer[] getBuffers() {
        return (AudioBuffer[])this.getBuffers0().toArray(this.getBufferCount());
    }

    public AudioBufferList setBuffers(AudioBuffer[] buffers) {
        if (buffers.length > this.getBufferCount()) {
            throw new ArrayIndexOutOfBoundsException(buffers.length);
        }
        this.setNumberBuffers(buffers.length);
        this.getBuffers0().update(buffers);
        return this;
    }

    @StructMember(value=0)
    protected native int getNumberBuffers();

    @StructMember(value=0)
    protected native AudioBufferList setNumberBuffers(int var1);

    @StructMember(value=1)
    @Array(value={1})
    protected native AudioBuffer getBuffers0();

    @StructMember(value=1)
    protected native AudioBufferList setBuffers0(@Array(value={1}) AudioBuffer var1);

    public static class AudioBufferListPtr
    extends Ptr<AudioBufferList, AudioBufferListPtr> {
    }
}

