/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.corefoundation;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.robovm.apple.corefoundation.CFAllocator;
import org.robovm.apple.corefoundation.CFArrayCallBacks;
import org.robovm.apple.corefoundation.CFPropertyList;
import org.robovm.apple.corefoundation.CFRange;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.foundation.NSObject;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.Struct;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedSInt;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.annotation.MarshalsPointer;
import org.robovm.rt.bro.ptr.FunctionPtr;
import org.robovm.rt.bro.ptr.Ptr;
import org.robovm.rt.bro.ptr.VoidPtr;

@Library(value="CoreFoundation")
public class CFArray
extends CFPropertyList {
    protected CFArray() {
    }

    public static <T extends NativeObject> CFArray create(Collection<T> objects) {
        if (objects == null) {
            throw new NullPointerException("objects");
        }
        if (objects.size() == 0 || objects.iterator().next() instanceof CFType) {
            return CFArray.create(objects.toArray(new CFType[objects.size()]));
        }
        if (objects.iterator().next() instanceof NSObject) {
            return CFArray.create(objects.toArray(new NSObject[objects.size()]));
        }
        throw new IllegalArgumentException("items can only be of type CFType or NSObject!");
    }

    public static CFArray create(NSObject ... objects) {
        if (objects == null) {
            throw new NullPointerException("objects");
        }
        if (objects.length == 0) {
            return CFArray.create(null, null, 0L, CFArray.getTypeCallBacks());
        }
        NSObject.NSObjectPtr values = (NSObject.NSObjectPtr)Struct.allocate(NSObject.NSObjectPtr.class, (int)objects.length);
        values.set((NativeObject[])objects);
        return CFArray.create(null, (VoidPtr.VoidPtrPtr)values.as(VoidPtr.VoidPtrPtr.class), (long)objects.length, CFArray.getTypeCallBacks());
    }

    public static CFArray create(CFType ... objects) {
        if (objects == null) {
            throw new NullPointerException("objects");
        }
        if (objects.length == 0) {
            return CFArray.create(null, null, 0L, CFArray.getTypeCallBacks());
        }
        CFType.CFTypePtr values = (CFType.CFTypePtr)Struct.allocate(CFType.CFTypePtr.class, (int)objects.length);
        values.set(objects);
        return CFArray.create(null, (VoidPtr.VoidPtrPtr)values.as(VoidPtr.VoidPtrPtr.class), (long)objects.length, CFArray.getTypeCallBacks());
    }

    public <T extends NativeObject> T[] toArray(Class<T> type) {
        NativeObject[] result = (NativeObject[])Array.newInstance(type, (int)this.getCount());
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.get(i, type);
        }
        return result;
    }

    public <T extends NativeObject> List<T> toList(Class<T> type) {
        int size = (int)this.size();
        ArrayList<T> result = new ArrayList<T>(size);
        for (int i = 0; i < size; ++i) {
            result.add(this.get(i, type));
        }
        return result;
    }

    public <T extends NativeObject> T get(@MachineSizedSInt long index, Class<T> type) {
        return (T)this.getValueAtIndex(index).as(type);
    }

    @MachineSizedSInt
    public long size() {
        return this.getCount();
    }

    public void add(NativeObject value) {
        throw new UnsupportedOperationException("CFArray is immutable. Use CFMutableArray instead!");
    }

    public void insert(@MachineSizedSInt long idx, NativeObject value) {
        throw new UnsupportedOperationException("CFArray is immutable. Use CFMutableArray instead!");
    }

    public void replace(@MachineSizedSInt long idx, NativeObject value) {
        throw new UnsupportedOperationException("CFArray is immutable. Use CFMutableArray instead!");
    }

    public void remove(@MachineSizedSInt long idx) {
        throw new UnsupportedOperationException("CFArray is immutable. Use CFMutableArray instead!");
    }

    public void clear() {
        throw new UnsupportedOperationException("CFArray is immutable. Use CFMutableArray instead!");
    }

    public List<String> asStringList() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.size() == 0L) {
            return list;
        }
        int i = 0;
        while ((long)i < this.size()) {
            list.add(this.get(i, CFString.class).toString());
            ++i;
        }
        return list;
    }

    public static CFArray fromStrings(String ... strings) {
        int length = strings.length;
        CFType[] cfStrings = new CFString[length];
        for (int i = 0; i < length; ++i) {
            cfStrings[i] = new CFString(strings[i]);
        }
        return CFArray.create(cfStrings);
    }

    public static CFArray fromStrings(Collection<String> strings) {
        CFType[] cfStrings = new CFString[strings.size()];
        int i = 0;
        for (String s : strings) {
            cfStrings[i] = new CFString(s);
            ++i;
        }
        return CFArray.create(cfStrings);
    }

    @GlobalValue(symbol="kCFTypeArrayCallBacks", optional=true)
    @ByVal
    public static native CFArrayCallBacks getTypeCallBacks();

    @Bridge(symbol="CFArrayGetTypeID", optional=true)
    @MachineSizedUInt
    public static native long getClassTypeID();

    @Bridge(symbol="CFArrayCreate", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    private static native CFArray create(CFAllocator var0, VoidPtr.VoidPtrPtr var1, @MachineSizedSInt long var2, CFArrayCallBacks var4);

    @Bridge(symbol="CFArrayCreateCopy", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    private static native CFArray createCopy(CFAllocator var0, CFArray var1);

    @Bridge(symbol="CFArrayGetCount", optional=true)
    @MachineSizedSInt
    protected native long getCount();

    @Bridge(symbol="CFArrayGetCountOfValue", optional=true)
    @MachineSizedSInt
    protected native long getCountOfValue(@ByVal CFRange var1, VoidPtr var2);

    @Bridge(symbol="CFArrayContainsValue", optional=true)
    protected native boolean containsValue(@ByVal CFRange var1, VoidPtr var2);

    @Bridge(symbol="CFArrayGetValueAtIndex", optional=true)
    protected native VoidPtr getValueAtIndex(@MachineSizedSInt long var1);

    @Bridge(symbol="CFArrayGetValues", optional=true)
    protected native void getValues(@ByVal CFRange var1, VoidPtr.VoidPtrPtr var2);

    @Bridge(symbol="CFArrayApplyFunction", optional=true)
    protected native void applyFunction(@ByVal CFRange var1, FunctionPtr var2, VoidPtr var3);

    @Bridge(symbol="CFArrayGetFirstIndexOfValue", optional=true)
    @MachineSizedSInt
    protected native long getFirstIndexOfValue(@ByVal CFRange var1, VoidPtr var2);

    @Bridge(symbol="CFArrayGetLastIndexOfValue", optional=true)
    @MachineSizedSInt
    protected native long getLastIndexOfValue(@ByVal CFRange var1, VoidPtr var2);

    @Bridge(symbol="CFArrayBSearchValues", optional=true)
    @MachineSizedSInt
    protected native long bSearchValues(@ByVal CFRange var1, VoidPtr var2, FunctionPtr var3, VoidPtr var4);

    static {
        Bro.bind(CFArray.class);
    }

    public static class CFArrayPtr
    extends Ptr<CFArray, CFArrayPtr> {
    }

    public static class AsStringListMarshaler {
        @MarshalsPointer
        public static List<String> toObject(Class<? extends CFType> cls, long handle, long flags) {
            CFArray o = (CFArray)CFType.Marshaler.toObject(cls, handle, flags);
            if (o == null) {
                return null;
            }
            return o.asStringList();
        }

        @MarshalsPointer
        public static long toNative(List<String> l, long flags) {
            if (l == null) {
                return 0L;
            }
            return CFType.Marshaler.toNative(CFArray.fromStrings(l), flags);
        }
    }
}

