/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.corefoundation;

import org.robovm.apple.corefoundation.CFAllocator;
import org.robovm.apple.corefoundation.CFDictionary;
import org.robovm.apple.corefoundation.CFRange;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.coremedia.CMTextMarkupAttribute;
import org.robovm.apple.coremedia.CMTextMarkupAttributes;
import org.robovm.apple.coretext.CTAttributedStringAttribute;
import org.robovm.apple.coretext.CTAttributedStringAttributes;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.uikit.NSAttributedStringAttribute;
import org.robovm.apple.uikit.NSAttributedStringAttributes;
import org.robovm.rt.annotation.WeaklyLinked;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedSInt;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="CoreFoundation")
public class CFAttributedString
extends CFType {
    protected CFAttributedString() {
    }

    @WeaklyLinked
    public static CFAttributedString create(String str, NSAttributedStringAttributes attributes) {
        return CFAttributedString.create(null, str, attributes);
    }

    @WeaklyLinked
    public static CFAttributedString create(CFAllocator alloc, String str, NSAttributedStringAttributes attributes) {
        if (attributes == null) {
            return CFAttributedString.create(alloc, str, (CFDictionary)null);
        }
        return CFAttributedString.create(alloc, str, (CFDictionary)attributes.getDictionary().as(CFDictionary.class));
    }

    @WeaklyLinked
    public static CFAttributedString create(String str, CMTextMarkupAttributes attributes) {
        return CFAttributedString.create(null, str, attributes);
    }

    @WeaklyLinked
    public static CFAttributedString create(CFAllocator alloc, String str, CMTextMarkupAttributes attributes) {
        if (attributes == null) {
            return CFAttributedString.create(alloc, str, (CFDictionary)null);
        }
        return CFAttributedString.create(alloc, str, attributes.getDictionary());
    }

    @WeaklyLinked
    public static CFAttributedString create(String str, CTAttributedStringAttributes attributes) {
        return CFAttributedString.create(null, str, attributes);
    }

    @WeaklyLinked
    public static CFAttributedString create(CFAllocator alloc, String str, CTAttributedStringAttributes attributes) {
        if (attributes == null) {
            return CFAttributedString.create(alloc, str, (CFDictionary)null);
        }
        return CFAttributedString.create(alloc, str, attributes.getDictionary());
    }

    @WeaklyLinked
    public CFType getAttribute(long loc, NSAttributedStringAttribute attrName, CFRange effectiveRange) {
        if (attrName == null) {
            throw new NullPointerException("attrName");
        }
        return this.getAttribute(loc, (CFString)((NSString)attrName.value()).as(CFString.class), effectiveRange);
    }

    @WeaklyLinked
    public CFType getAttribute(long loc, CMTextMarkupAttribute attrName, CFRange effectiveRange) {
        if (attrName == null) {
            throw new NullPointerException("attrName");
        }
        return this.getAttribute(loc, (CFString)attrName.value(), effectiveRange);
    }

    @WeaklyLinked
    public CFType getAttribute(long loc, CTAttributedStringAttribute attrName, CFRange effectiveRange) {
        if (attrName == null) {
            throw new NullPointerException("attrName");
        }
        return this.getAttribute(loc, (CFString)attrName.value(), effectiveRange);
    }

    @WeaklyLinked
    public NSAttributedStringAttributes getAttributes(long loc, CFRange effectiveRange) {
        CFDictionary dict = this.getAttributesDictionary(loc, effectiveRange);
        if (dict == null) {
            return null;
        }
        return new NSAttributedStringAttributes((NSDictionary)dict.as(NSDictionary.class));
    }

    @WeaklyLinked
    public CMTextMarkupAttributes getTextMarkupAttributes(long loc, CFRange effectiveRange) {
        CFDictionary dict = this.getAttributesDictionary(loc, effectiveRange);
        if (dict == null) {
            return null;
        }
        return new CMTextMarkupAttributes(dict);
    }

    @WeaklyLinked
    public CTAttributedStringAttributes getCoreTextAttributes(long loc, CFRange effectiveRange) {
        CFDictionary dict = this.getAttributesDictionary(loc, effectiveRange);
        if (dict == null) {
            return null;
        }
        return new CTAttributedStringAttributes(null);
    }

    @Bridge(symbol="CFAttributedStringGetTypeID", optional=true)
    @MachineSizedUInt
    public static native long getClassTypeID();

    @Bridge(symbol="CFAttributedStringCreate", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CFAttributedString create(CFAllocator var0, String var1, CFDictionary var2);

    @Bridge(symbol="CFAttributedStringCreateWithSubstring", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CFAttributedString createWithSubstring(CFAllocator var0, CFAttributedString var1, @ByVal CFRange var2);

    @Bridge(symbol="CFAttributedStringCreateCopy", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CFAttributedString createCopy(CFAllocator var0, CFAttributedString var1);

    @Bridge(symbol="CFAttributedStringGetString", optional=true)
    public native String getString();

    @Bridge(symbol="CFAttributedStringGetLength", optional=true)
    @MachineSizedSInt
    public native long length();

    @Bridge(symbol="CFAttributedStringGetAttributes", optional=true)
    public native CFDictionary getAttributesDictionary(@MachineSizedSInt long var1, CFRange var3);

    @Bridge(symbol="CFAttributedStringGetAttribute", optional=true)
    public native CFType getAttribute(@MachineSizedSInt long var1, CFString var3, CFRange var4);

    static {
        Bro.bind(CFAttributedString.class);
    }

    public static class CFAttributedStringPtr
    extends Ptr<CFAttributedString, CFAttributedStringPtr> {
    }
}

