/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.corefoundation;

import org.robovm.apple.corefoundation.CFAllocator;
import org.robovm.apple.corefoundation.CFDate;
import org.robovm.apple.corefoundation.CFDateFormatterProperty;
import org.robovm.apple.corefoundation.CFDateFormatterStyle;
import org.robovm.apple.corefoundation.CFISO8601DateFormatOptions;
import org.robovm.apple.corefoundation.CFLocale;
import org.robovm.apple.corefoundation.CFRange;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.ptr.DoublePtr;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="CoreFoundation")
public class CFDateFormatter
extends CFType {
    protected CFDateFormatter() {
    }

    public static String getDateFormat(String tmplate, @MachineSizedUInt long options, CFLocale locale) {
        return CFDateFormatter.getDateFormat(null, tmplate, options, locale);
    }

    public static CFDateFormatter create(CFLocale locale, CFDateFormatterStyle dateStyle, CFDateFormatterStyle timeStyle) {
        return CFDateFormatter.create(null, locale, dateStyle, timeStyle);
    }

    public String format(CFDate date) {
        return CFDateFormatter.format(null, this, date);
    }

    public String format(double at) {
        return CFDateFormatter.format(null, this, at);
    }

    public CFDate parse(String string, CFRange rangep) {
        return CFDateFormatter.parse(null, this, string, rangep);
    }

    public double getAbsoluteTime(String string, CFRange rangep) {
        DoublePtr ptr = new DoublePtr();
        this.getAbsoluteTime(string, rangep, ptr);
        return ptr.get();
    }

    @Bridge(symbol="CFDateFormatterCreateDateFormatFromTemplate", optional=true)
    @Marshaler(value=CFString.AsStringNoRetainMarshaler.class)
    private static native String getDateFormat(CFAllocator var0, String var1, @MachineSizedUInt long var2, CFLocale var4);

    @Bridge(symbol="CFDateFormatterGetTypeID", optional=true)
    @MachineSizedUInt
    public static native long getClassTypeID();

    @Bridge(symbol="CFDateFormatterCreateISO8601Formatter", optional=true)
    public static native CFDateFormatter createISO8601Formatter(CFAllocator var0, CFISO8601DateFormatOptions var1);

    @Bridge(symbol="CFDateFormatterCreate", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CFDateFormatter create(CFAllocator var0, CFLocale var1, CFDateFormatterStyle var2, CFDateFormatterStyle var3);

    @Bridge(symbol="CFDateFormatterGetLocale", optional=true)
    public native CFLocale getLocale();

    @Bridge(symbol="CFDateFormatterGetDateStyle", optional=true)
    public native CFDateFormatterStyle getDateStyle();

    @Bridge(symbol="CFDateFormatterGetTimeStyle", optional=true)
    public native CFDateFormatterStyle getTimeStyle();

    @Bridge(symbol="CFDateFormatterGetFormat", optional=true)
    public native String getFormat();

    @Bridge(symbol="CFDateFormatterSetFormat", optional=true)
    public native void setFormat(String var1);

    @Bridge(symbol="CFDateFormatterCreateStringWithDate", optional=true)
    @Marshaler(value=CFString.AsStringNoRetainMarshaler.class)
    private static native String format(CFAllocator var0, CFDateFormatter var1, CFDate var2);

    @Bridge(symbol="CFDateFormatterCreateStringWithAbsoluteTime", optional=true)
    @Marshaler(value=CFString.AsStringNoRetainMarshaler.class)
    private static native String format(CFAllocator var0, CFDateFormatter var1, double var2);

    @Bridge(symbol="CFDateFormatterCreateDateFromString", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    private static native CFDate parse(CFAllocator var0, CFDateFormatter var1, String var2, CFRange var3);

    @Bridge(symbol="CFDateFormatterGetAbsoluteTimeFromString", optional=true)
    private native boolean getAbsoluteTime(String var1, CFRange var2, DoublePtr var3);

    @Bridge(symbol="CFDateFormatterSetProperty", optional=true)
    public native void setProperty(CFDateFormatterProperty var1, CFType var2);

    @Bridge(symbol="CFDateFormatterCopyProperty", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public native CFType getProperty(CFDateFormatterProperty var1);

    static {
        Bro.bind(CFDateFormatter.class);
    }

    public static class CFDateFormatterPtr
    extends Ptr<CFDateFormatter, CFDateFormatterPtr> {
    }
}

