/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.corefoundation;

import org.robovm.apple.corefoundation.CFAllocator;
import org.robovm.apple.corefoundation.CFAttributedString;
import org.robovm.apple.corefoundation.CFDictionary;
import org.robovm.apple.corefoundation.CFMutableString;
import org.robovm.apple.corefoundation.CFRange;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.coremedia.CMTextMarkupAttribute;
import org.robovm.apple.coremedia.CMTextMarkupAttributes;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.uikit.NSAttributedStringAttribute;
import org.robovm.apple.uikit.NSAttributedStringAttributes;
import org.robovm.rt.annotation.WeaklyLinked;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedSInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="CoreFoundation")
@WeaklyLinked
public class CFMutableAttributedString
extends CFAttributedString {
    protected CFMutableAttributedString() {
    }

    public static CFMutableAttributedString createCopy(@MachineSizedSInt long maxLength, CFAttributedString aStr) {
        return CFMutableAttributedString.createCopy(null, maxLength, aStr);
    }

    public static CFMutableAttributedString create(@MachineSizedSInt long maxLength) {
        return CFMutableAttributedString.create(null, maxLength);
    }

    @WeaklyLinked
    public void setAttributes(@ByVal CFRange range, NSAttributedStringAttributes replacement, boolean clearOtherAttributes) {
        if (replacement == null) {
            this.setAttributesDictionary(range, null, clearOtherAttributes);
        } else {
            this.setAttributesDictionary(range, (CFDictionary)replacement.getDictionary().as(CFDictionary.class), clearOtherAttributes);
        }
    }

    @WeaklyLinked
    public void setAttributes(@ByVal CFRange range, CMTextMarkupAttributes replacement, boolean clearOtherAttributes) {
        if (replacement == null) {
            this.setAttributesDictionary(range, null, clearOtherAttributes);
        } else {
            this.setAttributesDictionary(range, replacement.getDictionary(), clearOtherAttributes);
        }
    }

    @WeaklyLinked
    public void setAttribute(@ByVal CFRange range, NSAttributedStringAttribute attribute, CFType value) {
        if (attribute == null) {
            throw new NullPointerException("attribute");
        }
        this.setAttribute(range, (CFString)((NSString)attribute.value()).as(CFString.class), value);
    }

    @WeaklyLinked
    public void setAttribute(@ByVal CFRange range, CMTextMarkupAttribute attribute, CFType value) {
        if (attribute == null) {
            throw new NullPointerException("attribute");
        }
        this.setAttribute(range, (CFString)attribute.value(), value);
    }

    @WeaklyLinked
    public void removeAttribute(@ByVal CFRange range, NSAttributedStringAttribute attribute) {
        if (attribute == null) {
            throw new NullPointerException("attribute");
        }
        this.removeAttribute(range, (CFString)((NSString)attribute.value()).as(CFString.class));
    }

    @WeaklyLinked
    public void removeAttribute(@ByVal CFRange range, CMTextMarkupAttribute attribute) {
        if (attribute == null) {
            throw new NullPointerException("attribute");
        }
        this.removeAttribute(range, (CFString)attribute.value());
    }

    @Bridge(symbol="CFAttributedStringCreateMutableCopy", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CFMutableAttributedString createCopy(CFAllocator var0, @MachineSizedSInt long var1, CFAttributedString var3);

    @Bridge(symbol="CFAttributedStringCreateMutable", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CFMutableAttributedString create(CFAllocator var0, @MachineSizedSInt long var1);

    @Bridge(symbol="CFAttributedStringReplaceString", optional=true)
    public native void replaceString(@ByVal CFRange var1, String var2);

    @Bridge(symbol="CFAttributedStringGetMutableString", optional=true)
    public static native CFMutableString getMutableString(CFAttributedString var0);

    @Bridge(symbol="CFAttributedStringSetAttributes", optional=true)
    public native void setAttributesDictionary(@ByVal CFRange var1, CFDictionary var2, boolean var3);

    @Bridge(symbol="CFAttributedStringSetAttribute", optional=true)
    public native void setAttribute(@ByVal CFRange var1, CFString var2, CFType var3);

    @Bridge(symbol="CFAttributedStringRemoveAttribute", optional=true)
    public native void removeAttribute(@ByVal CFRange var1, CFString var2);

    @Bridge(symbol="CFAttributedStringReplaceAttributedString", optional=true)
    public native void replaceAttributedString(@ByVal CFRange var1, CFAttributedString var2);

    @Bridge(symbol="CFAttributedStringBeginEditing", optional=true)
    public native void beginEditing();

    @Bridge(symbol="CFAttributedStringEndEditing", optional=true)
    public native void endEditing();

    static {
        Bro.bind(CFMutableAttributedString.class);
    }

    public static class CFMutableAttributedStringPtr
    extends Ptr<CFMutableAttributedString, CFMutableAttributedStringPtr> {
    }
}

