/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.corefoundation;

import org.robovm.apple.corefoundation.CFAllocator;
import org.robovm.apple.corefoundation.CFLocale;
import org.robovm.apple.corefoundation.CFRange;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.corefoundation.CFStringCompareFlags;
import org.robovm.apple.corefoundation.CFStringEncodings;
import org.robovm.apple.corefoundation.CFStringNormalizationForm;
import org.robovm.apple.corefoundation.CFStringTransform;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedSInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.ptr.BytePtr;
import org.robovm.rt.bro.ptr.CharPtr;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="CoreFoundation")
public class CFMutableString
extends CFString {
    protected CFMutableString() {
    }

    public static CFMutableString create(@MachineSizedSInt long maxLength) {
        return CFMutableString.create((CFAllocator)null, maxLength);
    }

    public static CFMutableString createCopy(@MachineSizedSInt long maxLength, CFMutableString theString) {
        return CFMutableString.createCopy(null, maxLength, theString);
    }

    private void appendCharacters(char[] chars) {
        CharPtr ptr = new CharPtr();
        ptr.set(chars);
        this.appendCharacters(ptr, chars.length);
    }

    @Bridge(symbol="CFStringCreateMutable", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CFMutableString create(CFAllocator var0, @MachineSizedSInt long var1);

    @Bridge(symbol="CFStringCreateMutableCopy", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CFMutableString createCopy(CFAllocator var0, @MachineSizedSInt long var1, CFMutableString var3);

    @Bridge(symbol="CFStringAppend", optional=true)
    public native void append(String var1);

    @Bridge(symbol="CFStringAppendCharacters", optional=true)
    private native void appendCharacters(CharPtr var1, @MachineSizedSInt long var2);

    @Bridge(symbol="CFStringAppendPascalString", optional=true)
    public native void appendPascalString(BytePtr var1, CFStringEncodings var2);

    @Bridge(symbol="CFStringAppendCString", optional=true)
    public native void appendCString(BytePtr var1, CFStringEncodings var2);

    @Bridge(symbol="CFStringInsert", optional=true)
    public native void insert(@MachineSizedSInt long var1, String var3);

    @Bridge(symbol="CFStringDelete", optional=true)
    public native void delete(@ByVal CFRange var1);

    @Bridge(symbol="CFStringReplace", optional=true)
    public native void replace(@ByVal CFRange var1, String var2);

    @Bridge(symbol="CFStringReplaceAll", optional=true)
    public native void replaceAll(String var1);

    @Bridge(symbol="CFStringFindAndReplace", optional=true)
    @MachineSizedSInt
    public native long findAndReplace(String var1, String var2, @ByVal CFRange var3, CFStringCompareFlags var4);

    @Bridge(symbol="CFStringPad", optional=true)
    public native void pad(String var1, @MachineSizedSInt long var2, @MachineSizedSInt long var4);

    @Bridge(symbol="CFStringTrim", optional=true)
    public native void trim(String var1);

    @Bridge(symbol="CFStringTrimWhitespace", optional=true)
    public native void trimWhitespace();

    @Bridge(symbol="CFStringLowercase", optional=true)
    public native void lowercase(CFLocale var1);

    @Bridge(symbol="CFStringUppercase", optional=true)
    public native void uppercase(CFLocale var1);

    @Bridge(symbol="CFStringCapitalize", optional=true)
    public native void capitalize(CFLocale var1);

    @Bridge(symbol="CFStringNormalize", optional=true)
    public native void normalize(CFStringNormalizationForm var1);

    @Bridge(symbol="CFStringFold", optional=true)
    public native void fold(CFStringCompareFlags var1, CFLocale var2);

    @Bridge(symbol="CFStringTransform", optional=true)
    public native boolean transform(CFRange var1, CFStringTransform var2, boolean var3);

    static {
        Bro.bind(CFMutableString.class);
    }

    public static class CFMutableStringPtr
    extends Ptr<CFMutableString, CFMutableStringPtr> {
    }
}

