/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.corefoundation;

import org.robovm.apple.corefoundation.CFAllocator;
import org.robovm.apple.corefoundation.CFLocale;
import org.robovm.apple.corefoundation.CFNumber;
import org.robovm.apple.corefoundation.CFNumberFormatterOptionFlags;
import org.robovm.apple.corefoundation.CFNumberFormatterProperty;
import org.robovm.apple.corefoundation.CFNumberFormatterStyle;
import org.robovm.apple.corefoundation.CFNumberType;
import org.robovm.apple.corefoundation.CFRange;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.ptr.DoublePtr;
import org.robovm.rt.bro.ptr.IntPtr;
import org.robovm.rt.bro.ptr.Ptr;
import org.robovm.rt.bro.ptr.VoidPtr;

@Library(value="CoreFoundation")
public class CFNumberFormatter
extends CFType {
    protected CFNumberFormatter() {
    }

    public static CFNumberFormatter create(CFLocale locale, CFNumberFormatterStyle style) {
        return CFNumberFormatter.create(null, locale, style);
    }

    public String format(CFNumber number) {
        return CFNumberFormatter.format(null, this, number);
    }

    public CFNumber parse(String string, CFRange rangep, CFNumberFormatterOptionFlags options) {
        return CFNumberFormatter.parse(null, this, string, rangep, options);
    }

    public static int getDefaultFractionDigitsForCurrencyCode(String currencyCode) {
        IntPtr ptr = new IntPtr();
        CFNumberFormatter.getDecimalInfoForCurrencyCode(currencyCode, ptr, new DoublePtr());
        return ptr.get();
    }

    public static double getRoundingIncrementForCurrencyCode(String currencyCode) {
        DoublePtr ptr = new DoublePtr();
        CFNumberFormatter.getDecimalInfoForCurrencyCode(currencyCode, new IntPtr(), ptr);
        return ptr.get();
    }

    @Bridge(symbol="CFNumberFormatterGetTypeID", optional=true)
    @MachineSizedUInt
    public static native long getClassTypeID();

    @Bridge(symbol="CFNumberFormatterCreate", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CFNumberFormatter create(CFAllocator var0, CFLocale var1, CFNumberFormatterStyle var2);

    @Bridge(symbol="CFNumberFormatterGetLocale", optional=true)
    public native CFLocale getLocale();

    @Bridge(symbol="CFNumberFormatterGetStyle", optional=true)
    public native CFNumberFormatterStyle getStyle();

    @Bridge(symbol="CFNumberFormatterGetFormat", optional=true)
    public native String getFormat();

    @Bridge(symbol="CFNumberFormatterSetFormat", optional=true)
    public native void setFormat(String var1);

    @Bridge(symbol="CFNumberFormatterCreateStringWithNumber", optional=true)
    @Marshaler(value=CFString.AsStringNoRetainMarshaler.class)
    protected static native String format(CFAllocator var0, CFNumberFormatter var1, CFNumber var2);

    @Bridge(symbol="CFNumberFormatterCreateStringWithValue", optional=true)
    @Marshaler(value=CFString.AsStringNoRetainMarshaler.class)
    protected static native String formatValue(CFAllocator var0, CFNumberFormatter var1, CFNumberType var2, VoidPtr var3);

    @Bridge(symbol="CFNumberFormatterCreateNumberFromString", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    protected static native CFNumber parse(CFAllocator var0, CFNumberFormatter var1, String var2, CFRange var3, CFNumberFormatterOptionFlags var4);

    @Bridge(symbol="CFNumberFormatterGetValueFromString", optional=true)
    protected native boolean parseValue(String var1, CFRange var2, CFNumberType var3, VoidPtr var4);

    @Bridge(symbol="CFNumberFormatterSetProperty", optional=true)
    public native void setProperty(CFNumberFormatterProperty var1, CFType var2);

    @Bridge(symbol="CFNumberFormatterCopyProperty", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public native CFType getProperty(CFNumberFormatterProperty var1);

    @Bridge(symbol="CFNumberFormatterGetDecimalInfoForCurrencyCode", optional=true)
    private static native boolean getDecimalInfoForCurrencyCode(String var0, IntPtr var1, DoublePtr var2);

    static {
        Bro.bind(CFNumberFormatter.class);
    }

    public static class CFNumberFormatterPtr
    extends Ptr<CFNumberFormatter, CFNumberFormatterPtr> {
    }
}

