/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.corefoundation;

import org.robovm.apple.corefoundation.CFAllocator;
import org.robovm.apple.corefoundation.CFTreeContext;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedSInt;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.ptr.FunctionPtr;
import org.robovm.rt.bro.ptr.Ptr;
import org.robovm.rt.bro.ptr.VoidPtr;

@Library(value="CoreFoundation")
public class CFTree
extends CFType {
    protected CFTree() {
    }

    public static CFTree create() {
        return CFTree.create(null);
    }

    public static CFTree create(CFAllocator allocator) {
        return CFTree.create(allocator, new CFTreeContext());
    }

    public CFTree[] getChildren() {
        int n = (int)this.getChildCount();
        CFTree[] children = new CFTree[n];
        for (int i = 0; i < n; ++i) {
            children[i] = this.getChild(i);
        }
        return children;
    }

    @Bridge(symbol="CFTreeGetTypeID", optional=true)
    @MachineSizedUInt
    public static native long getClassTypeID();

    @Bridge(symbol="CFTreeCreate", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    private static native CFTree create(CFAllocator var0, CFTreeContext var1);

    @Bridge(symbol="CFTreeGetParent", optional=true)
    public native CFTree getParent();

    @Bridge(symbol="CFTreeGetNextSibling", optional=true)
    public native CFTree nextSibling();

    @Bridge(symbol="CFTreeGetFirstChild", optional=true)
    public native CFTree firstChild();

    @Bridge(symbol="CFTreeGetChildCount", optional=true)
    @MachineSizedSInt
    public native long getChildCount();

    @Bridge(symbol="CFTreeGetChildAtIndex", optional=true)
    public native CFTree getChild(@MachineSizedSInt long var1);

    @Bridge(symbol="CFTreeGetChildren", optional=true)
    private native void getChildren(CFTreePtr var1);

    @Bridge(symbol="CFTreeApplyFunctionToChildren", optional=true)
    private native void applyFunctionToChildren(FunctionPtr var1, VoidPtr var2);

    @Bridge(symbol="CFTreeFindRoot", optional=true)
    public native CFTree findRoot();

    @Bridge(symbol="CFTreePrependChild", optional=true)
    public native void prependChild(CFTree var1);

    @Bridge(symbol="CFTreeAppendChild", optional=true)
    public native void appendChild(CFTree var1);

    @Bridge(symbol="CFTreeInsertSibling", optional=true)
    public native void insertSibling(CFTree var1);

    @Bridge(symbol="CFTreeRemove", optional=true)
    public native void remove();

    @Bridge(symbol="CFTreeRemoveAllChildren", optional=true)
    public native void removeAllChildren();

    @Bridge(symbol="CFTreeSortChildren", optional=true)
    private native void sortChildren(FunctionPtr var1, VoidPtr var2);

    static {
        Bro.bind(CFTree.class);
    }

    public static class CFTreePtr
    extends Ptr<CFTree, CFTreePtr> {
    }
}

