/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.corefoundation;

import java.lang.reflect.Method;
import java.util.List;
import org.robovm.apple.corefoundation.CFAllocator;
import org.robovm.apple.corefoundation.CFArray;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.objc.LongMap;
import org.robovm.rt.VM;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedSInt;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Marshalers;
import org.robovm.rt.bro.annotation.MarshalsPointer;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="CoreFoundation")
@Marshalers(value={@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class), @org.robovm.rt.bro.annotation.Marshaler(value=CFString.AsStringMarshaler.class)})
public class CFType
extends NativeObject
implements AutoCloseable {
    private static final LongMap<Class<? extends CFType>> allCFTypeClasses = new LongMap();
    private static final int ABSTRACT = 1024;

    protected CFType() {
    }

    protected final void finalize() throws Throwable {
        this.dispose(true);
    }

    public final void dispose() {
        this.dispose(false);
    }

    protected void doDispose() {
        long handle = this.getHandle();
        if (handle != 0L) {
            CFType.release(handle);
        }
    }

    protected void dispose(boolean finalizing) {
        long handle = this.getHandle();
        if (handle != 0L) {
            this.doDispose();
            this.setHandle(0L);
        }
        if (finalizing) {
            try {
                super.finalize();
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public final void close() {
        try {
            this.dispose(false);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        try (CFString s = this.getDescription();){
            String string = s.toString();
            return string;
        }
    }

    @Bridge(symbol="CFGetTypeID")
    @MachineSizedUInt
    private static native long getTypeID(@Pointer long var0);

    @Bridge(symbol="CFRetain")
    @Pointer
    protected static native long retain(@Pointer long var0);

    @Bridge(symbol="CFRelease")
    protected static native void release(@Pointer long var0);

    @Bridge(symbol="CFGetTypeID", optional=true)
    @MachineSizedUInt
    public native long getTypeID();

    @Bridge(symbol="CFCopyTypeIDDescription", optional=true)
    public static native String getTypeIDDescription(@MachineSizedUInt long var0);

    @Bridge(symbol="CFRetain", optional=true)
    public native CFType retain();

    @Bridge(symbol="CFRelease", optional=true)
    public native void release();

    @Bridge(symbol="CFAutorelease", optional=true)
    public native CFType autorelease();

    @Bridge(symbol="CFGetRetainCount", optional=true)
    @MachineSizedSInt
    public native long getRetainCount();

    @Bridge(symbol="CFEqual", optional=true)
    public native boolean equalsTo(CFType var1);

    @Bridge(symbol="CFHash", optional=true)
    @MachineSizedUInt
    public native long hash();

    @Bridge(symbol="CFCopyDescription", optional=true)
    @org.robovm.rt.bro.annotation.Marshaler(value=NoRetainMarshaler.class)
    protected native CFString getDescription();

    @Bridge(symbol="CFGetAllocator", optional=true)
    public native CFAllocator getAllocator();

    @Bridge(symbol="CFMakeCollectable", optional=true)
    public native CFType makeCollectable();

    @Bridge(symbol="CFShow", optional=true)
    public native void show();

    static {
        Class[] classes = VM.listClasses(CFType.class, (ClassLoader)ClassLoader.getSystemClassLoader());
        Class[] emptyArgs = new Class[]{};
        Class<CFType> cfTypeClass = CFType.class;
        for (Class cls : classes) {
            if (cls == cfTypeClass || (cls.getModifiers() & 0x400) != 0) continue;
            try {
                Method m = cls.getDeclaredMethod("getClassTypeID", emptyArgs);
                m.setAccessible(true);
                Long typeId = (Long)m.invoke(null, new Object[0]);
                allCFTypeClasses.put(typeId.longValue(), (Object)cls);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        Bro.bind(CFType.class);
    }

    public static class NoRetainMarshaler {
        @MarshalsPointer
        public static CFType toObject(Class<? extends CFType> cls, long handle, long flags) {
            return Marshaler.toObject(cls, handle, flags, false);
        }

        @MarshalsPointer
        public static long toNative(CFType o, long flags) {
            return Marshaler.toNative(o, flags);
        }
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<?> toObject(Class<? extends CFType> cls, long handle, long flags) {
            CFArray o = (CFArray)Marshaler.toObject(cls, handle, flags);
            if (o == null) {
                return null;
            }
            return o.toList(CFType.class);
        }

        @MarshalsPointer
        public static long toNative(List<? extends CFType> l, long flags) {
            if (l == null) {
                return 0L;
            }
            CFArray o = null;
            o = l instanceof CFArray ? (CFArray)((Object)l) : CFArray.create(l);
            return Marshaler.toNative(o, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static CFType toObject(Class<? extends CFType> cls, long handle, long flags) {
            return Marshaler.toObject(cls, handle, flags, true);
        }

        static CFType toObject(Class<? extends CFType> cls, long handle, long flags, boolean retain) {
            if (handle == 0L) {
                return null;
            }
            long typeId = CFType.getTypeID(handle);
            Class cfTypeClass = (Class)allCFTypeClasses.get(typeId);
            if (cfTypeClass != null && cfTypeClass != cls && cls.isAssignableFrom(cfTypeClass)) {
                cls = cfTypeClass;
            }
            CFType o = (CFType)NativeObject.Marshaler.toObject(cls, (long)handle, (long)flags);
            if (retain) {
                CFType.retain(handle);
            }
            return o;
        }

        @MarshalsPointer
        public static long toNative(CFType o, long flags) {
            if (o == null) {
                return 0L;
            }
            if ((flags & 3L) > 0L) {
                o.retain();
            }
            return o.getHandle();
        }
    }

    public static class CFTypePtr
    extends Ptr<CFType, CFTypePtr> {
    }
}

