/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coregraphics;

import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicLong;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.coregraphics.CGFunctionCallbacks;
import org.robovm.objc.LongMap;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.Struct;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Callback;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.FloatPtr;
import org.robovm.rt.bro.ptr.FunctionPtr;
import org.robovm.rt.bro.ptr.MachineSizedFloatPtr;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="CoreGraphics")
public class CGFunction
extends CFType {
    private static AtomicLong infoId;
    private static final LongMap<Info> infos;
    private static final Method cbEvaluate;
    private static final Method cbReleaseInfo;

    protected CGFunction() {
    }

    public static CGFunction create(long domainDimension, double[] domain, long rangeDimension, double[] range, Evaluate evaluate) {
        return CGFunction.create(domainDimension, domain, domain != null ? domain.length : 0, rangeDimension, range, range != null ? range.length : 0, evaluate);
    }

    public static CGFunction create(long domainDimension, float[] domain, long rangeDimension, float[] range, Evaluate evaluate) {
        return CGFunction.create(domainDimension, domain, domain != null ? domain.length : 0, rangeDimension, range, range != null ? range.length : 0, evaluate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CGFunction create(long domainDimension, Object domain, int domainLength, long rangeDimension, Object range, int rangeLength, Evaluate evaluate) {
        if (domain != null && (long)domainLength != 2L * domainDimension) {
            throw new IllegalArgumentException("domain.length != 2 * domainDimension");
        }
        if (range != null && (long)rangeLength != 2L * rangeDimension) {
            throw new IllegalArgumentException("range.length != 2 * rangeDimension");
        }
        if (evaluate == null) {
            throw new NullPointerException("callback");
        }
        MachineSizedFloatPtr domainPtr = null;
        if (domain != null) {
            domainPtr = (MachineSizedFloatPtr)Struct.allocate(MachineSizedFloatPtr.class, (int)domainLength);
            if (domain instanceof double[]) {
                domainPtr.set((double[])domain);
            } else {
                domainPtr.set((float[])domain);
            }
        }
        MachineSizedFloatPtr rangePtr = null;
        if (range != null) {
            rangePtr = (MachineSizedFloatPtr)Struct.allocate(MachineSizedFloatPtr.class, (int)rangeLength);
            if (range instanceof double[]) {
                rangePtr.set((double[])range);
            } else {
                rangePtr.set((float[])range);
            }
        }
        Info info = new Info();
        info.domainDimension = domainDimension;
        info.rangeDimension = rangeDimension;
        info.evaluate = evaluate;
        CGFunctionCallbacks callbacks = new CGFunctionCallbacks();
        callbacks.setEvaluate(new FunctionPtr(cbEvaluate));
        callbacks.setReleaseInfo(new FunctionPtr(cbReleaseInfo));
        long infoId = CGFunction.infoId.getAndIncrement();
        CGFunction result = CGFunction.create(infoId, domainDimension, domainPtr, rangeDimension, rangePtr, callbacks);
        if (result != null) {
            LongMap<Info> longMap = infos;
            synchronized (longMap) {
                infos.put(infoId, (Object)info);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static void cbEvaluate(@Pointer long infoId, FloatPtr inDataPtr, FloatPtr outDataPtr) {
        Info info = null;
        LongMap<Info> longMap = infos;
        synchronized (longMap) {
            info = (Info)infos.get(infoId);
        }
        float[] inData = inDataPtr.toFloatArray((int)info.domainDimension);
        float[] outData = new float[(int)info.rangeDimension];
        info.evaluate.evaluate(inData, outData);
        outDataPtr.set(outData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static void cbReleaseInfo(@Pointer long infoId) {
        LongMap<Info> longMap = infos;
        synchronized (longMap) {
            infos.remove(infoId);
        }
    }

    @Bridge(symbol="CGFunctionGetTypeID", optional=true)
    @MachineSizedUInt
    public static native long getClassTypeID();

    @Bridge(symbol="CGFunctionCreate", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    private static native CGFunction create(@Pointer long var0, @MachineSizedUInt long var2, MachineSizedFloatPtr var4, @MachineSizedUInt long var5, MachineSizedFloatPtr var7, CGFunctionCallbacks var8);

    static {
        Bro.bind(CGFunction.class);
        infoId = new AtomicLong();
        infos = new LongMap();
        try {
            cbEvaluate = CGFunction.class.getDeclaredMethod("cbEvaluate", Long.TYPE, FloatPtr.class, FloatPtr.class);
            cbReleaseInfo = CGFunction.class.getDeclaredMethod("cbReleaseInfo", Long.TYPE);
        }
        catch (Throwable e) {
            throw new Error(e);
        }
    }

    public static interface Evaluate {
        public void evaluate(float[] var1, float[] var2);
    }

    static class Info {
        long domainDimension;
        long rangeDimension;
        Evaluate evaluate;

        Info() {
        }
    }

    public static class CGFunctionPtr
    extends Ptr<CGFunction, CGFunctionPtr> {
    }
}

