/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coregraphics;

import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicLong;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.coregraphics.CGAffineTransform;
import org.robovm.apple.coregraphics.CGContext;
import org.robovm.apple.coregraphics.CGPatternCallbacks;
import org.robovm.apple.coregraphics.CGPatternTiling;
import org.robovm.apple.coregraphics.CGRect;
import org.robovm.objc.LongMap;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.Callback;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedFloat;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.FunctionPtr;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="CoreGraphics")
public class CGPattern
extends CFType {
    private static AtomicLong infoId;
    private static final LongMap<DrawPattern> infos;
    private static final Method cbDrawPattern;
    private static final Method cbReleaseInfo;

    protected CGPattern() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CGPattern create(CGRect bounds, CGAffineTransform matrix, double xStep, double yStep, CGPatternTiling tiling, boolean isColored, DrawPattern drawPattern) {
        long infoId = CGPattern.infoId.getAndIncrement();
        CGPatternCallbacks callbacks = new CGPatternCallbacks();
        callbacks.setDrawPattern(new FunctionPtr(cbDrawPattern));
        callbacks.setReleaseInfo(new FunctionPtr(cbReleaseInfo));
        CGPattern result = CGPattern.create(infoId, bounds, matrix, xStep, yStep, tiling, isColored, callbacks);
        if (result != null) {
            LongMap<DrawPattern> longMap = infos;
            synchronized (longMap) {
                infos.put(infoId, (Object)drawPattern);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static void cbDrawPattern(@Pointer long infoId, CGContext context) {
        DrawPattern drawPattern = null;
        LongMap<DrawPattern> longMap = infos;
        synchronized (longMap) {
            drawPattern = (DrawPattern)infos.get(infoId);
        }
        drawPattern.drawPattern(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static void cbReleaseInfo(@Pointer long infoId) {
        LongMap<DrawPattern> longMap = infos;
        synchronized (longMap) {
            infos.remove(infoId);
        }
    }

    @Bridge(symbol="CGPatternGetTypeID", optional=true)
    @MachineSizedUInt
    public static native long getClassTypeID();

    @Bridge(symbol="CGPatternCreate", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    private static native CGPattern create(@Pointer long var0, @ByVal CGRect var2, @ByVal CGAffineTransform var3, @MachineSizedFloat double var4, @MachineSizedFloat double var6, CGPatternTiling var8, boolean var9, CGPatternCallbacks var10);

    static {
        Bro.bind(CGPattern.class);
        infoId = new AtomicLong();
        infos = new LongMap();
        try {
            cbDrawPattern = CGPattern.class.getDeclaredMethod("cbDrawPattern", Long.TYPE, CGContext.class);
            cbReleaseInfo = CGPattern.class.getDeclaredMethod("cbReleaseInfo", Long.TYPE);
        }
        catch (Throwable e) {
            throw new Error(e);
        }
    }

    public static interface DrawPattern {
        public void drawPattern(CGContext var1);
    }

    public static class CGPatternPtr
    extends Ptr<CGPattern, CGPatternPtr> {
    }
}

