/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coregraphics;

import org.robovm.apple.coregraphics.CGPDFTagType;
import org.robovm.apple.foundation.CocoaUtility;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.ptr.BytePtr;
import org.robovm.rt.bro.ptr.VoidPtr;

@Library(value="CoreGraphics")
class CoreGraphics
extends CocoaUtility {
    CoreGraphics() {
    }

    private static float[] doublesToFloats(double[] doubles) {
        float[] floats = new float[doubles.length];
        for (int i = 0; i < floats.length; ++i) {
            floats[i] = (float)doubles[i];
        }
        return floats;
    }

    private static double[] floatsToDoubles(float[] floats) {
        double[] doubles = new double[floats.length];
        for (int i = 0; i < doubles.length; ++i) {
            doubles[i] = floats[i];
        }
        return doubles;
    }

    static Object toMachineSizedFloatArray(Object array) {
        if (array == null) {
            throw new NullPointerException();
        }
        if (VoidPtr.sizeOf() == 4 && array instanceof double[]) {
            return CoreGraphics.doublesToFloats((double[])array);
        }
        if (VoidPtr.sizeOf() == 8 && array instanceof float[]) {
            return CoreGraphics.floatsToDoubles((float[])array);
        }
        return array;
    }

    @GlobalValue(symbol="kCGPDFTagPropertyActualText", optional=true)
    public static native String kCGPDFTagPropertyActualText();

    @GlobalValue(symbol="kCGPDFTagPropertyAlternativeText", optional=true)
    public static native String kCGPDFTagPropertyAlternativeText();

    @GlobalValue(symbol="kCGPDFTagPropertyTitleText", optional=true)
    public static native String kCGPDFTagPropertyTitleText();

    @GlobalValue(symbol="kCGPDFTagPropertyLanguageText", optional=true)
    public static native String kCGPDFTagPropertyLanguageText();

    @Bridge(symbol="CGPDFTagTypeGetName", optional=true)
    public static native BytePtr cGPDFTagTypeGetName(CGPDFTagType var0);

    static {
        Bro.bind(CoreGraphics.class);
    }
}

