/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coreimage;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSDictionaryWrapper;
import org.robovm.apple.foundation.NSMutableArray;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.imageio.CGImagePropertyOrientation;
import org.robovm.rt.annotation.WeaklyLinked;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="CoreImage")
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
public class CIDetectorFeatureOptions
extends NSDictionaryWrapper {
    CIDetectorFeatureOptions(NSDictionary data) {
        super(data);
    }

    public CIDetectorFeatureOptions() {
    }

    public boolean has(NSString key) {
        return this.data.containsKey(key);
    }

    public NSObject get(NSString key) {
        if (this.has(key)) {
            return this.data.get(key);
        }
        return null;
    }

    public CIDetectorFeatureOptions set(NSString key, NSObject value) {
        this.data.put(key, value);
        return this;
    }

    public boolean recognizesEyeBlinks() {
        if (this.has(Keys.EyeBlink())) {
            NSNumber val = (NSNumber)this.get(Keys.EyeBlink());
            return val.booleanValue();
        }
        return false;
    }

    public CIDetectorFeatureOptions setRecognizesEyeBlinks(boolean recognizesEyeBlinks) {
        this.set(Keys.EyeBlink(), NSNumber.valueOf(recognizesEyeBlinks));
        return this;
    }

    public boolean recognizesSmiles() {
        if (this.has(Keys.Smile())) {
            NSNumber val = (NSNumber)this.get(Keys.Smile());
            return val.booleanValue();
        }
        return false;
    }

    public CIDetectorFeatureOptions setRecognizesSmiles(boolean recognizesSmiles) {
        this.set(Keys.Smile(), NSNumber.valueOf(recognizesSmiles));
        return this;
    }

    public double getFocalLength() {
        if (this.has(Keys.FocalLength())) {
            NSNumber val = (NSNumber)this.get(Keys.FocalLength());
            return val.doubleValue();
        }
        return 0.0;
    }

    public CIDetectorFeatureOptions setFocalLength(double focalLength) {
        this.set(Keys.FocalLength(), NSNumber.valueOf(focalLength));
        return this;
    }

    public double getAspectRatio() {
        if (this.has(Keys.AspectRatio())) {
            NSNumber val = (NSNumber)this.get(Keys.AspectRatio());
            return val.doubleValue();
        }
        return 0.0;
    }

    public CIDetectorFeatureOptions setAspectRatio(double aspectRatio) {
        this.set(Keys.AspectRatio(), NSNumber.valueOf(aspectRatio));
        return this;
    }

    @WeaklyLinked
    public CGImagePropertyOrientation getImageOrientation() {
        if (this.has(Keys.ImageOrientation())) {
            NSNumber val = (NSNumber)this.get(Keys.ImageOrientation());
            return CGImagePropertyOrientation.valueOf(val.longValue());
        }
        return null;
    }

    @WeaklyLinked
    public CIDetectorFeatureOptions setImageOrientation(CGImagePropertyOrientation imageOrientation) {
        this.set(Keys.ImageOrientation(), NSNumber.valueOf(imageOrientation.value()));
        return this;
    }

    @Library(value="CoreImage")
    public static class Keys {
        @GlobalValue(symbol="CIDetectorImageOrientation", optional=true)
        public static native NSString ImageOrientation();

        @GlobalValue(symbol="CIDetectorEyeBlink", optional=true)
        public static native NSString EyeBlink();

        @GlobalValue(symbol="CIDetectorSmile", optional=true)
        public static native NSString Smile();

        @GlobalValue(symbol="CIDetectorFocalLength", optional=true)
        public static native NSString FocalLength();

        @GlobalValue(symbol="CIDetectorAspectRatio", optional=true)
        public static native NSString AspectRatio();

        static {
            Bro.bind(Keys.class);
        }
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<CIDetectorFeatureOptions> toObject(Class<? extends NSObject> cls, long handle, long flags) {
            NSArray o = (NSArray)NSObject.Marshaler.toObject(NSArray.class, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<CIDetectorFeatureOptions> list = new ArrayList<CIDetectorFeatureOptions>();
            for (int i = 0; i < o.size(); ++i) {
                list.add(new CIDetectorFeatureOptions((NSDictionary)o.get(i)));
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<CIDetectorFeatureOptions> l, long flags) {
            if (l == null) {
                return 0L;
            }
            NSMutableArray<NSDictionary> array = new NSMutableArray<NSDictionary>();
            for (CIDetectorFeatureOptions i : l) {
                array.add(i.getDictionary());
            }
            return NSObject.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static CIDetectorFeatureOptions toObject(Class<CIDetectorFeatureOptions> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new CIDetectorFeatureOptions(o);
        }

        @MarshalsPointer
        public static long toNative(CIDetectorFeatureOptions o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

