/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coreimage;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.coreimage.CIFilterAttributeType;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSDictionaryWrapper;
import org.robovm.apple.foundation.NSMutableArray;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="CoreImage")
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
public class CIFilterAttribute
extends NSDictionaryWrapper {
    CIFilterAttribute(NSDictionary data) {
        super(data);
    }

    public boolean has(NSString key) {
        return this.data.containsKey(key);
    }

    public NSObject get(NSString key) {
        if (this.has(key)) {
            return this.data.get(key);
        }
        return null;
    }

    public String getAttributeClassName() {
        if (this.has(Keys.Class())) {
            NSString val = (NSString)this.get(Keys.Class());
            return val.toString();
        }
        return null;
    }

    public CIFilterAttributeType getType() {
        if (this.has(Keys.Type())) {
            NSString val = (NSString)this.get(Keys.Type());
            return CIFilterAttributeType.valueOf(val);
        }
        return null;
    }

    public double getMin() {
        if (this.has(Keys.Min())) {
            NSNumber val = (NSNumber)this.get(Keys.Min());
            return val.doubleValue();
        }
        return 0.0;
    }

    public double getMax() {
        if (this.has(Keys.Max())) {
            NSNumber val = (NSNumber)this.get(Keys.Max());
            return val.doubleValue();
        }
        return 0.0;
    }

    public double getSliderMin() {
        if (this.has(Keys.SliderMin())) {
            NSNumber val = (NSNumber)this.get(Keys.SliderMin());
            return val.doubleValue();
        }
        return 0.0;
    }

    public double getSliderMax() {
        if (this.has(Keys.SliderMax())) {
            NSNumber val = (NSNumber)this.get(Keys.SliderMax());
            return val.doubleValue();
        }
        return 0.0;
    }

    public double getDefault() {
        if (this.has(Keys.Default())) {
            NSNumber val = (NSNumber)this.get(Keys.Default());
            return val.doubleValue();
        }
        return 0.0;
    }

    public double getIdentity() {
        if (this.has(Keys.Identity())) {
            NSNumber val = (NSNumber)this.get(Keys.Identity());
            return val.doubleValue();
        }
        return 0.0;
    }

    public String getName() {
        if (this.has(Keys.Name())) {
            NSString val = (NSString)this.get(Keys.Name());
            return val.toString();
        }
        return null;
    }

    public String getDisplayName() {
        if (this.has(Keys.DisplayName())) {
            NSString val = (NSString)this.get(Keys.DisplayName());
            return val.toString();
        }
        return null;
    }

    @Library(value="CoreImage")
    public static class Keys {
        @GlobalValue(symbol="kCIAttributeDescription", optional=true)
        public static native NSString Description();

        @GlobalValue(symbol="kCIAttributeReferenceDocumentation", optional=true)
        public static native NSString ReferenceDocumentation();

        @GlobalValue(symbol="kCIAttributeClass", optional=true)
        public static native NSString Class();

        @GlobalValue(symbol="kCIAttributeType", optional=true)
        public static native NSString Type();

        @GlobalValue(symbol="kCIAttributeMin", optional=true)
        public static native NSString Min();

        @GlobalValue(symbol="kCIAttributeMax", optional=true)
        public static native NSString Max();

        @GlobalValue(symbol="kCIAttributeSliderMin", optional=true)
        public static native NSString SliderMin();

        @GlobalValue(symbol="kCIAttributeSliderMax", optional=true)
        public static native NSString SliderMax();

        @GlobalValue(symbol="kCIAttributeDefault", optional=true)
        public static native NSString Default();

        @GlobalValue(symbol="kCIAttributeIdentity", optional=true)
        public static native NSString Identity();

        @GlobalValue(symbol="kCIAttributeName", optional=true)
        public static native NSString Name();

        @GlobalValue(symbol="kCIAttributeDisplayName", optional=true)
        public static native NSString DisplayName();

        static {
            Bro.bind(Keys.class);
        }
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<CIFilterAttribute> toObject(Class<? extends NSObject> cls, long handle, long flags) {
            NSArray o = (NSArray)NSObject.Marshaler.toObject(NSArray.class, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<CIFilterAttribute> list = new ArrayList<CIFilterAttribute>();
            for (int i = 0; i < o.size(); ++i) {
                list.add(new CIFilterAttribute((NSDictionary)o.get(i)));
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<CIFilterAttribute> l, long flags) {
            if (l == null) {
                return 0L;
            }
            NSMutableArray<NSDictionary> array = new NSMutableArray<NSDictionary>();
            for (CIFilterAttribute i : l) {
                array.add(i.getDictionary());
            }
            return NSObject.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static CIFilterAttribute toObject(Class<CIFilterAttribute> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new CIFilterAttribute(o);
        }

        @MarshalsPointer
        public static long toNative(CIFilterAttribute o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

