/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coremedia;

import org.robovm.apple.corefoundation.CFAllocator;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.corefoundation.OSStatus;
import org.robovm.apple.corefoundation.OSStatusException;
import org.robovm.apple.coremedia.CMClock;
import org.robovm.apple.coremedia.CMClockOrTimebase;
import org.robovm.apple.coremedia.CMTime;
import org.robovm.apple.coremedia.CMTimeRoundingMethod;
import org.robovm.apple.dispatch.DispatchSource;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSNotification;
import org.robovm.apple.foundation.NSNotificationCenter;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSOperationQueue;
import org.robovm.apple.foundation.NSRunLoop;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.foundation.NSTimer;
import org.robovm.objc.block.VoidBlock1;
import org.robovm.objc.block.VoidBlock2;
import org.robovm.rt.annotation.WeaklyLinked;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="CoreMedia")
public class CMTimebase
extends CMClockOrTimebase {
    protected CMTimebase() {
    }

    public static CMTimebase create(CMClock masterClock) throws OSStatusException {
        CMTimebasePtr ptr = new CMTimebasePtr();
        OSStatus status = CMTimebase.create0(null, masterClock, ptr);
        OSStatusException.throwIfNecessary(status);
        return (CMTimebase)ptr.get();
    }

    public static CMTimebase create(CMTimebase masterTimebase) throws OSStatusException {
        CMTimebasePtr ptr = new CMTimebasePtr();
        OSStatus status = CMTimebase.create0(null, masterTimebase, ptr);
        OSStatusException.throwIfNecessary(status);
        return (CMTimebase)ptr.get();
    }

    public void setTime(CMTime time) throws OSStatusException {
        OSStatus status = this.setTime0(time);
        OSStatusException.throwIfNecessary(status);
    }

    public void setAnchorTime(CMTime timebaseTime, CMTime immediateMasterTime) throws OSStatusException {
        OSStatus status = this.setAnchorTime0(timebaseTime, immediateMasterTime);
        OSStatusException.throwIfNecessary(status);
    }

    public void setRate(double rate) throws OSStatusException {
        OSStatus status = this.setRate0(rate);
        OSStatusException.throwIfNecessary(status);
    }

    public void setRateAndAnchorTime(double rate, CMTime timebaseTime, CMTime immediateMasterTime) throws OSStatusException {
        OSStatus status = this.setRateAndAnchorTime0(rate, timebaseTime, immediateMasterTime);
        OSStatusException.throwIfNecessary(status);
    }

    public void addTimer(NSTimer timer, NSRunLoop runloop) throws OSStatusException {
        OSStatus status = this.addTimer0(timer, runloop);
        OSStatusException.throwIfNecessary(status);
    }

    public void removeTimer(NSTimer timer) throws OSStatusException {
        OSStatus status = this.removeTimer0(timer);
        OSStatusException.throwIfNecessary(status);
    }

    public void setTimerNextFireTime(NSTimer timer, CMTime fireTime) throws OSStatusException {
        OSStatus status = this.setTimerNextFireTime0(timer, fireTime, 0);
        OSStatusException.throwIfNecessary(status);
    }

    public void setTimerToFireImmediately(NSTimer timer) throws OSStatusException {
        OSStatus status = this.setTimerToFireImmediately0(timer);
        OSStatusException.throwIfNecessary(status);
    }

    @WeaklyLinked
    public void addTimerDispatchSource(DispatchSource timerSource) throws OSStatusException {
        OSStatus status = this.addTimerDispatchSource0(timerSource);
        OSStatusException.throwIfNecessary(status);
    }

    @WeaklyLinked
    public void removeTimerDispatchSource(DispatchSource timerSource) throws OSStatusException {
        OSStatus status = this.removeTimerDispatchSource0(timerSource);
        OSStatusException.throwIfNecessary(status);
    }

    @WeaklyLinked
    public void setTimerDispatchSourceNextFireTime(DispatchSource timerSource, CMTime fireTime) throws OSStatusException {
        OSStatus status = this.setTimerDispatchSourceNextFireTime0(timerSource, fireTime, 0);
        OSStatusException.throwIfNecessary(status);
    }

    @WeaklyLinked
    public void setTimerDispatchSourceToFireImmediately(DispatchSource timerSource) throws OSStatusException {
        OSStatus status = this.setTimerDispatchSourceToFireImmediately0(timerSource);
        OSStatusException.throwIfNecessary(status);
    }

    public void notificationBarrier() throws OSStatusException {
        OSStatus status = this.notificationBarrier0();
        OSStatusException.throwIfNecessary(status);
    }

    @GlobalValue(symbol="kCMTimebaseNotification_EffectiveRateChanged", optional=true)
    public static native NSString EffectiveRateChangedNotification();

    @GlobalValue(symbol="kCMTimebaseNotification_TimeJumped", optional=true)
    public static native NSString TimeJumpedNotification();

    @GlobalValue(symbol="kCMTimebaseNotificationKey_EventTime", optional=true)
    protected static native NSString EventTimeNotificationKey();

    @Bridge(symbol="CMTimebaseGetTypeID", optional=true)
    @MachineSizedUInt
    public static native long getClassTypeID();

    @Bridge(symbol="CMTimebaseCreateWithMasterClock", optional=true)
    protected static native OSStatus create0(CFAllocator var0, CMClock var1, CMTimebasePtr var2);

    @Bridge(symbol="CMTimebaseCreateWithMasterTimebase", optional=true)
    protected static native OSStatus create0(CFAllocator var0, CMTimebase var1, CMTimebasePtr var2);

    @Bridge(symbol="CMTimebaseCopyMasterTimebase", optional=true)
    protected native CMTimebase copyMasterTimebase0();

    @Bridge(symbol="CMTimebaseCopyMasterClock", optional=true)
    protected native CMClock copyMasterClock0();

    @Bridge(symbol="CMTimebaseCopyMaster", optional=true)
    protected native CFType copyMaster0();

    @Bridge(symbol="CMTimebaseCopyUltimateMasterClock", optional=true)
    protected native CMClock copyUltimateMasterClock0();

    @Deprecated
    @Bridge(symbol="CMTimebaseGetMasterTimebase", optional=true)
    public native CMTimebase getMasterTimebase();

    @Deprecated
    @Bridge(symbol="CMTimebaseGetMasterClock", optional=true)
    public native CMClock getMasterClock();

    @Deprecated
    @Bridge(symbol="CMTimebaseGetMaster", optional=true)
    public native CMTimebase getMaster();

    @Deprecated
    @Bridge(symbol="CMTimebaseGetUltimateMasterClock", optional=true)
    public native CMClock getUltimateMasterClock();

    @Bridge(symbol="CMTimebaseSetMasterClock", optional=true)
    protected native OSStatus setMasterClock0(CMClock var1);

    @Bridge(symbol="CMTimebaseSetMasterTimebase", optional=true)
    protected native OSStatus setMasterTimebase0(CMTimebase var1);

    @Override
    @Bridge(symbol="CMTimebaseGetTime", optional=true)
    @ByVal
    public native CMTime getTime();

    @Bridge(symbol="CMTimebaseGetTimeWithTimeScale", optional=true)
    @ByVal
    public native CMTime getTime(int var1, CMTimeRoundingMethod var2);

    @Bridge(symbol="CMTimebaseSetTime", optional=true)
    protected native OSStatus setTime0(@ByVal CMTime var1);

    @Bridge(symbol="CMTimebaseSetAnchorTime", optional=true)
    protected native OSStatus setAnchorTime0(@ByVal CMTime var1, @ByVal CMTime var2);

    @Bridge(symbol="CMTimebaseGetRate", optional=true)
    public native double getRate();

    @Bridge(symbol="CMTimebaseSetRate", optional=true)
    protected native OSStatus setRate0(double var1);

    @Bridge(symbol="CMTimebaseSetRateAndAnchorTime", optional=true)
    protected native OSStatus setRateAndAnchorTime0(double var1, @ByVal CMTime var3, @ByVal CMTime var4);

    @Bridge(symbol="CMTimebaseGetEffectiveRate", optional=true)
    public native double getEffectiveRate();

    @Bridge(symbol="CMTimebaseAddTimer", optional=true)
    protected native OSStatus addTimer0(NSTimer var1, NSRunLoop var2);

    @Bridge(symbol="CMTimebaseRemoveTimer", optional=true)
    protected native OSStatus removeTimer0(NSTimer var1);

    @Bridge(symbol="CMTimebaseSetTimerNextFireTime", optional=true)
    protected native OSStatus setTimerNextFireTime0(NSTimer var1, @ByVal CMTime var2, int var3);

    @Bridge(symbol="CMTimebaseSetTimerToFireImmediately", optional=true)
    protected native OSStatus setTimerToFireImmediately0(NSTimer var1);

    @Bridge(symbol="CMTimebaseAddTimerDispatchSource", optional=true)
    @WeaklyLinked
    protected native OSStatus addTimerDispatchSource0(DispatchSource var1);

    @Bridge(symbol="CMTimebaseRemoveTimerDispatchSource", optional=true)
    @WeaklyLinked
    protected native OSStatus removeTimerDispatchSource0(DispatchSource var1);

    @Bridge(symbol="CMTimebaseSetTimerDispatchSourceNextFireTime", optional=true)
    @WeaklyLinked
    protected native OSStatus setTimerDispatchSourceNextFireTime0(DispatchSource var1, @ByVal CMTime var2, int var3);

    @Bridge(symbol="CMTimebaseSetTimerDispatchSourceToFireImmediately", optional=true)
    @WeaklyLinked
    protected native OSStatus setTimerDispatchSourceToFireImmediately0(DispatchSource var1);

    @Bridge(symbol="CMTimebaseNotificationBarrier", optional=true)
    protected native OSStatus notificationBarrier0();

    static {
        Bro.bind(CMTimebase.class);
    }

    public static class CMTimebasePtr
    extends Ptr<CMTimebase, CMTimebasePtr> {
    }

    public static class Notifications {
        public static NSObject observeEffectiveRateChanged(CMTimebase object, final VoidBlock2<CMTimebase, CMTime> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(CMTimebase.EffectiveRateChangedNotification(), (NSObject)object.as(NSObject.class), NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    CMTimebase object = a.getObject() != null ? (CMTimebase)a.getObject().as(CMTimebase.class) : null;
                    CMTime time = null;
                    NSDictionary<?, ?> data = a.getUserInfo();
                    if (data.containsKey(CMTimebase.EventTimeNotificationKey())) {
                        time = (CMTime)data.get(CMTimebase.EventTimeNotificationKey()).as(CMTime.class);
                    }
                    block.invoke((Object)object, time);
                }
            });
        }

        public static NSObject observeTimeJumped(CMTimebase object, final VoidBlock2<CMTimebase, CMTime> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(CMTimebase.TimeJumpedNotification(), (NSObject)object.as(NSObject.class), NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    CMTimebase object = a.getObject() != null ? (CMTimebase)a.getObject().as(CMTimebase.class) : null;
                    CMTime time = null;
                    NSDictionary<?, ?> data = a.getUserInfo();
                    if (data.containsKey(CMTimebase.EventTimeNotificationKey())) {
                        time = (CMTime)data.get(CMTimebase.EventTimeNotificationKey()).as(CMTime.class);
                    }
                    block.invoke((Object)object, time);
                }
            });
        }
    }
}

