/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coremidi;

import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicLong;
import org.robovm.apple.coremidi.MIDIClient;
import org.robovm.apple.coremidi.MIDIEntity;
import org.robovm.apple.coremidi.MIDIError;
import org.robovm.apple.coremidi.MIDIObject;
import org.robovm.apple.coremidi.MIDIPacketList;
import org.robovm.apple.coremidi.MIDIReadProc;
import org.robovm.objc.LongMap;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Callback;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.FunctionPtr;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="CoreMIDI")
public class MIDIEndpoint
extends MIDIObject {
    private static AtomicLong refconId = new AtomicLong();
    private static LongMap<MIDIReadProc> readProcs = new LongMap();
    private static final Method cbReadProc;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static void cbReadProc(MIDIPacketList pktlist, @Pointer long readProcRefCon, @Pointer long srcConnRefCon) {
        MIDIReadProc callback = null;
        LongMap<MIDIReadProc> longMap = readProcs;
        synchronized (longMap) {
            callback = (MIDIReadProc)readProcs.get(readProcRefCon);
        }
        callback.read(pktlist);
    }

    public MIDIEntity getEntity() {
        MIDIEntity.MIDIEntityPtr ptr = new MIDIEntity.MIDIEntityPtr();
        this.getEntity(ptr);
        return (MIDIEntity)ptr.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MIDIEndpoint createDestination(MIDIClient client, String name, MIDIReadProc readProc) {
        MIDIEndpointPtr ptr;
        long refconId = MIDIEndpoint.refconId.getAndIncrement();
        MIDIError err = MIDIEndpoint.createDestination(client, name, new FunctionPtr(cbReadProc), refconId, ptr = new MIDIEndpointPtr());
        if (err == MIDIError.No) {
            LongMap<MIDIReadProc> longMap = readProcs;
            synchronized (longMap) {
                readProcs.put(refconId, (Object)readProc);
            }
            return (MIDIEndpoint)ptr.get();
        }
        return null;
    }

    public static MIDIEndpoint createSource(MIDIClient client, String name) {
        MIDIEndpointPtr ptr = new MIDIEndpointPtr();
        MIDIEndpoint.createSource(client, name, ptr);
        return (MIDIEndpoint)ptr.get();
    }

    @Bridge(symbol="MIDIEndpointGetEntity", optional=true)
    protected native MIDIError getEntity(MIDIEntity.MIDIEntityPtr var1);

    @Bridge(symbol="MIDIDestinationCreate", optional=true)
    protected static native MIDIError createDestination(MIDIClient var0, String var1, FunctionPtr var2, @Pointer long var3, MIDIEndpointPtr var5);

    @Bridge(symbol="MIDISourceCreate", optional=true)
    protected static native MIDIError createSource(MIDIClient var0, String var1, MIDIEndpointPtr var2);

    @Bridge(symbol="MIDIEndpointDispose", optional=true)
    public native MIDIError dispose();

    @Bridge(symbol="MIDIReceived", optional=true)
    public native MIDIError received(MIDIPacketList var1);

    @Bridge(symbol="MIDIEndpointSetRefCons", optional=true)
    protected native MIDIError setRefCons(@Pointer long var1, @Pointer long var3);

    static {
        try {
            cbReadProc = MIDIEndpoint.class.getDeclaredMethod("cbReadProc", MIDIPacketList.class, Long.TYPE, Long.TYPE);
        }
        catch (Throwable e) {
            throw new Error(e);
        }
        Bro.bind(MIDIEndpoint.class);
    }

    public static class MIDIEndpointPtr
    extends Ptr<MIDIEndpoint, MIDIEndpointPtr> {
    }
}

