/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.corenfc;

import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorCode;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.rt.annotation.StronglyLinked;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.ValuedEnum;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Marshaler;

@Marshaler(value=ValuedEnum.AsMachineSizedSIntMarshaler.class)
@Library(value="CoreNFC")
public enum NFCReaderError implements NSErrorCode
{
    ReaderErrorUnsupportedFeature(1L),
    ReaderErrorSecurityViolation(2L),
    ReaderErrorInvalidParameter(3L),
    ReaderErrorInvalidParameterLength(4L),
    ReaderErrorParameterOutOfBound(5L),
    ReaderTransceiveErrorTagConnectionLost(100L),
    ReaderTransceiveErrorRetryExceeded(101L),
    ReaderTransceiveErrorTagResponseError(102L),
    ReaderTransceiveErrorSessionInvalidated(103L),
    ReaderTransceiveErrorTagNotConnected(104L),
    ReaderSessionInvalidationErrorUserCanceled(200L),
    ReaderSessionInvalidationErrorSessionTimeout(201L),
    ReaderSessionInvalidationErrorSessionTerminatedUnexpectedly(202L),
    ReaderSessionInvalidationErrorSystemIsBusy(203L),
    ReaderSessionInvalidationErrorFirstNDEFTagRead(204L),
    TagCommandConfigurationErrorInvalidParameters(300L),
    NdefReaderSessionErrorTagNotWritable(400L),
    NdefReaderSessionErrorTagUpdateFailure(401L),
    NdefReaderSessionErrorTagSizeTooSmall(402L),
    NdefReaderSessionErrorZeroLengthMessage(403L);

    private final long n;

    @GlobalValue(symbol="NFCErrorDomain", optional=true)
    public static native String getClassDomain();

    @GlobalValue(symbol="NFCISO15693TagResponseErrorKey", optional=true)
    public static native NSString ISO15693TagResponseErrorKey();

    @GlobalValue(symbol="NFCTagResponseUnexpectedLengthErrorKey", optional=true)
    public static native NSString TagResponseUnexpectedLengthErrorKey();

    private NFCReaderError(long n2) {
        this.n = n2;
    }

    public long value() {
        return this.n;
    }

    public static NFCReaderError valueOf(long n) {
        for (NFCReaderError v : NFCReaderError.values()) {
            if (v.n != n) continue;
            return v;
        }
        throw new IllegalArgumentException("No constant with value " + n + " found in " + NFCReaderError.class.getName());
    }

    static {
        Bro.bind(NFCReaderError.class);
        Bro.bind(NSErrorWrap.class);
    }

    @StronglyLinked
    public static class NSErrorWrap
    extends NSError {
        protected NSErrorWrap(NSObject.SkipInit skipInit) {
            super(skipInit);
        }

        @Override
        public NSErrorCode getErrorCode() {
            try {
                return NFCReaderError.valueOf(this.getCode());
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        public static String getClassDomain() {
            return NFCReaderError.getClassDomain();
        }
    }
}

