/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coreservices;

import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.robovm.apple.corefoundation.CFAllocator;
import org.robovm.apple.corefoundation.CFArray;
import org.robovm.apple.corefoundation.CFRunLoop;
import org.robovm.apple.corefoundation.CFStreamError;
import org.robovm.apple.corefoundation.CFStreamErrorException;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.coreservices.CFHostClientContext;
import org.robovm.apple.coreservices.CFHostInfoType;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSData;
import org.robovm.apple.foundation.NSInputStream;
import org.robovm.apple.foundation.NSOutputStream;
import org.robovm.objc.LongMap;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Callback;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.BooleanPtr;
import org.robovm.rt.bro.ptr.FunctionPtr;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="CFNetwork")
public class CFHost
extends CFType {
    private static final AtomicLong refconId = new AtomicLong();
    private long localRefconId;
    private static final LongMap<ClientCallback> callbacks = new LongMap();
    private static final Method cbInvoke;

    protected CFHost() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static void cbInvoke(CFHost host, CFHostInfoType infoType, CFStreamError.CFStreamErrorPtr error, @Pointer long refcon) {
        ClientCallback callback = null;
        LongMap<ClientCallback> longMap = callbacks;
        synchronized (longMap) {
            callback = (ClientCallback)callbacks.get(refcon);
        }
        CFStreamError err = null;
        if (error != null) {
            err = (CFStreamError)error.get();
        }
        callback.invoke(host, infoType, err);
    }

    public static CFHost create(String hostname) {
        long refconId = CFHost.refconId.getAndIncrement();
        CFHost host = CFHost.create(null, hostname);
        if (host != null) {
            host.localRefconId = refconId;
        }
        return host;
    }

    public static CFHost create(NSData addr) {
        long refconId = CFHost.refconId.getAndIncrement();
        CFHost host = CFHost.create(null, addr);
        if (host != null) {
            host.localRefconId = refconId;
        }
        return host;
    }

    public static CFHost createCopy(CFHost host) {
        CFHost h = CFHost.createCopy(null, host);
        if (host != null) {
            h.localRefconId = host.localRefconId;
        }
        return h;
    }

    public NSArray<NSData> getAddressing() {
        return this.getAddressing(null);
    }

    public List<String> getNames() {
        return this.getNames(null);
    }

    public NSData getReachability() {
        return this.getReachability(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCallback(ClientCallback callback) {
        CFHostClientContext context = new CFHostClientContext();
        context.setInfo(this.localRefconId);
        LongMap<ClientCallback> longMap = callbacks;
        synchronized (longMap) {
            callbacks.put(this.localRefconId, (Object)callback);
        }
        this.setCallback(new FunctionPtr(cbInvoke), context);
    }

    public NSInputStream createSocketReadStream(int port) {
        NSInputStream.NSInputStreamPtr ptr = new NSInputStream.NSInputStreamPtr();
        CFHost.createSocketStreamPair(null, this, port, ptr, null);
        return (NSInputStream)ptr.get();
    }

    public NSOutputStream createSocketWriteStream(int port) {
        NSOutputStream.NSOutputStreamPtr ptr = new NSOutputStream.NSOutputStreamPtr();
        CFHost.createSocketStreamPair(null, this, port, null, ptr);
        return (NSOutputStream)ptr.get();
    }

    @Bridge(symbol="CFHostGetTypeID", optional=true)
    @MachineSizedUInt
    public static native long getClassTypeID();

    @Bridge(symbol="CFHostCreateWithName", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    protected static native CFHost create(CFAllocator var0, String var1);

    @Bridge(symbol="CFHostCreateWithAddress", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    protected static native CFHost create(CFAllocator var0, NSData var1);

    @Bridge(symbol="CFHostCreateCopy", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    protected static native CFHost createCopy(CFAllocator var0, CFHost var1);

    public boolean startInfoResolution(CFHostInfoType info) throws CFStreamErrorException {
        CFStreamError.CFStreamErrorPtr ptr = new CFStreamError.CFStreamErrorPtr();
        boolean result = this.startInfoResolution(info, ptr);
        if (ptr.get() != null) {
            throw new CFStreamErrorException((CFStreamError)ptr.get());
        }
        return result;
    }

    @Bridge(symbol="CFHostStartInfoResolution", optional=true)
    private native boolean startInfoResolution(CFHostInfoType var1, CFStreamError.CFStreamErrorPtr var2);

    @Bridge(symbol="CFHostGetAddressing", optional=true)
    public native NSArray<NSData> getAddressing(BooleanPtr var1);

    @Bridge(symbol="CFHostGetNames", optional=true)
    @Marshaler(value=CFArray.AsStringListMarshaler.class)
    public native List<String> getNames(BooleanPtr var1);

    @Bridge(symbol="CFHostGetReachability", optional=true)
    public native NSData getReachability(BooleanPtr var1);

    @Bridge(symbol="CFHostCancelInfoResolution", optional=true)
    public native void cancelInfoResolution(CFHostInfoType var1);

    @Bridge(symbol="CFHostSetClient", optional=true)
    private native boolean setCallback(FunctionPtr var1, CFHostClientContext var2);

    @Bridge(symbol="CFHostScheduleWithRunLoop", optional=true)
    public native void scheduleInRunLoop(CFRunLoop var1, String var2);

    @Bridge(symbol="CFHostUnscheduleFromRunLoop", optional=true)
    public native void unscheduleFromRunLoop(CFRunLoop var1, String var2);

    @Bridge(symbol="CFStreamCreatePairWithSocketToCFHost", optional=true)
    private static native void createSocketStreamPair(CFAllocator var0, CFHost var1, int var2, NSInputStream.NSInputStreamPtr var3, NSOutputStream.NSOutputStreamPtr var4);

    static {
        try {
            cbInvoke = CFHost.class.getDeclaredMethod("cbInvoke", CFHost.class, CFHostInfoType.class, CFStreamError.CFStreamErrorPtr.class, Long.TYPE);
        }
        catch (Throwable e) {
            throw new Error(e);
        }
        Bro.bind(CFHost.class);
    }

    public static interface ClientCallback {
        public void invoke(CFHost var1, CFHostInfoType var2, CFStreamError var3);
    }

    public static class CFHostPtr
    extends Ptr<CFHost, CFHostPtr> {
    }
}

