/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coretext;

import java.util.List;
import java.util.Map;
import org.robovm.apple.corefoundation.CFArray;
import org.robovm.apple.corefoundation.CFDictionary;
import org.robovm.apple.corefoundation.CFRange;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.corefoundation.CFStringEncodings;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.coregraphics.CGAffineTransform;
import org.robovm.apple.coregraphics.CGContext;
import org.robovm.apple.coregraphics.CGFont;
import org.robovm.apple.coregraphics.CGPath;
import org.robovm.apple.coregraphics.CGPoint;
import org.robovm.apple.coregraphics.CGRect;
import org.robovm.apple.coregraphics.CGSize;
import org.robovm.apple.coretext.CTFontAttribute;
import org.robovm.apple.coretext.CTFontDescriptor;
import org.robovm.apple.coretext.CTFontNameKey;
import org.robovm.apple.coretext.CTFontOptions;
import org.robovm.apple.coretext.CTFontOrientation;
import org.robovm.apple.coretext.CTFontSymbolicTraits;
import org.robovm.apple.coretext.CTFontTableOptions;
import org.robovm.apple.coretext.CTFontTableTag;
import org.robovm.apple.coretext.CTFontTraits;
import org.robovm.apple.coretext.CTFontUIFontType;
import org.robovm.apple.coretext.CTFontVariationAxes;
import org.robovm.apple.foundation.NSCharacterSet;
import org.robovm.apple.foundation.NSData;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedFloat;
import org.robovm.rt.bro.annotation.MachineSizedSInt;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.ptr.MachineSizedFloatPtr;
import org.robovm.rt.bro.ptr.Ptr;
import org.robovm.rt.bro.ptr.ShortPtr;

@Library(value="CoreText")
public class CTFont
extends CFType {
    protected CTFont() {
    }

    public String getLocalizedName(CTFontNameKey nameKey) {
        return this.getLocalizedName(nameKey, null);
    }

    public short[] getGlyphs(short[] characters) {
        ShortPtr cptr = new ShortPtr();
        cptr.set(characters);
        ShortPtr ptr = new ShortPtr();
        this.getGlyphs(cptr, ptr, characters.length);
        return ptr.toShortArray(characters.length);
    }

    public CGRect[] getBoundingRects(CTFontOrientation orientation, short[] glyphs) {
        ShortPtr gptr = new ShortPtr();
        gptr.set(glyphs);
        CGRect.CGRectPtr ptr = new CGRect.CGRectPtr();
        this.getBoundingRects(orientation, gptr, ptr, glyphs.length);
        return (CGRect[])((CGRect)ptr.get()).toArray(glyphs.length);
    }

    public CGRect[] getOpticalBounds(short[] glyphs) {
        ShortPtr gptr = new ShortPtr();
        gptr.set(glyphs);
        CGRect.CGRectPtr ptr = new CGRect.CGRectPtr();
        this.getOpticalBounds(gptr, ptr, glyphs.length, 0L);
        return (CGRect[])((CGRect)ptr.get()).toArray(glyphs.length);
    }

    public CGSize[] getAdvances(CTFontOrientation orientation, short[] glyphs) {
        ShortPtr gptr = new ShortPtr();
        gptr.set(glyphs);
        CGSize.CGSizePtr ptr = new CGSize.CGSizePtr();
        this.getAdvances(orientation, gptr, ptr, glyphs.length);
        return (CGSize[])((CGSize)ptr.get()).toArray(glyphs.length);
    }

    public CGSize[] getVerticalTranslations(short[] glyphs) {
        ShortPtr gptr = new ShortPtr();
        gptr.set(glyphs);
        CGSize.CGSizePtr ptr = new CGSize.CGSizePtr();
        this.getVerticalTranslations(gptr, ptr, glyphs.length);
        return (CGSize[])((CGSize)ptr.get()).toArray(glyphs.length);
    }

    public CGFont getGraphicsFont() {
        return this.getGraphicsFont(null);
    }

    public void drawGlyphs(short[] glyphs, CGPoint[] positions, CGContext context) {
        ShortPtr gptr = new ShortPtr();
        gptr.set(glyphs);
        CGPoint pos = new CGPoint();
        pos.update(positions);
        this.drawGlyphs(gptr, pos, positions.length, context);
    }

    public double[] getLigatureCaretPositions(short glyph, int maxPositions) {
        MachineSizedFloatPtr ptr = new MachineSizedFloatPtr();
        this.getLigatureCaretPositions(glyph, ptr, maxPositions);
        return ptr.toDoubleArray(maxPositions);
    }

    @Bridge(symbol="CTFontGetTypeID", optional=true)
    @MachineSizedUInt
    public static native long getClassTypeID();

    @Bridge(symbol="CTFontCreateWithName", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CTFont create(String var0, @MachineSizedFloat double var1, CGAffineTransform var3);

    @Bridge(symbol="CTFontCreateWithFontDescriptor", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CTFont create(CTFontDescriptor var0, @MachineSizedFloat double var1, CGAffineTransform var3);

    @Bridge(symbol="CTFontCreateWithNameAndOptions", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CTFont create(String var0, @MachineSizedFloat double var1, CGAffineTransform var3, CTFontOptions var4);

    @Bridge(symbol="CTFontCreateWithFontDescriptorAndOptions", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CTFont create(CTFontDescriptor var0, @MachineSizedFloat double var1, CGAffineTransform var3, CTFontOptions var4);

    @Bridge(symbol="CTFontCreateUIFontForLanguage", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CTFont createUIFont(CTFontUIFontType var0, @MachineSizedFloat double var1, String var3);

    @Bridge(symbol="CTFontCreateCopyWithAttributes", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CTFont createCopy(CTFont var0, @MachineSizedFloat double var1, CGAffineTransform var3, CTFontDescriptor var4);

    @Bridge(symbol="CTFontCreateCopyWithSymbolicTraits", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CTFont createCopy(CTFont var0, @MachineSizedFloat double var1, CGAffineTransform var3, CTFontSymbolicTraits var4, CTFontSymbolicTraits var5);

    @Bridge(symbol="CTFontCreateCopyWithFamily", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CTFont createCopy(CTFont var0, @MachineSizedFloat double var1, CGAffineTransform var3, String var4);

    @Bridge(symbol="CTFontCreateForString", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public native CTFont create(String var1, @ByVal CFRange var2);

    @Bridge(symbol="CTFontCreateForStringWithLanguage", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public native CTFont create(String var1, @ByVal CFRange var2, String var3);

    @Bridge(symbol="CTFontCopyFontDescriptor", optional=true)
    public native CTFontDescriptor getFontDescriptor();

    @Bridge(symbol="CTFontCopyAttribute", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public native CFType getAttribute(CTFontAttribute var1);

    @Bridge(symbol="CTFontGetSize", optional=true)
    @MachineSizedFloat
    public native double getSize();

    @Bridge(symbol="CTFontGetMatrix", optional=true)
    @ByVal
    public native CGAffineTransform getMatrix();

    @Bridge(symbol="CTFontGetSymbolicTraits", optional=true)
    public native CTFontSymbolicTraits getSymbolicTraits();

    @Bridge(symbol="CTFontCopyTraits", optional=true)
    public native CTFontTraits getTraits();

    @Bridge(symbol="CTFontCopyPostScriptName", optional=true)
    @Marshaler(value=CFString.AsStringNoRetainMarshaler.class)
    public native String getPostScriptName();

    @Bridge(symbol="CTFontCopyFamilyName", optional=true)
    @Marshaler(value=CFString.AsStringNoRetainMarshaler.class)
    public native String getFamilyName();

    @Bridge(symbol="CTFontCopyFullName", optional=true)
    @Marshaler(value=CFString.AsStringNoRetainMarshaler.class)
    public native String getFullName();

    @Bridge(symbol="CTFontCopyDisplayName", optional=true)
    @Marshaler(value=CFString.AsStringNoRetainMarshaler.class)
    public native String getDisplayName();

    @Bridge(symbol="CTFontCopyName", optional=true)
    @Marshaler(value=CFString.AsStringNoRetainMarshaler.class)
    public native String getName(CTFontNameKey var1);

    @Bridge(symbol="CTFontCopyLocalizedName", optional=true)
    @Marshaler(value=CFString.AsStringNoRetainMarshaler.class)
    protected native String getLocalizedName(CTFontNameKey var1, CFString.CFStringPtr var2);

    @Bridge(symbol="CTFontCopyCharacterSet", optional=true)
    public native NSCharacterSet getCharacterSet();

    @Bridge(symbol="CTFontGetStringEncoding", optional=true)
    @Marshaler(value=CFStringEncodings.class)
    public native int getStringEncoding();

    @Bridge(symbol="CTFontCopySupportedLanguages", optional=true)
    @Marshaler(value=CFArray.AsStringListMarshaler.class)
    public native List<String> getSupportedLanguages();

    @Bridge(symbol="CTFontGetGlyphsForCharacters", optional=true)
    protected native boolean getGlyphs(ShortPtr var1, ShortPtr var2, @MachineSizedSInt long var3);

    @Bridge(symbol="CTFontGetAscent", optional=true)
    @MachineSizedFloat
    public native double getAscent();

    @Bridge(symbol="CTFontGetDescent", optional=true)
    @MachineSizedFloat
    public native double getDescent();

    @Bridge(symbol="CTFontGetLeading", optional=true)
    @MachineSizedFloat
    public native double getLeading();

    @Bridge(symbol="CTFontGetUnitsPerEm", optional=true)
    public native int getUnitsPerEm();

    @Bridge(symbol="CTFontGetGlyphCount", optional=true)
    @MachineSizedSInt
    public native long getGlyphCount();

    @Bridge(symbol="CTFontGetBoundingBox", optional=true)
    @ByVal
    public native CGRect getBoundingBox();

    @Bridge(symbol="CTFontGetUnderlinePosition", optional=true)
    @MachineSizedFloat
    public native double getUnderlinePosition();

    @Bridge(symbol="CTFontGetUnderlineThickness", optional=true)
    @MachineSizedFloat
    public native double getUnderlineThickness();

    @Bridge(symbol="CTFontGetSlantAngle", optional=true)
    @MachineSizedFloat
    public native double getSlantAngle();

    @Bridge(symbol="CTFontGetCapHeight", optional=true)
    @MachineSizedFloat
    public native double getCapHeight();

    @Bridge(symbol="CTFontGetXHeight", optional=true)
    @MachineSizedFloat
    public native double getXHeight();

    @Bridge(symbol="CTFontGetGlyphWithName", optional=true)
    public native short getGlyph(String var1);

    @Bridge(symbol="CTFontGetBoundingRectsForGlyphs", optional=true)
    @ByVal
    protected native CGRect getBoundingRects(CTFontOrientation var1, ShortPtr var2, CGRect.CGRectPtr var3, @MachineSizedSInt long var4);

    @Bridge(symbol="CTFontGetOpticalBoundsForGlyphs", optional=true)
    @ByVal
    protected native CGRect getOpticalBounds(ShortPtr var1, CGRect.CGRectPtr var2, @MachineSizedSInt long var3, @MachineSizedUInt long var5);

    @Bridge(symbol="CTFontGetAdvancesForGlyphs", optional=true)
    protected native double getAdvances(CTFontOrientation var1, ShortPtr var2, CGSize.CGSizePtr var3, @MachineSizedSInt long var4);

    @Bridge(symbol="CTFontGetVerticalTranslationsForGlyphs", optional=true)
    protected native void getVerticalTranslations(ShortPtr var1, CGSize.CGSizePtr var2, @MachineSizedSInt long var3);

    @Bridge(symbol="CTFontCreatePathForGlyph", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public native CGPath createPath(short var1, CGAffineTransform var2);

    @Bridge(symbol="CTFontCopyVariationAxes", optional=true)
    @Marshaler(value=CTFontVariationAxes.AsListMarshaler.class)
    public native List<CTFontVariationAxes> getVariationAxes();

    @Bridge(symbol="CTFontCopyVariation", optional=true)
    @Marshaler(value=CFDictionary.AsStringMapMarshaler.class)
    public native Map<String, NSNumber> getVariation();

    @Bridge(symbol="CTFontCopyFeatures", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    protected native CFArray getFeatures();

    @Bridge(symbol="CTFontCopyFeatureSettings", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    protected native CFArray getFeatureSettings();

    @Bridge(symbol="CTFontCopyGraphicsFont", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    protected native CGFont getGraphicsFont(CTFontDescriptor.CTFontDescriptorPtr var1);

    @Bridge(symbol="CTFontCreateWithGraphicsFont", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CTFont create(CGFont var0, @MachineSizedFloat double var1, CGAffineTransform var3, CTFontDescriptor var4);

    @Bridge(symbol="CTFontCopyAvailableTables", optional=true)
    @Marshaler(value=CTFontTableTag.AsListMarshaler.class)
    public native List<CTFontTableTag> getAvailableTables(CTFontTableOptions var1);

    @Bridge(symbol="CTFontCopyTable", optional=true)
    @Marshaler(value=NSObject.NoRetainMarshaler.class)
    public native NSData getTable(CTFontTableTag var1, CTFontTableOptions var2);

    @Bridge(symbol="CTFontDrawGlyphs", optional=true)
    protected native void drawGlyphs(ShortPtr var1, CGPoint var2, @MachineSizedUInt long var3, CGContext var5);

    @Bridge(symbol="CTFontGetLigatureCaretPositions", optional=true)
    @MachineSizedSInt
    protected native long getLigatureCaretPositions(short var1, MachineSizedFloatPtr var2, @MachineSizedSInt long var3);

    @Bridge(symbol="CTFontCopyDefaultCascadeListForLanguages", optional=true)
    @Marshaler(value=CTFontDescriptor.AsListMarshaler.class)
    public native List<CTFontDescriptor> getDefaultCascadeList(@Marshaler(value=CFArray.AsStringListMarshaler.class) List<String> var1);

    static {
        Bro.bind(CTFont.class);
    }

    public static class CTFontPtr
    extends Ptr<CTFont, CTFontPtr> {
    }
}

