/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coretext;

import java.util.List;
import org.robovm.apple.corefoundation.CFArray;
import org.robovm.apple.corefoundation.CFDictionary;
import org.robovm.apple.corefoundation.CFRange;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.coregraphics.CGAffineTransform;
import org.robovm.apple.coregraphics.CGContext;
import org.robovm.apple.coregraphics.CGPoint;
import org.robovm.apple.coregraphics.CGRect;
import org.robovm.apple.coregraphics.CGSize;
import org.robovm.apple.coremedia.CMTextMarkupAttributes;
import org.robovm.apple.coretext.CTAttributedStringAttributes;
import org.robovm.apple.coretext.CTRunStatus;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.uikit.NSAttributedStringAttributes;
import org.robovm.rt.annotation.WeaklyLinked;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.Struct;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedFloat;
import org.robovm.rt.bro.annotation.MachineSizedSInt;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.MarshalsPointer;
import org.robovm.rt.bro.ptr.LongPtr;
import org.robovm.rt.bro.ptr.MachineSizedFloatPtr;
import org.robovm.rt.bro.ptr.Ptr;
import org.robovm.rt.bro.ptr.ShortPtr;

@Library(value="CoreText")
public class CTRun
extends CFType {
    protected CTRun() {
    }

    @WeaklyLinked
    public NSAttributedStringAttributes getAttributes() {
        NSDictionary dict = this.getAttributesDictionary();
        if (dict == null) {
            return null;
        }
        return new NSAttributedStringAttributes(dict);
    }

    @WeaklyLinked
    public CMTextMarkupAttributes getTextMarkupAttributes() {
        NSDictionary dict = this.getAttributesDictionary();
        if (dict == null) {
            return null;
        }
        return new CMTextMarkupAttributes((CFDictionary)this.getAttributesDictionary().as(CFDictionary.class));
    }

    public CTAttributedStringAttributes getCoreTextAttributes() {
        NSDictionary dict = this.getAttributesDictionary();
        if (dict == null) {
            return null;
        }
        return new CTAttributedStringAttributes((CFDictionary)this.getAttributesDictionary().as(CFDictionary.class));
    }

    public short[] getGlyphs(@ByVal CFRange range) {
        ShortPtr ptr = new ShortPtr();
        this.getGlyphs(range, ptr);
        return ptr.toShortArray((int)this.getGlyphCount());
    }

    public CGPoint[] getPositions(@ByVal CFRange range) {
        CGPoint p = (CGPoint)Struct.allocate(CGPoint.class, (int)((int)range.getLength()));
        this.getPositions(range, p);
        return (CGPoint[])p.toArray((int)this.getGlyphCount());
    }

    public CGSize[] getAdvances(@ByVal CFRange range) {
        CGSize s = (CGSize)Struct.allocate(CGSize.class, (int)((int)range.getLength()));
        this.getAdvances(range, s);
        return (CGSize[])s.toArray((int)this.getGlyphCount());
    }

    public long[] getStringIndices(@ByVal CFRange range) {
        LongPtr ptr = new LongPtr();
        this.getStringIndices(range, ptr);
        return ptr.toLongArray((int)this.getGlyphCount());
    }

    @MachineSizedFloat
    public double getWidth(@ByVal CFRange range) {
        return this.getTypographicBounds(range, null, null, null);
    }

    @MachineSizedFloat
    public double getAscent(@ByVal CFRange range) {
        MachineSizedFloatPtr ptr = new MachineSizedFloatPtr();
        this.getTypographicBounds(range, ptr, null, null);
        return ptr.get();
    }

    @MachineSizedFloat
    public double getDescent(@ByVal CFRange range) {
        MachineSizedFloatPtr ptr = new MachineSizedFloatPtr();
        this.getTypographicBounds(range, null, ptr, null);
        return ptr.get();
    }

    @MachineSizedFloat
    public double getLeading(@ByVal CFRange range) {
        MachineSizedFloatPtr ptr = new MachineSizedFloatPtr();
        this.getTypographicBounds(range, null, null, ptr);
        return ptr.get();
    }

    @Bridge(symbol="CTRunGetTypeID", optional=true)
    @MachineSizedUInt
    public static native long getClassTypeID();

    @Bridge(symbol="CTRunGetGlyphCount", optional=true)
    @MachineSizedSInt
    public native long getGlyphCount();

    @Bridge(symbol="CTRunGetAttributes", optional=true)
    public native NSDictionary getAttributesDictionary();

    @Bridge(symbol="CTRunGetStatus", optional=true)
    public native CTRunStatus getStatus();

    @Bridge(symbol="CTRunGetGlyphs", optional=true)
    protected native void getGlyphs(@ByVal CFRange var1, ShortPtr var2);

    @Bridge(symbol="CTRunGetPositions", optional=true)
    protected native void getPositions(@ByVal CFRange var1, CGPoint var2);

    @Bridge(symbol="CTRunGetAdvances", optional=true)
    protected native void getAdvances(@ByVal CFRange var1, CGSize var2);

    @Bridge(symbol="CTRunGetStringIndices", optional=true)
    protected native void getStringIndices(@ByVal CFRange var1, LongPtr var2);

    @Bridge(symbol="CTRunGetStringRange", optional=true)
    @ByVal
    public native CFRange getStringRange();

    @Bridge(symbol="CTRunGetTypographicBounds", optional=true)
    protected native double getTypographicBounds(@ByVal CFRange var1, MachineSizedFloatPtr var2, MachineSizedFloatPtr var3, MachineSizedFloatPtr var4);

    @Bridge(symbol="CTRunGetImageBounds", optional=true)
    @ByVal
    public native CGRect getImageBounds(CGContext var1, @ByVal CFRange var2);

    @Bridge(symbol="CTRunGetTextMatrix", optional=true)
    @ByVal
    public native CGAffineTransform getTextMatrix();

    @Bridge(symbol="CTRunGetBaseAdvancesAndOrigins", optional=true)
    public native void getBaseAdvancesAndOrigins(@ByVal CFRange var1, CGSize var2, CGPoint var3);

    @Bridge(symbol="CTRunDraw", optional=true)
    public native void draw(CGContext var1, @ByVal CFRange var2);

    static {
        Bro.bind(CTRun.class);
    }

    public static class CTRunPtr
    extends Ptr<CTRun, CTRunPtr> {
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<?> toObject(Class<? extends CFType> cls, long handle, long flags) {
            CFArray o = (CFArray)CFType.Marshaler.toObject(cls, handle, flags);
            if (o == null) {
                return null;
            }
            return o.toList(CTRun.class);
        }

        @MarshalsPointer
        public static long toNative(List<? extends CFType> l, long flags) {
            if (l == null) {
                return 0L;
            }
            CFArray o = null;
            o = l instanceof CFArray ? (CFArray)((Object)l) : CFArray.create(l);
            return CFType.Marshaler.toNative(o, flags);
        }
    }
}

