/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.corevideo;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.corefoundation.CFAllocator;
import org.robovm.apple.corefoundation.CFArray;
import org.robovm.apple.corefoundation.CFBoolean;
import org.robovm.apple.corefoundation.CFDictionary;
import org.robovm.apple.corefoundation.CFMutableArray;
import org.robovm.apple.corefoundation.CFNumber;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.corevideo.CVBufferAttributes;
import org.robovm.apple.corevideo.CVPixelBufferAttribute;
import org.robovm.apple.corevideo.CVPixelFormatType;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="CoreVideo")
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
public class CVPixelBufferAttributes
extends CVBufferAttributes {
    CVPixelBufferAttributes(CFDictionary data) {
        super(data);
    }

    public CVPixelBufferAttributes() {
    }

    public boolean has(CVPixelBufferAttribute key) {
        return this.data.containsKey((NativeObject)key.value());
    }

    public <T extends NativeObject> T get(CVPixelBufferAttribute key, Class<T> type) {
        if (this.has(key)) {
            return this.data.get((NativeObject)key.value(), type);
        }
        return null;
    }

    public CVPixelBufferAttributes set(CVPixelBufferAttribute key, NativeObject value) {
        this.data.put((NativeObject)key.value(), value);
        return this;
    }

    public CFAllocator getMemoryAllocator() {
        if (this.has(CVPixelBufferAttribute.MemoryAllocator)) {
            CFAllocator val = this.get(CVPixelBufferAttribute.MemoryAllocator, CFAllocator.class);
            return val;
        }
        return null;
    }

    public CVPixelBufferAttributes setMemoryAllocator(CFAllocator memoryAllocator) {
        this.set(CVPixelBufferAttribute.MemoryAllocator, (NativeObject)memoryAllocator);
        return this;
    }

    public long getWidth() {
        if (this.has(CVPixelBufferAttribute.Width)) {
            CFNumber val = this.get(CVPixelBufferAttribute.Width, CFNumber.class);
            return val.longValue();
        }
        return 0L;
    }

    public CVPixelBufferAttributes setWidth(long width) {
        this.set(CVPixelBufferAttribute.Width, (NativeObject)CFNumber.valueOf(width));
        return this;
    }

    public long getHeight() {
        if (this.has(CVPixelBufferAttribute.Height)) {
            CFNumber val = this.get(CVPixelBufferAttribute.Height, CFNumber.class);
            return val.longValue();
        }
        return 0L;
    }

    public CVPixelBufferAttributes setHeight(long height) {
        this.set(CVPixelBufferAttribute.Height, (NativeObject)CFNumber.valueOf(height));
        return this;
    }

    public long getExtendedPixelsLeft() {
        if (this.has(CVPixelBufferAttribute.ExtendedPixelsLeft)) {
            CFNumber val = this.get(CVPixelBufferAttribute.ExtendedPixelsLeft, CFNumber.class);
            return val.longValue();
        }
        return 0L;
    }

    public CVPixelBufferAttributes setExtendedPixelsLeft(long extendedPixelsLeft) {
        this.set(CVPixelBufferAttribute.ExtendedPixelsLeft, (NativeObject)CFNumber.valueOf(extendedPixelsLeft));
        return this;
    }

    public long getExtendedPixelsTop() {
        if (this.has(CVPixelBufferAttribute.ExtendedPixelsTop)) {
            CFNumber val = this.get(CVPixelBufferAttribute.ExtendedPixelsTop, CFNumber.class);
            return val.longValue();
        }
        return 0L;
    }

    public CVPixelBufferAttributes setExtendedPixelsTop(long extendedPixelsTop) {
        this.set(CVPixelBufferAttribute.ExtendedPixelsTop, (NativeObject)CFNumber.valueOf(extendedPixelsTop));
        return this;
    }

    public long getExtendedPixelsRight() {
        if (this.has(CVPixelBufferAttribute.ExtendedPixelsRight)) {
            CFNumber val = this.get(CVPixelBufferAttribute.ExtendedPixelsRight, CFNumber.class);
            return val.longValue();
        }
        return 0L;
    }

    public CVPixelBufferAttributes setExtendedPixelsRight(long extendedPixelsRight) {
        this.set(CVPixelBufferAttribute.ExtendedPixelsRight, (NativeObject)CFNumber.valueOf(extendedPixelsRight));
        return this;
    }

    public long getExtendedPixelsBottom() {
        if (this.has(CVPixelBufferAttribute.ExtendedPixelsBottom)) {
            CFNumber val = this.get(CVPixelBufferAttribute.ExtendedPixelsBottom, CFNumber.class);
            return val.longValue();
        }
        return 0L;
    }

    public CVPixelBufferAttributes setExtendedPixelsBottom(long extendedPixelsBottom) {
        this.set(CVPixelBufferAttribute.ExtendedPixelsBottom, (NativeObject)CFNumber.valueOf(extendedPixelsBottom));
        return this;
    }

    public long getBytesPerRowAlignment() {
        if (this.has(CVPixelBufferAttribute.BytesPerRowAlignment)) {
            CFNumber val = this.get(CVPixelBufferAttribute.BytesPerRowAlignment, CFNumber.class);
            return val.longValue();
        }
        return 0L;
    }

    public CVPixelBufferAttributes setBytesPerRowAlignment(long bytesPerRowAlignment) {
        this.set(CVPixelBufferAttribute.BytesPerRowAlignment, (NativeObject)CFNumber.valueOf(bytesPerRowAlignment));
        return this;
    }

    public boolean isCompatibleWithCGBitmapContext() {
        if (this.has(CVPixelBufferAttribute.CGBitmapContextCompatibility)) {
            CFBoolean val = this.get(CVPixelBufferAttribute.CGBitmapContextCompatibility, CFBoolean.class);
            return val.booleanValue();
        }
        return false;
    }

    public CVPixelBufferAttributes setCompatibleWithCGBitmapContext(boolean compatibleWithCGBitmapContext) {
        this.set(CVPixelBufferAttribute.CGBitmapContextCompatibility, (NativeObject)CFBoolean.valueOf(compatibleWithCGBitmapContext));
        return this;
    }

    public boolean isCompatibleWithCGImage() {
        if (this.has(CVPixelBufferAttribute.CGImageCompatibility)) {
            CFBoolean val = this.get(CVPixelBufferAttribute.CGImageCompatibility, CFBoolean.class);
            return val.booleanValue();
        }
        return false;
    }

    public CVPixelBufferAttributes setCompatibleWithCGImage(boolean compatibleWithCGImage) {
        this.set(CVPixelBufferAttribute.CGImageCompatibility, (NativeObject)CFBoolean.valueOf(compatibleWithCGImage));
        return this;
    }

    public boolean isCompatibleWithOpenGL() {
        if (this.has(CVPixelBufferAttribute.OpenGLCompatibility)) {
            CFBoolean val = this.get(CVPixelBufferAttribute.OpenGLCompatibility, CFBoolean.class);
            return val.booleanValue();
        }
        return false;
    }

    public CVPixelBufferAttributes setCompatibleWithOpenGL(boolean compatibleWithOpenGL) {
        this.set(CVPixelBufferAttribute.OpenGLCompatibility, (NativeObject)CFBoolean.valueOf(compatibleWithOpenGL));
        return this;
    }

    public long getPlaneAlignment() {
        if (this.has(CVPixelBufferAttribute.PlaneAlignment)) {
            CFNumber val = this.get(CVPixelBufferAttribute.PlaneAlignment, CFNumber.class);
            return val.longValue();
        }
        return 0L;
    }

    public CVPixelBufferAttributes setPlaneAlignment(long planeAlignment) {
        this.set(CVPixelBufferAttribute.PlaneAlignment, (NativeObject)CFNumber.valueOf(planeAlignment));
        return this;
    }

    public NSDictionary getIOSurfaceProperties() {
        if (this.has(CVPixelBufferAttribute.IOSurfaceProperties)) {
            NSDictionary val = this.get(CVPixelBufferAttribute.IOSurfaceProperties, NSDictionary.class);
            return val;
        }
        return null;
    }

    public CVPixelBufferAttributes setIOSurfaceProperties(NSDictionary iOSurfaceProperties) {
        this.set(CVPixelBufferAttribute.IOSurfaceProperties, (NativeObject)iOSurfaceProperties);
        return this;
    }

    public boolean isCompatibleWithOpenGLES() {
        if (this.has(CVPixelBufferAttribute.OpenGLESCompatibility)) {
            CFBoolean val = this.get(CVPixelBufferAttribute.OpenGLESCompatibility, CFBoolean.class);
            return val.booleanValue();
        }
        return false;
    }

    public CVPixelBufferAttributes setCompatibleWithOpenGLES(boolean compatibleWithOpenGLES) {
        this.set(CVPixelBufferAttribute.OpenGLESCompatibility, (NativeObject)CFBoolean.valueOf(compatibleWithOpenGLES));
        return this;
    }

    public boolean isCompatibleWithMetal() {
        if (this.has(CVPixelBufferAttribute.MetalCompatibility)) {
            CFBoolean val = this.get(CVPixelBufferAttribute.MetalCompatibility, CFBoolean.class);
            return val.booleanValue();
        }
        return false;
    }

    public CVPixelBufferAttributes setCompatibleWithMetal(boolean compatibleWithMetal) {
        this.set(CVPixelBufferAttribute.MetalCompatibility, (NativeObject)CFBoolean.valueOf(compatibleWithMetal));
        return this;
    }

    public List<CVPixelFormatType> getPixelFormatTypes() {
        if (this.has(CVPixelBufferAttribute.PixelFormatType)) {
            CFType val = this.get(CVPixelBufferAttribute.PixelFormatType, CFType.class);
            ArrayList<CVPixelFormatType> list = new ArrayList<CVPixelFormatType>();
            if (val.getClass() == CFNumber.class || CFNumber.class.isAssignableFrom(val.getClass())) {
                CFNumber num = (CFNumber)val;
                list.add(CVPixelFormatType.valueOf(num.longValue()));
                return list;
            }
            if (val.getClass() == CFArray.class || CFArray.class.isAssignableFrom(val.getClass())) {
                CFArray arr = (CFArray)val;
                int i = 0;
                while ((long)i < arr.size()) {
                    list.add(CVPixelFormatType.valueOf(arr.get(i, CFNumber.class).longValue()));
                    ++i;
                }
                return list;
            }
        }
        return null;
    }

    public CVPixelBufferAttributes setPixelFormatType(CVPixelFormatType type) {
        this.set(CVPixelBufferAttribute.PixelFormatType, (NativeObject)CFNumber.valueOf(type.value()));
        return this;
    }

    public CVPixelBufferAttributes setPixelFormatTypes(List<CVPixelFormatType> types) {
        CFMutableArray array = CFMutableArray.create();
        for (CVPixelFormatType i : types) {
            ((CFArray)array).add(CFNumber.valueOf(i.value()));
        }
        this.set(CVPixelBufferAttribute.PixelFormatType, (NativeObject)array);
        return this;
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<CVPixelBufferAttributes> toObject(Class<? extends CFType> cls, long handle, long flags) {
            CFArray o = (CFArray)CFType.Marshaler.toObject(CFArray.class, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<CVPixelBufferAttributes> list = new ArrayList<CVPixelBufferAttributes>();
            int i = 0;
            while ((long)i < o.size()) {
                list.add(new CVPixelBufferAttributes(o.get(i, CFDictionary.class)));
                ++i;
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<CVPixelBufferAttributes> l, long flags) {
            if (l == null) {
                return 0L;
            }
            CFMutableArray array = CFMutableArray.create();
            for (CVPixelBufferAttributes i : l) {
                ((CFArray)array).add(i.getDictionary());
            }
            return CFType.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static CVPixelBufferAttributes toObject(Class<CVPixelBufferAttributes> cls, long handle, long flags) {
            CFDictionary o = (CFDictionary)CFType.Marshaler.toObject(CFDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new CVPixelBufferAttributes(o);
        }

        @MarshalsPointer
        public static long toNative(CVPixelBufferAttributes o, long flags) {
            if (o == null) {
                return 0L;
            }
            return CFType.Marshaler.toNative(o.data, flags);
        }
    }
}

