/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.foundation;

import org.robovm.apple.foundation.CocoaUtility;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.uikit.UIDevice;
import org.robovm.rt.annotation.WeaklyLinked;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Variadic;

@Library(value="Foundation")
public class Foundation
extends CocoaUtility {
    private static String systemVersionString;
    private static int majorSystemVersion;
    private static int minorSystemVersion;
    private static int patchSystemVersion;

    @Bridge(symbol="NSLog")
    public static native void log(String var0);

    @Bridge(symbol="NSLog")
    @Variadic(value=1)
    public static native void log(String var0, NSObject var1);

    @Bridge(symbol="NSLog")
    @Variadic(value=1)
    public static native void log(String var0, NSObject var1, NSObject var2);

    @Bridge(symbol="NSLog")
    @Variadic(value=1)
    public static native void log(String var0, NSObject var1, NSObject var2, NSObject var3);

    @Bridge(symbol="NSLog")
    @Variadic(value=1)
    public static native void log(String var0, NSObject var1, NSObject var2, NSObject var3, NSObject var4);

    @Bridge(symbol="NSLog")
    @Variadic(value=1)
    public static native void log(String var0, NSObject var1, NSObject var2, NSObject var3, NSObject var4, NSObject var5);

    public static String getSystemVersionString() {
        if (majorSystemVersion == 0) {
            Foundation.fetchSystemVersion();
        }
        return systemVersionString;
    }

    public static int getMajorSystemVersion() {
        if (majorSystemVersion == 0) {
            Foundation.fetchSystemVersion();
        }
        return majorSystemVersion;
    }

    public static int getMinorSystemVersion() {
        if (majorSystemVersion == 0) {
            Foundation.fetchSystemVersion();
        }
        return minorSystemVersion;
    }

    public static int getPatchSystemVersion() {
        if (majorSystemVersion == 0) {
            Foundation.fetchSystemVersion();
        }
        return patchSystemVersion;
    }

    @WeaklyLinked
    private static void fetchSystemVersion() {
        String version;
        systemVersionString = version = UIDevice.getCurrentDevice().getSystemVersion();
        if (version != null) {
            String[] parts = version.split("\\.");
            if (parts.length > 0) {
                majorSystemVersion = Integer.valueOf(parts[0]);
            }
            if (parts.length > 1) {
                minorSystemVersion = Integer.valueOf(parts[1]);
            }
            if (parts.length > 2) {
                patchSystemVersion = Integer.valueOf(parts[2]);
            }
        } else {
            majorSystemVersion = 6;
        }
    }

    static {
        Bro.bind(Foundation.class);
    }
}

