/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.foundation;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.robovm.apple.foundation.Foundation;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSCoder;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSSecureCoding;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.foundation.NSThread;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.objc.block.VoidBlock1;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Callback;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.FunctionPtr;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="Foundation")
@NativeClass
public class NSException
extends NSObject
implements NSSecureCoding {
    private static VoidBlock1<NSException> handler;

    protected NSException(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected NSException(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Method(selector="initWithName:reason:userInfo:")
    public NSException(String aName, String aReason, NSDictionary<?, ?> aUserInfo) {
        super(null);
        this.initObject(this.init(aName, aReason, aUserInfo));
    }

    @Method(selector="initWithCoder:")
    public NSException(NSCoder coder) {
        super(null);
        this.initObject(this.init(coder));
    }

    @Property(selector="name")
    public native String getName();

    @Property(selector="reason")
    public native String getReason();

    @Property(selector="userInfo")
    public native NSDictionary<?, ?> getUserInfo();

    @Property(selector="callStackReturnAddresses")
    public native NSArray<NSNumber> getCallStackReturnAddresses();

    @Property(selector="callStackSymbols")
    public native NSArray<NSString> getCallStackSymbols();

    @Property(selector="supportsSecureCoding")
    public static native boolean supportsSecureCoding();

    @Callback
    private static void handler(NSException e) {
        handler.invoke((Object)e);
    }

    public static void setUncaughtExceptionHandler(VoidBlock1<NSException> handler) {
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        NSException.handler = handler;
        try {
            NSException.setUncaughtExceptionHandler(new FunctionPtr(NSException.class.getDeclaredMethod("handler", NSException.class)));
        }
        catch (Throwable t) {
            throw new Error(t);
        }
    }

    public static void registerDefaultJavaUncaughtExceptionHandler() {
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable ex) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                ex.printStackTrace(pw);
                pw.flush();
                Foundation.log(sw.toString());
                NSException exception = new NSException(ex.getClass().getName(), sw.toString(), new NSDictionary());
                if (NSThread.getCurrentThread().isMainThread()) {
                    exception.raise();
                } else {
                    long handler = NSException.getUncaughtExceptionHandler();
                    NSException.callUncaughtExceptionHandler(handler, exception);
                }
            }
        });
    }

    @Bridge(symbol="NSGetUncaughtExceptionHandler", optional=true)
    @Pointer
    private static native long getUncaughtExceptionHandler();

    @Bridge(dynamic=true)
    private static native void callUncaughtExceptionHandler(@Pointer long var0, NSException var2);

    @Bridge(symbol="NSSetUncaughtExceptionHandler", optional=true)
    private static native void setUncaughtExceptionHandler(FunctionPtr var0);

    @Method(selector="initWithName:reason:userInfo:")
    @Pointer
    protected native long init(String var1, String var2, NSDictionary<?, ?> var3);

    @Method(selector="raise")
    public native void raise();

    @Override
    @Method(selector="encodeWithCoder:")
    public native void encode(NSCoder var1);

    @Method(selector="initWithCoder:")
    @Pointer
    protected native long init(NSCoder var1);

    static {
        ObjCRuntime.bind(NSException.class);
        handler = null;
    }

    public static class NSExceptionPtr
    extends Ptr<NSException, NSExceptionPtr> {
    }
}

