/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.foundation;

import java.util.List;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSData;
import org.robovm.apple.foundation.NSDate;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSDirectoryEnumerationOptions;
import org.robovm.apple.foundation.NSDirectoryEnumerator;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.apple.foundation.NSFileAttributes;
import org.robovm.apple.foundation.NSFileManagerDelegate;
import org.robovm.apple.foundation.NSFileManagerItemReplacementOptions;
import org.robovm.apple.foundation.NSFileProviderService;
import org.robovm.apple.foundation.NSFileSystemAttributes;
import org.robovm.apple.foundation.NSNotification;
import org.robovm.apple.foundation.NSNotificationCenter;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSOperationQueue;
import org.robovm.apple.foundation.NSSearchPathDirectory;
import org.robovm.apple.foundation.NSSearchPathDomainMask;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.foundation.NSURL;
import org.robovm.apple.foundation.NSURLFileSystemProperty;
import org.robovm.apple.foundation.NSURLRelationship;
import org.robovm.apple.foundation.NSVolumeEnumerationOptions;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Block;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.objc.block.Block2;
import org.robovm.objc.block.VoidBlock1;
import org.robovm.objc.block.VoidBlock2;
import org.robovm.rt.bro.StringMarshalers;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.ptr.BooleanPtr;
import org.robovm.rt.bro.ptr.BytePtr;
import org.robovm.rt.bro.ptr.MachineSizedSIntPtr;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="Foundation")
@NativeClass
public class NSFileManager
extends NSObject {
    public NSFileManager() {
    }

    protected NSFileManager(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected NSFileManager(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Property(selector="defaultManager")
    public static native NSFileManager getDefaultManager();

    @Property(selector="delegate")
    public native NSFileManagerDelegate getDelegate();

    @Property(selector="setDelegate:", strongRef=true)
    public native void setDelegate(NSFileManagerDelegate var1);

    @Property(selector="currentDirectoryPath")
    public native String getCurrentDirectoryPath();

    @Property(selector="ubiquityIdentityToken")
    public native NSObject getUbiquityIdentityToken();

    @Property(selector="temporaryDirectory")
    public native NSURL getTemporaryDirectory();

    public boolean isDirectoryAtPath(String path) {
        BooleanPtr ptr = new BooleanPtr();
        this.fileExists(path, ptr);
        return ptr.get();
    }

    public NSURLRelationship getRelationshipOfDirectoryToItem(NSURL directoryURL, NSURL otherURL) throws NSErrorException {
        MachineSizedSIntPtr ptr = new MachineSizedSIntPtr();
        NSError.NSErrorPtr err = new NSError.NSErrorPtr();
        if (this.getRelationshipOfDirectoryToItem(ptr, directoryURL, otherURL, err)) {
            return NSURLRelationship.valueOf(ptr.get());
        }
        if (err.get() != null) {
            throw new NSErrorException((NSError)err.get());
        }
        return null;
    }

    public NSURLRelationship getRelationshipOfDirectoryToItem(NSSearchPathDirectory directory, NSSearchPathDomainMask domainMask, NSURL url) throws NSErrorException {
        MachineSizedSIntPtr ptr = new MachineSizedSIntPtr();
        NSError.NSErrorPtr err = new NSError.NSErrorPtr();
        if (this.getRelationshipOfDirectoryToItem(ptr, directory, domainMask, url, err)) {
            return NSURLRelationship.valueOf(ptr.get());
        }
        if (err.get() != null) {
            throw new NSErrorException((NSError)err.get());
        }
        return null;
    }

    @GlobalValue(symbol="NSUbiquityIdentityDidChangeNotification", optional=true)
    public static native NSString UbiquityIdentityDidChangeNotification();

    @Method(selector="mountedVolumeURLsIncludingResourceValuesForKeys:options:")
    protected native NSArray<NSURL> getMountedVolumeURLsIncludingResourceValues(@Marshaler(value=NSURLFileSystemProperty.AsListMarshaler.class) List<NSURLFileSystemProperty> var1, NSVolumeEnumerationOptions var2);

    public NSArray<NSURL> getContentsOfDirectoryAtURL(NSURL url, List<NSURLFileSystemProperty> keys, NSDirectoryEnumerationOptions mask) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        NSArray<NSURL> result = this.getContentsOfDirectoryAtURL(url, keys, mask, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="contentsOfDirectoryAtURL:includingPropertiesForKeys:options:error:")
    private native NSArray<NSURL> getContentsOfDirectoryAtURL(NSURL var1, @Marshaler(value=NSURLFileSystemProperty.AsListMarshaler.class) List<NSURLFileSystemProperty> var2, NSDirectoryEnumerationOptions var3, NSError.NSErrorPtr var4);

    @Method(selector="URLsForDirectory:inDomains:")
    public native NSArray<NSURL> getURLsForDirectory(NSSearchPathDirectory var1, NSSearchPathDomainMask var2);

    public NSURL getURLForDirectory(NSSearchPathDirectory directory, NSSearchPathDomainMask domain, NSURL url, boolean shouldCreate) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        NSURL result = this.getURLForDirectory(directory, domain, url, shouldCreate, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="URLForDirectory:inDomain:appropriateForURL:create:error:")
    private native NSURL getURLForDirectory(NSSearchPathDirectory var1, NSSearchPathDomainMask var2, NSURL var3, boolean var4, NSError.NSErrorPtr var5);

    protected boolean getRelationshipOfDirectoryToItem(MachineSizedSIntPtr outRelationship, NSURL directoryURL, NSURL otherURL) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.getRelationshipOfDirectoryToItem(outRelationship, directoryURL, otherURL, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="getRelationship:ofDirectoryAtURL:toItemAtURL:error:")
    private native boolean getRelationshipOfDirectoryToItem(MachineSizedSIntPtr var1, NSURL var2, NSURL var3, NSError.NSErrorPtr var4);

    protected boolean getRelationshipOfDirectoryToItem(MachineSizedSIntPtr outRelationship, NSSearchPathDirectory directory, NSSearchPathDomainMask domainMask, NSURL url) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.getRelationshipOfDirectoryToItem(outRelationship, directory, domainMask, url, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="getRelationship:ofDirectory:inDomain:toItemAtURL:error:")
    private native boolean getRelationshipOfDirectoryToItem(MachineSizedSIntPtr var1, NSSearchPathDirectory var2, NSSearchPathDomainMask var3, NSURL var4, NSError.NSErrorPtr var5);

    public boolean createDirectoryAtURL(NSURL url, boolean createIntermediates, NSFileAttributes attributes) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.createDirectoryAtURL(url, createIntermediates, attributes, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="createDirectoryAtURL:withIntermediateDirectories:attributes:error:")
    private native boolean createDirectoryAtURL(NSURL var1, boolean var2, NSFileAttributes var3, NSError.NSErrorPtr var4);

    public boolean createSymbolicLinkAtURL(NSURL url, NSURL destURL) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.createSymbolicLinkAtURL(url, destURL, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="createSymbolicLinkAtURL:withDestinationURL:error:")
    private native boolean createSymbolicLinkAtURL(NSURL var1, NSURL var2, NSError.NSErrorPtr var3);

    public boolean setAttributesForItem(NSFileAttributes attributes, String path) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.setAttributesForItem(attributes, path, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="setAttributes:ofItemAtPath:error:")
    private native boolean setAttributesForItem(NSFileAttributes var1, String var2, NSError.NSErrorPtr var3);

    public boolean createDirectoryAtPath(String path, boolean createIntermediates, NSFileAttributes attributes) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.createDirectoryAtPath(path, createIntermediates, attributes, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="createDirectoryAtPath:withIntermediateDirectories:attributes:error:")
    private native boolean createDirectoryAtPath(String var1, boolean var2, NSFileAttributes var3, NSError.NSErrorPtr var4);

    public NSArray<NSURL> getContentsOfDirectoryAtPath(String path) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        NSArray<NSURL> result = this.getContentsOfDirectoryAtPath(path, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="contentsOfDirectoryAtPath:error:")
    private native NSArray<NSURL> getContentsOfDirectoryAtPath(String var1, NSError.NSErrorPtr var2);

    public List<String> getSubpathsOfDirectoryAtPath(String path) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        List<String> result = this.getSubpathsOfDirectoryAtPath(path, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="subpathsOfDirectoryAtPath:error:")
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    private native List<String> getSubpathsOfDirectoryAtPath(String var1, NSError.NSErrorPtr var2);

    public NSFileAttributes getAttributesOfItemAtPath(String path) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        NSFileAttributes result = this.getAttributesOfItemAtPath(path, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="attributesOfItemAtPath:error:")
    private native NSFileAttributes getAttributesOfItemAtPath(String var1, NSError.NSErrorPtr var2);

    public NSFileSystemAttributes getAttributesOfFileSystemAtPath(String path) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        NSFileSystemAttributes result = this.getAttributesOfFileSystemAtPath(path, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="attributesOfFileSystemForPath:error:")
    private native NSFileSystemAttributes getAttributesOfFileSystemAtPath(String var1, NSError.NSErrorPtr var2);

    public boolean createSymbolicLinkAtPath(String path, String destPath) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.createSymbolicLinkAtPath(path, destPath, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="createSymbolicLinkAtPath:withDestinationPath:error:")
    private native boolean createSymbolicLinkAtPath(String var1, String var2, NSError.NSErrorPtr var3);

    public String getDestinationOfSymbolicLinkAtPath(String path) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        String result = this.getDestinationOfSymbolicLinkAtPath(path, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="destinationOfSymbolicLinkAtPath:error:")
    private native String getDestinationOfSymbolicLinkAtPath(String var1, NSError.NSErrorPtr var2);

    public boolean copyItemAtPath(String srcPath, String dstPath) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.copyItemAtPath(srcPath, dstPath, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="copyItemAtPath:toPath:error:")
    private native boolean copyItemAtPath(String var1, String var2, NSError.NSErrorPtr var3);

    public boolean moveItemAtPath(String srcPath, String dstPath) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.moveItemAtPath(srcPath, dstPath, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="moveItemAtPath:toPath:error:")
    private native boolean moveItemAtPath(String var1, String var2, NSError.NSErrorPtr var3);

    public boolean linkItemAtPath(String srcPath, String dstPath) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.linkItemAtPath(srcPath, dstPath, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="linkItemAtPath:toPath:error:")
    private native boolean linkItemAtPath(String var1, String var2, NSError.NSErrorPtr var3);

    public boolean removeItemAtPath(String path) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.removeItemAtPath(path, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="removeItemAtPath:error:")
    private native boolean removeItemAtPath(String var1, NSError.NSErrorPtr var2);

    public boolean copyItemAtURL(NSURL srcURL, NSURL dstURL) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.copyItemAtURL(srcURL, dstURL, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="copyItemAtURL:toURL:error:")
    private native boolean copyItemAtURL(NSURL var1, NSURL var2, NSError.NSErrorPtr var3);

    public boolean moveItemAtURL(NSURL srcURL, NSURL dstURL) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.moveItemAtURL(srcURL, dstURL, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="moveItemAtURL:toURL:error:")
    private native boolean moveItemAtURL(NSURL var1, NSURL var2, NSError.NSErrorPtr var3);

    public boolean linkItemAtURL(NSURL srcURL, NSURL dstURL) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.linkItemAtURL(srcURL, dstURL, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="linkItemAtURL:toURL:error:")
    private native boolean linkItemAtURL(NSURL var1, NSURL var2, NSError.NSErrorPtr var3);

    public boolean removeItemAtURL(NSURL URL2) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.removeItemAtURL(URL2, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="removeItemAtURL:error:")
    private native boolean removeItemAtURL(NSURL var1, NSError.NSErrorPtr var2);

    public boolean trashItemAtURL(NSURL url, NSURL.NSURLPtr outResultingURL) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.trashItemAtURL(url, outResultingURL, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="trashItemAtURL:resultingItemURL:error:")
    private native boolean trashItemAtURL(NSURL var1, NSURL.NSURLPtr var2, NSError.NSErrorPtr var3);

    @Method(selector="changeCurrentDirectoryPath:")
    public native boolean changeCurrentDirectoryPath(String var1);

    @Method(selector="fileExistsAtPath:")
    public native boolean fileExists(String var1);

    @Method(selector="fileExistsAtPath:isDirectory:")
    protected native boolean fileExists(String var1, BooleanPtr var2);

    @Method(selector="isReadableFileAtPath:")
    public native boolean fileIsReadable(String var1);

    @Method(selector="isWritableFileAtPath:")
    public native boolean fileIsWritable(String var1);

    @Method(selector="isExecutableFileAtPath:")
    public native boolean fileIsExecutable(String var1);

    @Method(selector="isDeletableFileAtPath:")
    public native boolean fileIsDeletable(String var1);

    @Method(selector="contentsEqualAtPath:andPath:")
    public native boolean contentsAtPathEqual(String var1, String var2);

    @Method(selector="displayNameAtPath:")
    public native String getDisplayNameAtPath(String var1);

    @Method(selector="componentsToDisplayForPath:")
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public native List<String> getComponentsToDisplayForPath(String var1);

    @Method(selector="enumeratorAtPath:")
    public native NSDirectoryEnumerator<NSString> getEnumeratorAtPath(String var1);

    @Method(selector="enumeratorAtURL:includingPropertiesForKeys:options:errorHandler:")
    protected native NSDirectoryEnumerator getEnumeratorAtURL(NSURL var1, @Marshaler(value=NSURLFileSystemProperty.AsListMarshaler.class) List<NSURLFileSystemProperty> var2, NSDirectoryEnumerationOptions var3, @Block Block2<NSURL, NSError, Boolean> var4);

    @Method(selector="subpathsAtPath:")
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public native List<String> getSubpathsAtPath(String var1);

    @Method(selector="contentsAtPath:")
    public native NSData getContentsAtPath(String var1);

    @Method(selector="createFileAtPath:contents:attributes:")
    public native boolean createFileAtPath(String var1, NSData var2, NSFileAttributes var3);

    @Method(selector="fileSystemRepresentationWithPath:")
    @Marshaler(value=StringMarshalers.AsDefaultCharsetZMarshaler.class)
    public native String getFileSystemRepresentationForPath(String var1);

    @Method(selector="stringWithFileSystemRepresentation:length:")
    public native String getPathForFileSystemRepresentation(BytePtr var1, @MachineSizedUInt long var2);

    public boolean replaceItemAtURL(NSURL originalItemURL, NSURL newItemURL, String backupItemName, NSFileManagerItemReplacementOptions options, NSURL.NSURLPtr resultingURL) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.replaceItemAtURL(originalItemURL, newItemURL, backupItemName, options, resultingURL, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="replaceItemAtURL:withItemAtURL:backupItemName:options:resultingItemURL:error:")
    private native boolean replaceItemAtURL(NSURL var1, NSURL var2, String var3, NSFileManagerItemReplacementOptions var4, NSURL.NSURLPtr var5, NSError.NSErrorPtr var6);

    public boolean setUbiquitousItemAtURL(boolean flag, NSURL url, NSURL destinationURL) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.setUbiquitousItemAtURL(flag, url, destinationURL, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="setUbiquitous:itemAtURL:destinationURL:error:")
    private native boolean setUbiquitousItemAtURL(boolean var1, NSURL var2, NSURL var3, NSError.NSErrorPtr var4);

    @Method(selector="isUbiquitousItemAtURL:")
    public native boolean isUbiquitousItemAtURL(NSURL var1);

    public boolean startDownloadingUbiquitousItemAtURL(NSURL url) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.startDownloadingUbiquitousItemAtURL(url, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="startDownloadingUbiquitousItemAtURL:error:")
    private native boolean startDownloadingUbiquitousItemAtURL(NSURL var1, NSError.NSErrorPtr var2);

    public boolean evictUbiquitousItemAtURL(NSURL url) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.evictUbiquitousItemAtURL(url, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="evictUbiquitousItemAtURL:error:")
    private native boolean evictUbiquitousItemAtURL(NSURL var1, NSError.NSErrorPtr var2);

    @Method(selector="URLForUbiquityContainerIdentifier:")
    public native NSURL getURLForUbiquityContainerIdentifier(String var1);

    public NSURL getURLForPublishingUbiquitousItemAtURL(NSURL url, NSDate.NSDatePtr outDate) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        NSURL result = this.getURLForPublishingUbiquitousItemAtURL(url, outDate, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="URLForPublishingUbiquitousItemAtURL:expirationDate:error:")
    private native NSURL getURLForPublishingUbiquitousItemAtURL(NSURL var1, NSDate.NSDatePtr var2, NSError.NSErrorPtr var3);

    @Method(selector="getFileProviderServicesForItemAtURL:completionHandler:")
    public native void getFileProviderServicesForItemAtURL(NSURL var1, @Block VoidBlock2<NSDictionary<NSString, NSFileProviderService>, NSError> var2);

    @Method(selector="containerURLForSecurityApplicationGroupIdentifier:")
    public native NSURL getContainerURLForSecurityApplication(String var1);

    static {
        ObjCRuntime.bind(NSFileManager.class);
    }

    public static class NSFileManagerPtr
    extends Ptr<NSFileManager, NSFileManagerPtr> {
    }

    public static class Notifications {
        public static NSObject observeUbiquityIdentityDidChange(final Runnable block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(NSFileManager.UbiquityIdentityDidChangeNotification(), null, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.run();
                }
            });
        }
    }
}

