/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.foundation;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSDictionaryWrapper;
import org.robovm.apple.foundation.NSFileSystemAttribute;
import org.robovm.apple.foundation.NSMutableArray;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="Foundation")
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
public class NSFileSystemAttributes
extends NSDictionaryWrapper {
    NSFileSystemAttributes(NSDictionary data) {
        super(data);
    }

    public NSFileSystemAttributes() {
    }

    public boolean has(NSFileSystemAttribute key) {
        return this.data.containsKey(key.value());
    }

    public NSObject get(NSFileSystemAttribute key) {
        if (this.has(key)) {
            return this.data.get(key.value());
        }
        return null;
    }

    public NSFileSystemAttributes set(NSFileSystemAttribute key, NSObject value) {
        this.data.put((NSObject)key.value(), value);
        return this;
    }

    public long getSystemNumber() {
        if (this.has(NSFileSystemAttribute.Number)) {
            NSNumber val = (NSNumber)this.get(NSFileSystemAttribute.Number);
            return val.longValue();
        }
        return 0L;
    }

    public NSFileSystemAttributes setSystemNumber(long systemNumber) {
        this.set(NSFileSystemAttribute.Number, NSNumber.valueOf(systemNumber));
        return this;
    }

    public long getSize() {
        if (this.has(NSFileSystemAttribute.Size)) {
            NSNumber val = (NSNumber)this.get(NSFileSystemAttribute.Size);
            return val.longValue();
        }
        return 0L;
    }

    public NSFileSystemAttributes setSize(long size) {
        this.set(NSFileSystemAttribute.Size, NSNumber.valueOf(size));
        return this;
    }

    public long getFreeSize() {
        if (this.has(NSFileSystemAttribute.FreeSize)) {
            NSNumber val = (NSNumber)this.get(NSFileSystemAttribute.FreeSize);
            return val.longValue();
        }
        return 0L;
    }

    public NSFileSystemAttributes setFreeSize(long freeSize) {
        this.set(NSFileSystemAttribute.FreeSize, NSNumber.valueOf(freeSize));
        return this;
    }

    public long getNodes() {
        if (this.has(NSFileSystemAttribute.Nodes)) {
            NSNumber val = (NSNumber)this.get(NSFileSystemAttribute.Nodes);
            return val.longValue();
        }
        return 0L;
    }

    public NSFileSystemAttributes setNodes(long nodes) {
        this.set(NSFileSystemAttribute.Nodes, NSNumber.valueOf(nodes));
        return this;
    }

    public long getFreeNodes() {
        if (this.has(NSFileSystemAttribute.FreeNodes)) {
            NSNumber val = (NSNumber)this.get(NSFileSystemAttribute.FreeNodes);
            return val.longValue();
        }
        return 0L;
    }

    public NSFileSystemAttributes setFreeNodes(long freeNodes) {
        this.set(NSFileSystemAttribute.FreeNodes, NSNumber.valueOf(freeNodes));
        return this;
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<NSFileSystemAttributes> toObject(Class<? extends NSObject> cls, long handle, long flags) {
            NSArray o = (NSArray)NSObject.Marshaler.toObject(NSArray.class, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<NSFileSystemAttributes> list = new ArrayList<NSFileSystemAttributes>();
            for (int i = 0; i < o.size(); ++i) {
                list.add(new NSFileSystemAttributes((NSDictionary)o.get(i)));
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<NSFileSystemAttributes> l, long flags) {
            if (l == null) {
                return 0L;
            }
            NSMutableArray<NSDictionary> array = new NSMutableArray<NSDictionary>();
            for (NSFileSystemAttributes i : l) {
                array.add(i.getDictionary());
            }
            return NSObject.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static NSFileSystemAttributes toObject(Class<NSFileSystemAttributes> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new NSFileSystemAttributes(o);
        }

        @MarshalsPointer
        public static long toNative(NSFileSystemAttributes o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

