/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.foundation;

import java.util.Map;
import org.robovm.apple.foundation.NSCoder;
import org.robovm.apple.foundation.NSData;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.apple.foundation.NSFileAttributes;
import org.robovm.apple.foundation.NSFileWrapperReadingOptions;
import org.robovm.apple.foundation.NSFileWrapperWritingOptions;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSSecureCoding;
import org.robovm.apple.foundation.NSURL;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="Foundation")
@NativeClass
public class NSFileWrapper
extends NSObject
implements NSSecureCoding {
    public NSFileWrapper() {
    }

    protected NSFileWrapper(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected NSFileWrapper(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Method(selector="initWithURL:options:error:")
    public NSFileWrapper(NSURL url, NSFileWrapperReadingOptions options) throws NSErrorException {
        super(null);
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        long handle = this.init(url, options, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        this.initObject(handle);
    }

    @Method(selector="initDirectoryWithFileWrappers:")
    public NSFileWrapper(@Marshaler(value=NSDictionary.AsStringMapMarshaler.class) Map<String, NSFileWrapper> childrenByPreferredName) {
        super(null);
        this.initObject(this.init(childrenByPreferredName));
    }

    @Method(selector="initRegularFileWithContents:")
    public NSFileWrapper(NSData contents) {
        super(null);
        this.initObject(this.init(contents));
    }

    @Method(selector="initSymbolicLinkWithDestinationURL:")
    public NSFileWrapper(NSURL url) {
        super(null);
        this.initObject(this.init(url));
    }

    @Method(selector="initWithCoder:")
    public NSFileWrapper(NSCoder inCoder) {
        super(null);
        this.initObject(this.init(inCoder));
    }

    @Property(selector="isDirectory")
    public native boolean isDirectory();

    @Property(selector="isRegularFile")
    public native boolean isRegularFile();

    @Property(selector="isSymbolicLink")
    public native boolean isSymbolicLink();

    @Property(selector="preferredFilename")
    public native String getPreferredFilename();

    @Property(selector="setPreferredFilename:")
    public native void setPreferredFilename(String var1);

    @Property(selector="filename")
    public native String getFilename();

    @Property(selector="setFilename:")
    public native void setFilename(String var1);

    @Property(selector="fileAttributes")
    public native NSFileAttributes getFileAttributes();

    @Property(selector="setFileAttributes:")
    public native void setFileAttributes(NSFileAttributes var1);

    @Property(selector="serializedRepresentation")
    public native NSData getSerializedRepresentation();

    @Property(selector="fileWrappers")
    @Marshaler(value=NSDictionary.AsStringMapMarshaler.class)
    public native Map<String, NSFileWrapper> getFileWrappers();

    @Property(selector="regularFileContents")
    public native NSData getRegularFileContents();

    @Property(selector="symbolicLinkDestinationURL")
    public native NSURL getSymbolicLinkDestinationURL();

    @Property(selector="supportsSecureCoding")
    public static native boolean supportsSecureCoding();

    public static NSFileWrapper deserialize(NSData data) {
        NSFileWrapper wrapper = new NSFileWrapper((NSObject.SkipInit)null);
        long handle = wrapper.initSerialized(data);
        if (handle == 0L) {
            return null;
        }
        wrapper.initObject(handle);
        return wrapper;
    }

    @Method(selector="initWithURL:options:error:")
    @Pointer
    private native long init(NSURL var1, NSFileWrapperReadingOptions var2, NSError.NSErrorPtr var3);

    @Method(selector="initDirectoryWithFileWrappers:")
    @Pointer
    protected native long init(@Marshaler(value=NSDictionary.AsStringMapMarshaler.class) Map<String, NSFileWrapper> var1);

    @Method(selector="initRegularFileWithContents:")
    @Pointer
    protected native long init(NSData var1);

    @Method(selector="initSymbolicLinkWithDestinationURL:")
    @Pointer
    protected native long init(NSURL var1);

    @Method(selector="initWithSerializedRepresentation:")
    @Pointer
    protected native long initSerialized(NSData var1);

    @Method(selector="initWithCoder:")
    @Pointer
    protected native long init(NSCoder var1);

    @Method(selector="matchesContentsOfURL:")
    public native boolean matchesContentsOfURL(NSURL var1);

    public boolean readFromURL(NSURL url, NSFileWrapperReadingOptions options) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.readFromURL(url, options, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="readFromURL:options:error:")
    private native boolean readFromURL(NSURL var1, NSFileWrapperReadingOptions var2, NSError.NSErrorPtr var3);

    public boolean writeToURL(NSURL url, NSFileWrapperWritingOptions options, NSURL originalContentsURL) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.writeToURL(url, options, originalContentsURL, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="writeToURL:options:originalContentsURL:error:")
    private native boolean writeToURL(NSURL var1, NSFileWrapperWritingOptions var2, NSURL var3, NSError.NSErrorPtr var4);

    @Method(selector="addFileWrapper:")
    public native String addFileWrapper(NSFileWrapper var1);

    @Method(selector="addRegularFileWithContents:preferredFilename:")
    public native String addRegularFile(NSData var1, String var2);

    @Method(selector="removeFileWrapper:")
    public native void removeFileWrapper(NSFileWrapper var1);

    @Method(selector="keyForFileWrapper:")
    public native String getKeyForFileWrapper(NSFileWrapper var1);

    @Override
    @Method(selector="encodeWithCoder:")
    public native void encode(NSCoder var1);

    static {
        ObjCRuntime.bind(NSFileWrapper.class);
    }

    public static class NSFileWrapperPtr
    extends Ptr<NSFileWrapper, NSFileWrapperPtr> {
    }
}

