/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.foundation;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSDate;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSDictionaryWrapper;
import org.robovm.apple.foundation.NSHTTPCookieAttribute;
import org.robovm.apple.foundation.NSMutableArray;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.foundation.NSURL;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="Foundation")
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
public class NSHTTPCookieAttributes
extends NSDictionaryWrapper {
    NSHTTPCookieAttributes(NSDictionary data) {
        super(data);
    }

    public NSHTTPCookieAttributes() {
    }

    public boolean has(NSHTTPCookieAttribute key) {
        return this.data.containsKey(key.value());
    }

    public NSObject get(NSHTTPCookieAttribute key) {
        if (this.has(key)) {
            return this.data.get(key.value());
        }
        return null;
    }

    public NSHTTPCookieAttributes set(NSHTTPCookieAttribute key, NSObject value) {
        this.data.put((NSObject)key.value(), value);
        return this;
    }

    public String getName() {
        if (this.has(NSHTTPCookieAttribute.Name)) {
            NSString val = (NSString)this.get(NSHTTPCookieAttribute.Name);
            return val.toString();
        }
        return null;
    }

    public NSHTTPCookieAttributes setName(String name) {
        this.set(NSHTTPCookieAttribute.Name, new NSString(name));
        return this;
    }

    public String getValue() {
        if (this.has(NSHTTPCookieAttribute.Value)) {
            NSString val = (NSString)this.get(NSHTTPCookieAttribute.Value);
            return val.toString();
        }
        return null;
    }

    public NSHTTPCookieAttributes setValue(String value) {
        this.set(NSHTTPCookieAttribute.Value, new NSString(value));
        return this;
    }

    public NSURL getOriginURL() {
        if (this.has(NSHTTPCookieAttribute.OriginURL)) {
            NSURL val = (NSURL)this.get(NSHTTPCookieAttribute.OriginURL);
            return val;
        }
        return null;
    }

    public NSHTTPCookieAttributes setOriginURL(NSURL originURL) {
        this.set(NSHTTPCookieAttribute.OriginURL, originURL);
        return this;
    }

    public int getVersion() {
        if (this.has(NSHTTPCookieAttribute.Version)) {
            NSNumber val = (NSNumber)this.get(NSHTTPCookieAttribute.Version);
            return val.intValue();
        }
        return 0;
    }

    public NSHTTPCookieAttributes setVersion(int version) {
        this.set(NSHTTPCookieAttribute.Version, NSNumber.valueOf(version));
        return this;
    }

    public String getDomain() {
        if (this.has(NSHTTPCookieAttribute.Domain)) {
            NSString val = (NSString)this.get(NSHTTPCookieAttribute.Domain);
            return val.toString();
        }
        return null;
    }

    public NSHTTPCookieAttributes setDomain(String domain) {
        this.set(NSHTTPCookieAttribute.Domain, new NSString(domain));
        return this;
    }

    public String getPath() {
        if (this.has(NSHTTPCookieAttribute.Path)) {
            NSString val = (NSString)this.get(NSHTTPCookieAttribute.Path);
            return val.toString();
        }
        return null;
    }

    public NSHTTPCookieAttributes setPath(String path) {
        this.set(NSHTTPCookieAttribute.Path, new NSString(path));
        return this;
    }

    public NSDate getExpireDate() {
        if (this.has(NSHTTPCookieAttribute.Expires)) {
            NSDate val = (NSDate)this.get(NSHTTPCookieAttribute.Expires);
            return val;
        }
        return null;
    }

    public NSHTTPCookieAttributes setExpireDate(NSDate expireDate) {
        this.set(NSHTTPCookieAttribute.Expires, expireDate);
        return this;
    }

    public String getComment() {
        if (this.has(NSHTTPCookieAttribute.Comment)) {
            NSString val = (NSString)this.get(NSHTTPCookieAttribute.Comment);
            return val.toString();
        }
        return null;
    }

    public NSHTTPCookieAttributes setComment(String comment) {
        this.set(NSHTTPCookieAttribute.Comment, new NSString(comment));
        return this;
    }

    public NSURL getCommentURL() {
        if (this.has(NSHTTPCookieAttribute.CommentURL)) {
            NSURL val = (NSURL)this.get(NSHTTPCookieAttribute.CommentURL);
            return val;
        }
        return null;
    }

    public NSHTTPCookieAttributes setCommentURL(NSURL commentURL) {
        this.set(NSHTTPCookieAttribute.CommentURL, commentURL);
        return this;
    }

    public int getMaximumAge() {
        if (this.has(NSHTTPCookieAttribute.MaximumAge)) {
            NSNumber val = (NSNumber)this.get(NSHTTPCookieAttribute.MaximumAge);
            return val.intValue();
        }
        return 0;
    }

    public NSHTTPCookieAttributes setMaximumAge(int maximumAge) {
        this.set(NSHTTPCookieAttribute.MaximumAge, NSNumber.valueOf(maximumAge));
        return this;
    }

    public String getPort() {
        if (this.has(NSHTTPCookieAttribute.Port)) {
            NSString val = (NSString)this.get(NSHTTPCookieAttribute.Port);
            return val.toString();
        }
        return null;
    }

    public NSHTTPCookieAttributes setPort(String port) {
        this.set(NSHTTPCookieAttribute.Port, new NSString(port));
        return this;
    }

    public boolean discards() {
        if (this.has(NSHTTPCookieAttribute.Discard)) {
            NSString val = (NSString)this.get(NSHTTPCookieAttribute.Discard);
            return val.toString().equals("TRUE");
        }
        return this.getVersion() >= 1 && this.getMaximumAge() == 0;
    }

    public NSHTTPCookieAttributes setDiscards(boolean discard) {
        this.set(NSHTTPCookieAttribute.Discard, discard ? new NSString("TRUE") : new NSString("FALSE"));
        return this;
    }

    public boolean isSecure() {
        return this.has(NSHTTPCookieAttribute.Secure);
    }

    public NSHTTPCookieAttributes setSecure(boolean secure) {
        this.set(NSHTTPCookieAttribute.Secure, secure ? new NSString("secure") : null);
        return this;
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<NSHTTPCookieAttributes> toObject(Class<? extends NSObject> cls, long handle, long flags) {
            NSArray o = (NSArray)NSObject.Marshaler.toObject(NSArray.class, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<NSHTTPCookieAttributes> list = new ArrayList<NSHTTPCookieAttributes>();
            for (int i = 0; i < o.size(); ++i) {
                list.add(new NSHTTPCookieAttributes((NSDictionary)o.get(i)));
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<NSHTTPCookieAttributes> l, long flags) {
            if (l == null) {
                return 0L;
            }
            NSMutableArray<NSDictionary> array = new NSMutableArray<NSDictionary>();
            for (NSHTTPCookieAttributes i : l) {
                array.add(i.getDictionary());
            }
            return NSObject.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static NSHTTPCookieAttributes toObject(Class<NSHTTPCookieAttributes> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new NSHTTPCookieAttributes(o);
        }

        @MarshalsPointer
        public static long toNative(NSHTTPCookieAttributes o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

