/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.foundation;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSNotification;
import org.robovm.apple.foundation.NSNotificationCenter;
import org.robovm.apple.foundation.NSNotificationCoalescing;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSPostingStyle;
import org.robovm.apple.foundation.NSRunLoopMode;
import org.robovm.apple.foundation.NSString;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="Foundation")
@NativeClass
public class NSNotificationQueue
extends NSObject {
    protected NSNotificationQueue(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected NSNotificationQueue(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Method(selector="initWithNotificationCenter:")
    public NSNotificationQueue(NSNotificationCenter notificationCenter) {
        super(null);
        this.initObject(this.init(notificationCenter));
    }

    @Property(selector="defaultQueue")
    public static native NSNotificationQueue getDefaultQueue();

    public void enqueueNotification(NSNotification notification, NSPostingStyle postingStyle, NSNotificationCoalescing coalesceMask, NSRunLoopMode ... modes) {
        ArrayList<String> list = new ArrayList<String>();
        for (NSRunLoopMode mode : modes) {
            list.add(((NSString)mode.value()).toString());
        }
        this.enqueueNotification(notification, postingStyle, coalesceMask, list);
    }

    @Method(selector="initWithNotificationCenter:")
    @Pointer
    protected native long init(NSNotificationCenter var1);

    @Method(selector="enqueueNotification:postingStyle:")
    public native void enqueueNotification(NSNotification var1, NSPostingStyle var2);

    @Method(selector="enqueueNotification:postingStyle:coalesceMask:forModes:")
    public native void enqueueNotification(NSNotification var1, NSPostingStyle var2, NSNotificationCoalescing var3, @Marshaler(value=NSArray.AsStringListMarshaler.class) List<String> var4);

    @Method(selector="dequeueNotificationsMatching:coalesceMask:")
    public native void dequeueNotificationsMatching(NSNotification var1, NSNotificationCoalescing var2);

    static {
        ObjCRuntime.bind(NSNotificationQueue.class);
    }

    public static class NSNotificationQueuePtr
    extends Ptr<NSNotificationQueue, NSNotificationQueuePtr> {
    }
}

