/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.gamekit;

import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorCode;
import org.robovm.apple.foundation.NSObject;
import org.robovm.rt.annotation.StronglyLinked;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.ValuedEnum;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Marshaler;

@Marshaler(value=ValuedEnum.AsMachineSizedSIntMarshaler.class)
@Library(value="GameKit")
public enum GKErrorCode implements NSErrorCode
{
    Unknown(1L),
    Cancelled(2L),
    CommunicationsFailure(3L),
    UserDenied(4L),
    InvalidCredentials(5L),
    NotAuthenticated(6L),
    AuthenticationInProgress(7L),
    InvalidPlayer(8L),
    ScoreNotSet(9L),
    ParentalControlsBlocked(10L),
    PlayerStatusExceedsMaximumLength(11L),
    PlayerStatusInvalid(12L),
    MatchRequestInvalid(13L),
    Underage(14L),
    GameUnrecognized(15L),
    NotSupported(16L),
    InvalidParameter(17L),
    UnexpectedConnection(18L),
    ChallengeInvalid(19L),
    TurnBasedMatchDataTooLarge(20L),
    TurnBasedTooManySessions(21L),
    TurnBasedInvalidParticipant(22L),
    TurnBasedInvalidTurn(23L),
    TurnBasedInvalidState(24L),
    InvitationsDisabled(25L),
    PlayerPhotoFailure(26L),
    UbiquityContainerUnavailable(27L),
    MatchNotConnected(28L),
    GameSessionRequestInvalid(29L),
    RestrictedToAutomatch(30L),
    APINotAvailable(31L);

    private final long n;

    @GlobalValue(symbol="GKErrorDomain", optional=true)
    public static native String getClassDomain();

    private GKErrorCode(long n2) {
        this.n = n2;
    }

    public long value() {
        return this.n;
    }

    public static GKErrorCode valueOf(long n) {
        for (GKErrorCode v : GKErrorCode.values()) {
            if (v.n != n) continue;
            return v;
        }
        throw new IllegalArgumentException("No constant with value " + n + " found in " + GKErrorCode.class.getName());
    }

    static {
        Bro.bind(GKErrorCode.class);
    }

    @StronglyLinked
    public static class NSErrorWrap
    extends NSError {
        protected NSErrorWrap(NSObject.SkipInit skipInit) {
            super(skipInit);
        }

        @Override
        public NSErrorCode getErrorCode() {
            try {
                return GKErrorCode.valueOf(this.getCode());
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        public static String getClassDomain() {
            return GKErrorCode.getClassDomain();
        }
    }
}

