/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.glkit;

import java.nio.FloatBuffer;
import org.robovm.apple.glkit.GLKMatrix2;
import org.robovm.apple.glkit.GLKMatrix3;
import org.robovm.apple.glkit.GLKQuaternion;
import org.robovm.apple.glkit.GLKVector3;
import org.robovm.apple.glkit.GLKVector4;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.Struct;
import org.robovm.rt.bro.annotation.Array;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.StructMember;
import org.robovm.rt.bro.ptr.BooleanPtr;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="GLKit")
public class GLKMatrix4
extends Struct<GLKMatrix4> {
    public GLKMatrix4() {
    }

    public GLKMatrix4(FloatBuffer m) {
        this.setM(m);
    }

    @StructMember(value=0)
    @Array(value={16})
    public native FloatBuffer getM();

    @StructMember(value=0)
    public native GLKMatrix4 setM(@Array(value={16}) FloatBuffer var1);

    @GlobalValue(symbol="GLKMatrix4Identity", optional=true)
    @ByVal
    public static native GLKMatrix4 Identity();

    public GLKMatrix4 invert(BooleanPtr isInvertible) {
        return GLKMatrix4.invert(this, isInvertible);
    }

    @Bridge(symbol="GLKMatrix4Invert", optional=true)
    @ByVal
    private static native GLKMatrix4 invert(@ByVal GLKMatrix4 var0, BooleanPtr var1);

    public GLKMatrix4 invertAndTranspose(BooleanPtr isInvertible) {
        return GLKMatrix4.invertAndTranspose(this, isInvertible);
    }

    @Bridge(symbol="GLKMatrix4InvertAndTranspose", optional=true)
    @ByVal
    private static native GLKMatrix4 invertAndTranspose(@ByVal GLKMatrix4 var0, BooleanPtr var1);

    public static GLKMatrix4 create(float m00, float m01, float m02, float m03, float m10, float m11, float m12, float m13, float m20, float m21, float m22, float m23, float m30, float m31, float m32, float m33) {
        float[] m = new float[]{m00, m01, m02, m03, m10, m11, m12, m13, m20, m21, m22, m23, m30, m31, m32, m33};
        return GLKMatrix4.create(m);
    }

    public static GLKMatrix4 createAndTranspose(float m00, float m01, float m02, float m03, float m10, float m11, float m12, float m13, float m20, float m21, float m22, float m23, float m30, float m31, float m32, float m33) {
        float[] m = new float[]{m00, m10, m20, m30, m01, m11, m21, m31, m02, m12, m22, m32, m03, m13, m23, m33};
        return GLKMatrix4.create(m);
    }

    public static GLKMatrix4 create(float[] values) {
        if (values == null || values.length != 16) {
            throw new IllegalArgumentException();
        }
        return new GLKMatrix4(FloatBuffer.wrap(values));
    }

    public static GLKMatrix4 createAndTranspose(float[] values) {
        float[] m = new float[]{values[0], values[4], values[8], values[12], values[1], values[5], values[9], values[13], values[2], values[6], values[10], values[14], values[3], values[7], values[11], values[15]};
        return GLKMatrix4.create(m);
    }

    public static GLKMatrix4 createWithRows(GLKVector4 row0, GLKVector4 row1, GLKVector4 row2, GLKVector4 row3) {
        FloatBuffer row0_v = row0.getV();
        FloatBuffer row1_v = row1.getV();
        FloatBuffer row2_v = row2.getV();
        FloatBuffer row3_v = row3.getV();
        float[] m = new float[]{row0_v.get(0), row1_v.get(0), row2_v.get(0), row3_v.get(0), row0_v.get(1), row1_v.get(1), row2_v.get(1), row3_v.get(1), row0_v.get(2), row1_v.get(2), row2_v.get(2), row3_v.get(2), row0_v.get(3), row1_v.get(3), row2_v.get(3), row3_v.get(3)};
        return GLKMatrix4.create(m);
    }

    public static GLKMatrix4 createWithColumns(GLKVector4 column0, GLKVector4 column1, GLKVector4 column2, GLKVector4 column3) {
        FloatBuffer column0_v = column0.getV();
        FloatBuffer column1_v = column1.getV();
        FloatBuffer column2_v = column2.getV();
        FloatBuffer column3_v = column3.getV();
        float[] m = new float[]{column0_v.get(0), column0_v.get(1), column0_v.get(2), column0_v.get(3), column1_v.get(0), column1_v.get(1), column1_v.get(2), column1_v.get(3), column2_v.get(0), column2_v.get(1), column2_v.get(2), column2_v.get(3), column3_v.get(0), column3_v.get(1), column3_v.get(2), column3_v.get(3)};
        return GLKMatrix4.create(m);
    }

    public static GLKMatrix4 create(GLKQuaternion quaternion) {
        quaternion = quaternion.normalize();
        float x = quaternion.getQ().get(0);
        float y = quaternion.getQ().get(1);
        float z = quaternion.getQ().get(2);
        float w = quaternion.getQ().get(3);
        float _2x = x + x;
        float _2y = y + y;
        float _2z = z + z;
        float _2w = w + w;
        float[] m = new float[]{1.0f - _2y * y - _2z * z, _2x * y + _2w * z, _2x * z - _2w * y, 0.0f, _2x * y - _2w * z, 1.0f - _2x * x - _2z * z, _2y * z + _2w * x, 0.0f, _2x * z + _2w * y, _2y * z - _2w * x, 1.0f - _2x * x - _2y * y, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        return GLKMatrix4.create(m);
    }

    public static GLKMatrix4 createTranslation(float tx, float ty, float tz) {
        GLKMatrix4 m = GLKMatrix4.Identity();
        FloatBuffer m_m = m.getM();
        m_m.put(12, tx);
        m_m.put(13, ty);
        m_m.put(14, tz);
        return m;
    }

    public static GLKMatrix4 createScale(float sx, float sy, float sz) {
        GLKMatrix4 m = GLKMatrix4.Identity();
        FloatBuffer m_m = m.getM();
        m_m.put(0, sx);
        m_m.put(5, sy);
        m_m.put(10, sz);
        return m;
    }

    public static GLKMatrix4 createRotation(float radians, float x, float y, float z) {
        GLKVector3 v = GLKVector3.create(x, y, z).normalize();
        float cos = (float)Math.cos(radians);
        float cosp = 1.0f - cos;
        float sin = (float)Math.sin(radians);
        FloatBuffer v_v = v.getV();
        float[] m = new float[]{cos + cosp * v_v.get(0) * v_v.get(0), cosp * v_v.get(0) * v_v.get(1) + v_v.get(2) * sin, cosp * v_v.get(0) * v_v.get(2) - v_v.get(1) * sin, 0.0f, cosp * v_v.get(0) * v_v.get(1) - v_v.get(2) * sin, cos + cosp * v_v.get(1) * v_v.get(1), cosp * v_v.get(1) * v_v.get(2) + v_v.get(0) * sin, 0.0f, cosp * v_v.get(0) * v_v.get(2) + v_v.get(1) * sin, cosp * v_v.get(1) * v_v.get(2) - v_v.get(0) * sin, cos + cosp * v_v.get(2) * v_v.get(2), 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        return GLKMatrix4.create(m);
    }

    public static GLKMatrix4 createXRotation(float radians) {
        float cos = (float)Math.cos(radians);
        float sin = (float)Math.sin(radians);
        float[] m = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, cos, sin, 0.0f, 0.0f, -sin, cos, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        return GLKMatrix4.create(m);
    }

    public static GLKMatrix4 createYRotation(float radians) {
        float cos = (float)Math.cos(radians);
        float sin = (float)Math.sin(radians);
        float[] m = new float[]{cos, 0.0f, -sin, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, sin, 0.0f, cos, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        return GLKMatrix4.create(m);
    }

    public static GLKMatrix4 createZRotation(float radians) {
        float cos = (float)Math.cos(radians);
        float sin = (float)Math.sin(radians);
        float[] m = new float[]{cos, sin, 0.0f, 0.0f, -sin, cos, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        return GLKMatrix4.create(m);
    }

    public static GLKMatrix4 createPerspective(float fovyRadians, float aspect, float nearZ, float farZ) {
        float cotan = (float)(1.0 / Math.tan(fovyRadians / 2.0f));
        float[] m = new float[]{cotan / aspect, 0.0f, 0.0f, 0.0f, 0.0f, cotan, 0.0f, 0.0f, 0.0f, 0.0f, (farZ + nearZ) / (nearZ - farZ), -1.0f, 0.0f, 0.0f, 2.0f * farZ * nearZ / (nearZ - farZ), 0.0f};
        return GLKMatrix4.create(m);
    }

    public static GLKMatrix4 createFrustum(float left, float right, float bottom, float top, float nearZ, float farZ) {
        float ral = right + left;
        float rsl = right - left;
        float tsb = top - bottom;
        float tab = top + bottom;
        float fan = farZ + nearZ;
        float fsn = farZ - nearZ;
        float[] m = new float[]{2.0f * nearZ / rsl, 0.0f, 0.0f, 0.0f, 0.0f, 2.0f * nearZ / tsb, 0.0f, 0.0f, ral / rsl, tab / tsb, -fan / fsn, -1.0f, 0.0f, 0.0f, -2.0f * farZ * nearZ / fsn, 0.0f};
        return GLKMatrix4.create(m);
    }

    public static GLKMatrix4 createOrtho(float left, float right, float bottom, float top, float nearZ, float farZ) {
        float ral = right + left;
        float rsl = right - left;
        float tab = top + bottom;
        float tsb = top - bottom;
        float fan = farZ + nearZ;
        float fsn = farZ - nearZ;
        float[] m = new float[]{2.0f / rsl, 0.0f, 0.0f, 0.0f, 0.0f, 2.0f / tsb, 0.0f, 0.0f, 0.0f, 0.0f, -2.0f / fsn, 0.0f, -ral / rsl, -tab / tsb, -fan / fsn, 1.0f};
        return GLKMatrix4.create(m);
    }

    public static GLKMatrix4 createLookAt(float eyeX, float eyeY, float eyeZ, float centerX, float centerY, float centerZ, float upX, float upY, float upZ) {
        GLKVector3 ev = GLKVector3.create(eyeX, eyeY, eyeZ);
        GLKVector3 cv = GLKVector3.create(centerX, centerY, centerZ);
        GLKVector3 uv = GLKVector3.create(upX, upY, upZ);
        GLKVector3 n = GLKVector3.add(ev, cv.negate()).normalize();
        GLKVector3 u = GLKVector3.crossProduct(uv, n).normalize();
        GLKVector3 v = GLKVector3.crossProduct(n, u);
        FloatBuffer u_v = u.getV();
        FloatBuffer v_v = u.getV();
        FloatBuffer n_v = u.getV();
        float[] m = new float[]{u_v.get(0), v_v.get(0), n_v.get(0), 0.0f, u_v.get(1), v_v.get(1), n_v.get(1), 0.0f, u_v.get(2), v_v.get(2), n_v.get(2), 0.0f, GLKVector3.dotProduct(u.negate(), ev), GLKVector3.dotProduct(v.negate(), ev), GLKVector3.dotProduct(n.negate(), ev), 1.0f};
        return GLKMatrix4.create(m);
    }

    public GLKMatrix3 getMatrix3() {
        FloatBuffer m_m = this.getM();
        float[] m = new float[]{m_m.get(0), m_m.get(1), m_m.get(2), m_m.get(4), m_m.get(5), m_m.get(6), m_m.get(8), m_m.get(9), m_m.get(10)};
        return GLKMatrix3.create(m);
    }

    public GLKMatrix2 getMatrix2() {
        FloatBuffer m_m = this.getM();
        float[] m = new float[]{m_m.get(0), m_m.get(1), m_m.get(4), m_m.get(5)};
        return GLKMatrix2.create(m);
    }

    public GLKVector4 getRow(int row) {
        FloatBuffer m_m = this.getM();
        GLKVector4 v = GLKVector4.create(m_m.get(row), m_m.get(4 + row), m_m.get(8 + row), m_m.get(12 + row));
        return v;
    }

    public GLKVector4 getColumn(int column) {
        FloatBuffer m_m = this.getM();
        GLKVector4 v = GLKVector4.create(m_m.get(column * 4 + 0), m_m.get(column * 4 + 1), m_m.get(column * 4 + 2), m_m.get(column * 4 + 3));
        return v;
    }

    public GLKMatrix4 setRow(int row, GLKVector4 vector) {
        GLKMatrix4 matrix = (GLKMatrix4)this.copy();
        FloatBuffer vector_v = vector.getV();
        FloatBuffer matrix_m = matrix.getM();
        matrix_m.put(row, vector_v.get(0));
        matrix_m.put(row + 4, vector_v.get(1));
        matrix_m.put(row + 8, vector_v.get(2));
        matrix_m.put(row + 12, vector_v.get(3));
        return matrix;
    }

    public GLKMatrix4 setColumn(int column, GLKVector4 vector) {
        GLKMatrix4 matrix = (GLKMatrix4)this.copy();
        FloatBuffer vector_v = vector.getV();
        FloatBuffer matrix_m = matrix.getM();
        matrix_m.put(column * 4 + 0, vector_v.get(0));
        matrix_m.put(column * 4 + 1, vector_v.get(1));
        matrix_m.put(column * 4 + 2, vector_v.get(2));
        matrix_m.put(column * 4 + 3, vector_v.get(3));
        return matrix;
    }

    public GLKMatrix4 transpose() {
        GLKMatrix4 matrix = (GLKMatrix4)this.copy();
        FloatBuffer matrix_m = matrix.getM();
        float[] m = new float[]{matrix_m.get(0), matrix_m.get(4), matrix_m.get(8), matrix_m.get(12), matrix_m.get(1), matrix_m.get(5), matrix_m.get(9), matrix_m.get(13), matrix_m.get(2), matrix_m.get(6), matrix_m.get(10), matrix_m.get(14), matrix_m.get(3), matrix_m.get(7), matrix_m.get(11), matrix_m.get(15)};
        return GLKMatrix4.create(m);
    }

    public GLKMatrix4 multiply(GLKMatrix4 matrixRight) {
        return GLKMatrix4.multiply(this, matrixRight);
    }

    public static GLKMatrix4 multiply(GLKMatrix4 matrixLeft, GLKMatrix4 matrixRight) {
        float[] m = new float[16];
        float[] matrixLeft_m = new float[16];
        float[] matrixRight_m = new float[16];
        matrixLeft.getM().get(matrixLeft_m);
        matrixRight.getM().get(matrixRight_m);
        m[0] = matrixLeft_m[0] * matrixRight_m[0] + matrixLeft_m[4] * matrixRight_m[1] + matrixLeft_m[8] * matrixRight_m[2] + matrixLeft_m[12] * matrixRight_m[3];
        m[4] = matrixLeft_m[0] * matrixRight_m[4] + matrixLeft_m[4] * matrixRight_m[5] + matrixLeft_m[8] * matrixRight_m[6] + matrixLeft_m[12] * matrixRight_m[7];
        m[8] = matrixLeft_m[0] * matrixRight_m[8] + matrixLeft_m[4] * matrixRight_m[9] + matrixLeft_m[8] * matrixRight_m[10] + matrixLeft_m[12] * matrixRight_m[11];
        m[12] = matrixLeft_m[0] * matrixRight_m[12] + matrixLeft_m[4] * matrixRight_m[13] + matrixLeft_m[8] * matrixRight_m[14] + matrixLeft_m[12] * matrixRight_m[15];
        m[1] = matrixLeft_m[1] * matrixRight_m[0] + matrixLeft_m[5] * matrixRight_m[1] + matrixLeft_m[9] * matrixRight_m[2] + matrixLeft_m[13] * matrixRight_m[3];
        m[5] = matrixLeft_m[1] * matrixRight_m[4] + matrixLeft_m[5] * matrixRight_m[5] + matrixLeft_m[9] * matrixRight_m[6] + matrixLeft_m[13] * matrixRight_m[7];
        m[9] = matrixLeft_m[1] * matrixRight_m[8] + matrixLeft_m[5] * matrixRight_m[9] + matrixLeft_m[9] * matrixRight_m[10] + matrixLeft_m[13] * matrixRight_m[11];
        m[13] = matrixLeft_m[1] * matrixRight_m[12] + matrixLeft_m[5] * matrixRight_m[13] + matrixLeft_m[9] * matrixRight_m[14] + matrixLeft_m[13] * matrixRight_m[15];
        m[2] = matrixLeft_m[2] * matrixRight_m[0] + matrixLeft_m[6] * matrixRight_m[1] + matrixLeft_m[10] * matrixRight_m[2] + matrixLeft_m[14] * matrixRight_m[3];
        m[6] = matrixLeft_m[2] * matrixRight_m[4] + matrixLeft_m[6] * matrixRight_m[5] + matrixLeft_m[10] * matrixRight_m[6] + matrixLeft_m[14] * matrixRight_m[7];
        m[10] = matrixLeft_m[2] * matrixRight_m[8] + matrixLeft_m[6] * matrixRight_m[9] + matrixLeft_m[10] * matrixRight_m[10] + matrixLeft_m[14] * matrixRight_m[11];
        m[14] = matrixLeft_m[2] * matrixRight_m[12] + matrixLeft_m[6] * matrixRight_m[13] + matrixLeft_m[10] * matrixRight_m[14] + matrixLeft_m[14] * matrixRight_m[15];
        m[3] = matrixLeft_m[3] * matrixRight_m[0] + matrixLeft_m[7] * matrixRight_m[1] + matrixLeft_m[11] * matrixRight_m[2] + matrixLeft_m[15] * matrixRight_m[3];
        m[7] = matrixLeft_m[3] * matrixRight_m[4] + matrixLeft_m[7] * matrixRight_m[5] + matrixLeft_m[11] * matrixRight_m[6] + matrixLeft_m[15] * matrixRight_m[7];
        m[11] = matrixLeft_m[3] * matrixRight_m[8] + matrixLeft_m[7] * matrixRight_m[9] + matrixLeft_m[11] * matrixRight_m[10] + matrixLeft_m[15] * matrixRight_m[11];
        m[15] = matrixLeft_m[3] * matrixRight_m[12] + matrixLeft_m[7] * matrixRight_m[13] + matrixLeft_m[11] * matrixRight_m[14] + matrixLeft_m[15] * matrixRight_m[15];
        return GLKMatrix4.create(m);
    }

    public GLKMatrix4 add(GLKMatrix4 matrixRight) {
        return GLKMatrix4.add(this, matrixRight);
    }

    public static GLKMatrix4 add(GLKMatrix4 matrixLeft, GLKMatrix4 matrixRight) {
        float[] m = new float[16];
        float[] matrixLeft_m = new float[16];
        float[] matrixRight_m = new float[16];
        matrixLeft.getM().get(matrixLeft_m);
        matrixRight.getM().get(matrixRight_m);
        m[0] = matrixLeft_m[0] + matrixRight_m[0];
        m[1] = matrixLeft_m[1] + matrixRight_m[1];
        m[2] = matrixLeft_m[2] + matrixRight_m[2];
        m[3] = matrixLeft_m[3] + matrixRight_m[3];
        m[4] = matrixLeft_m[4] + matrixRight_m[4];
        m[5] = matrixLeft_m[5] + matrixRight_m[5];
        m[6] = matrixLeft_m[6] + matrixRight_m[6];
        m[7] = matrixLeft_m[7] + matrixRight_m[7];
        m[8] = matrixLeft_m[8] + matrixRight_m[8];
        m[9] = matrixLeft_m[9] + matrixRight_m[9];
        m[10] = matrixLeft_m[10] + matrixRight_m[10];
        m[11] = matrixLeft_m[11] + matrixRight_m[11];
        m[12] = matrixLeft_m[12] + matrixRight_m[12];
        m[13] = matrixLeft_m[13] + matrixRight_m[13];
        m[14] = matrixLeft_m[14] + matrixRight_m[14];
        m[15] = matrixLeft_m[15] + matrixRight_m[15];
        return GLKMatrix4.create(m);
    }

    public GLKMatrix4 subtract(GLKMatrix4 matrixRight) {
        return GLKMatrix4.subtract(this, matrixRight);
    }

    public static GLKMatrix4 subtract(GLKMatrix4 matrixLeft, GLKMatrix4 matrixRight) {
        float[] m = new float[16];
        float[] matrixLeft_m = new float[16];
        float[] matrixRight_m = new float[16];
        matrixLeft.getM().get(matrixLeft_m);
        matrixRight.getM().get(matrixRight_m);
        m[0] = matrixLeft_m[0] - matrixRight_m[0];
        m[1] = matrixLeft_m[1] - matrixRight_m[1];
        m[2] = matrixLeft_m[2] - matrixRight_m[2];
        m[3] = matrixLeft_m[3] - matrixRight_m[3];
        m[4] = matrixLeft_m[4] - matrixRight_m[4];
        m[5] = matrixLeft_m[5] - matrixRight_m[5];
        m[6] = matrixLeft_m[6] - matrixRight_m[6];
        m[7] = matrixLeft_m[7] - matrixRight_m[7];
        m[8] = matrixLeft_m[8] - matrixRight_m[8];
        m[9] = matrixLeft_m[9] - matrixRight_m[9];
        m[10] = matrixLeft_m[10] - matrixRight_m[10];
        m[11] = matrixLeft_m[11] - matrixRight_m[11];
        m[12] = matrixLeft_m[12] - matrixRight_m[12];
        m[13] = matrixLeft_m[13] - matrixRight_m[13];
        m[14] = matrixLeft_m[14] - matrixRight_m[14];
        m[15] = matrixLeft_m[15] - matrixRight_m[15];
        return GLKMatrix4.create(m);
    }

    public GLKMatrix4 translate(float tx, float ty, float tz) {
        float[] matrix_m = new float[16];
        this.getM().get(matrix_m);
        float[] m = new float[]{matrix_m[0], matrix_m[1], matrix_m[2], matrix_m[3], matrix_m[4], matrix_m[5], matrix_m[6], matrix_m[7], matrix_m[8], matrix_m[9], matrix_m[10], matrix_m[11], matrix_m[0] * tx + matrix_m[4] * ty + matrix_m[8] * tz + matrix_m[12], matrix_m[1] * tx + matrix_m[5] * ty + matrix_m[9] * tz + matrix_m[13], matrix_m[2] * tx + matrix_m[6] * ty + matrix_m[10] * tz + matrix_m[14], matrix_m[3] * tx + matrix_m[7] * ty + matrix_m[11] * tz + matrix_m[15]};
        return GLKMatrix4.create(m);
    }

    public GLKMatrix4 translateWithVector3(GLKVector3 translationVector) {
        float[] matrix_m = new float[16];
        float[] translationVector_v = new float[3];
        this.getM().get(matrix_m);
        translationVector.getV().get(translationVector_v);
        float[] m = new float[]{matrix_m[0], matrix_m[1], matrix_m[2], matrix_m[3], matrix_m[4], matrix_m[5], matrix_m[6], matrix_m[7], matrix_m[8], matrix_m[9], matrix_m[10], matrix_m[11], matrix_m[0] * translationVector_v[0] + matrix_m[4] * translationVector_v[1] + matrix_m[8] * translationVector_v[2] + matrix_m[12], matrix_m[1] * translationVector_v[0] + matrix_m[5] * translationVector_v[1] + matrix_m[9] * translationVector_v[2] + matrix_m[13], matrix_m[2] * translationVector_v[0] + matrix_m[6] * translationVector_v[1] + matrix_m[10] * translationVector_v[2] + matrix_m[14], matrix_m[3] * translationVector_v[0] + matrix_m[7] * translationVector_v[1] + matrix_m[11] * translationVector_v[2] + matrix_m[15]};
        return GLKMatrix4.create(m);
    }

    public GLKMatrix4 translateWithVector4(GLKVector4 translationVector) {
        float[] matrix_m = new float[16];
        float[] translationVector_v = new float[4];
        this.getM().get(matrix_m);
        translationVector.getV().get(translationVector_v);
        float[] m = new float[]{matrix_m[0], matrix_m[1], matrix_m[2], matrix_m[3], matrix_m[4], matrix_m[5], matrix_m[6], matrix_m[7], matrix_m[8], matrix_m[9], matrix_m[10], matrix_m[11], matrix_m[0] * translationVector_v[0] + matrix_m[4] * translationVector_v[1] + matrix_m[8] * translationVector_v[2] + matrix_m[12], matrix_m[1] * translationVector_v[0] + matrix_m[5] * translationVector_v[1] + matrix_m[9] * translationVector_v[2] + matrix_m[13], matrix_m[2] * translationVector_v[0] + matrix_m[6] * translationVector_v[1] + matrix_m[10] * translationVector_v[2] + matrix_m[14], matrix_m[3] * translationVector_v[0] + matrix_m[7] * translationVector_v[1] + matrix_m[11] * translationVector_v[2] + matrix_m[15]};
        return GLKMatrix4.create(m);
    }

    public GLKMatrix4 scale(float sx, float sy, float sz) {
        float[] matrix_m = new float[16];
        this.getM().get(matrix_m);
        float[] m = new float[]{matrix_m[0] * sx, matrix_m[1] * sx, matrix_m[2] * sx, matrix_m[3] * sx, matrix_m[4] * sy, matrix_m[5] * sy, matrix_m[6] * sy, matrix_m[7] * sy, matrix_m[8] * sz, matrix_m[9] * sz, matrix_m[10] * sz, matrix_m[11] * sz, matrix_m[12], matrix_m[13], matrix_m[14], matrix_m[15]};
        return GLKMatrix4.create(m);
    }

    public GLKMatrix4 scaleWithVector3(GLKVector3 scaleVector) {
        float[] matrix_m = new float[16];
        float[] scaleVector_v = new float[3];
        this.getM().get(matrix_m);
        scaleVector.getV().get(scaleVector_v);
        float[] m = new float[]{matrix_m[0] * scaleVector_v[0], matrix_m[1] * scaleVector_v[0], matrix_m[2] * scaleVector_v[0], matrix_m[3] * scaleVector_v[0], matrix_m[4] * scaleVector_v[1], matrix_m[5] * scaleVector_v[1], matrix_m[6] * scaleVector_v[1], matrix_m[7] * scaleVector_v[1], matrix_m[8] * scaleVector_v[2], matrix_m[9] * scaleVector_v[2], matrix_m[10] * scaleVector_v[2], matrix_m[11] * scaleVector_v[2], matrix_m[12], matrix_m[13], matrix_m[14], matrix_m[15]};
        return GLKMatrix4.create(m);
    }

    public GLKMatrix4 scaleWithVector4(GLKVector4 scaleVector) {
        float[] matrix_m = new float[16];
        float[] scaleVector_v = new float[4];
        this.getM().get(matrix_m);
        scaleVector.getV().get(scaleVector_v);
        float[] m = new float[]{matrix_m[0] * scaleVector_v[0], matrix_m[1] * scaleVector_v[0], matrix_m[2] * scaleVector_v[0], matrix_m[3] * scaleVector_v[0], matrix_m[4] * scaleVector_v[1], matrix_m[5] * scaleVector_v[1], matrix_m[6] * scaleVector_v[1], matrix_m[7] * scaleVector_v[1], matrix_m[8] * scaleVector_v[2], matrix_m[9] * scaleVector_v[2], matrix_m[10] * scaleVector_v[2], matrix_m[11] * scaleVector_v[2], matrix_m[12], matrix_m[13], matrix_m[14], matrix_m[15]};
        return GLKMatrix4.create(m);
    }

    public GLKMatrix4 rotate(float radians, float x, float y, float z) {
        GLKMatrix4 rm = GLKMatrix4.createRotation(radians, x, y, z);
        return GLKMatrix4.multiply(this, rm);
    }

    public GLKMatrix4 rotateWithVector3(float radians, GLKVector3 axisVector) {
        GLKMatrix4 rm = GLKMatrix4.createRotation(radians, axisVector.getV().get(0), axisVector.getV().get(1), axisVector.getV().get(2));
        return GLKMatrix4.multiply(this, rm);
    }

    public GLKMatrix4 rotateWithVector4(float radians, GLKVector4 axisVector) {
        GLKMatrix4 rm = GLKMatrix4.createRotation(radians, axisVector.getV().get(0), axisVector.getV().get(1), axisVector.getV().get(2));
        return GLKMatrix4.multiply(this, rm);
    }

    public GLKMatrix4 rotateX(float radians) {
        GLKMatrix4 rm = GLKMatrix4.createXRotation(radians);
        return GLKMatrix4.multiply(this, rm);
    }

    public GLKMatrix4 rotateY(float radians) {
        GLKMatrix4 rm = GLKMatrix4.createYRotation(radians);
        return GLKMatrix4.multiply(this, rm);
    }

    public GLKMatrix4 rotateZ(float radians) {
        GLKMatrix4 rm = GLKMatrix4.createZRotation(radians);
        return GLKMatrix4.multiply(this, rm);
    }

    public GLKVector3 multiplyVector3(GLKVector3 vectorRight) {
        GLKVector4 v4 = this.multiplyVector4(GLKVector4.create(vectorRight, 0.0f));
        return GLKVector3.create(v4.getV().get(0), v4.getV().get(1), v4.getV().get(2));
    }

    public GLKVector3 multiplyVector3WithTranslation(GLKVector3 vectorRight) {
        GLKVector4 v4 = this.multiplyVector4(GLKVector4.create(vectorRight, 1.0f));
        return GLKVector3.create(v4.getV().get(0), v4.getV().get(1), v4.getV().get(2));
    }

    public GLKVector3 multiplyAndProjectVector3(GLKVector3 vectorRight) {
        GLKVector4 v4 = this.multiplyVector4(GLKVector4.create(vectorRight, 1.0f));
        return GLKVector3.create(v4.getV().get(0), v4.getV().get(1), v4.getV().get(2)).multiplyScalar(1.0f / v4.getV().get(4));
    }

    public void multiplyVector3Array(GLKVector3 vectors, long vectorCount) {
        GLKVector3 v = vectors;
        int i = 0;
        while ((long)i < vectorCount) {
            v.update(this.multiplyVector3(v));
            v = (GLKVector3)v.next();
            ++i;
        }
    }

    public void multiplyVector3ArrayWithTranslation(GLKVector3 vectors, long vectorCount) {
        GLKVector3 v = vectors;
        int i = 0;
        while ((long)i < vectorCount) {
            v.update(this.multiplyVector3WithTranslation(v));
            v = (GLKVector3)v.next();
            ++i;
        }
    }

    public void multiplyAndProjectVector3Array(GLKVector3 vectors, long vectorCount) {
        GLKVector3 v = vectors;
        int i = 0;
        while ((long)i < vectorCount) {
            v.update(this.multiplyAndProjectVector3(v));
            v = (GLKVector3)v.next();
            ++i;
        }
    }

    public GLKVector4 multiplyVector4(GLKVector4 vectorRight) {
        float[] m_m = new float[16];
        float[] vectorRight_v = new float[4];
        this.getM().get(m_m);
        vectorRight.getV().get(vectorRight_v);
        float[] v = new float[]{m_m[0] * vectorRight_v[0] + m_m[4] * vectorRight_v[1] + m_m[8] * vectorRight_v[2] + m_m[12] * vectorRight_v[3], m_m[1] * vectorRight_v[0] + m_m[5] * vectorRight_v[1] + m_m[9] * vectorRight_v[2] + m_m[13] * vectorRight_v[3], m_m[2] * vectorRight_v[0] + m_m[6] * vectorRight_v[1] + m_m[10] * vectorRight_v[2] + m_m[14] * vectorRight_v[3], m_m[3] * vectorRight_v[0] + m_m[7] * vectorRight_v[1] + m_m[11] * vectorRight_v[2] + m_m[15] * vectorRight_v[3]};
        return GLKVector4.create(v);
    }

    public void multiplyVector4Array(GLKVector4 vectors, long vectorCount) {
        GLKVector4 v = vectors;
        int i = 0;
        while ((long)i < vectorCount) {
            v.update(this.multiplyVector4(v));
            v = (GLKVector4)v.next();
            ++i;
        }
    }

    static {
        Bro.bind(GLKMatrix4.class);
    }

    public static class GLKMatrix4Ptr
    extends Ptr<GLKMatrix4, GLKMatrix4Ptr> {
    }
}

