/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.glkit;

import java.nio.FloatBuffer;
import org.robovm.apple.glkit.GLKMatrix3;
import org.robovm.apple.glkit.GLKMatrix4;
import org.robovm.apple.glkit.GLKVector3;
import org.robovm.apple.glkit.GLKVector4;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.Struct;
import org.robovm.rt.bro.annotation.Array;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.StructMember;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="GLKit")
public class GLKQuaternion
extends Struct<GLKQuaternion> {
    public GLKQuaternion() {
    }

    public GLKQuaternion(FloatBuffer q) {
        this.setQ(q);
    }

    @StructMember(value=0)
    @Array(value={4})
    public native FloatBuffer getQ();

    @StructMember(value=0)
    public native GLKQuaternion setQ(@Array(value={4}) FloatBuffer var1);

    @GlobalValue(symbol="GLKQuaternionIdentity", optional=true)
    @ByVal
    public static native GLKQuaternion Identity();

    @Bridge(symbol="GLKQuaternionMakeWithMatrix3", optional=true)
    @ByVal
    public static native GLKQuaternion create(@ByVal GLKMatrix3 var0);

    @Bridge(symbol="GLKQuaternionMakeWithMatrix4", optional=true)
    @ByVal
    public static native GLKQuaternion create(@ByVal GLKMatrix4 var0);

    public float angle() {
        return GLKQuaternion.angle(this);
    }

    @Bridge(symbol="GLKQuaternionAngle", optional=true)
    private static native float angle(@ByVal GLKQuaternion var0);

    public GLKVector3 axis() {
        return GLKQuaternion.axis(this);
    }

    @Bridge(symbol="GLKQuaternionAxis", optional=true)
    @ByVal
    private static native GLKVector3 axis(@ByVal GLKQuaternion var0);

    public GLKQuaternion slerp(GLKQuaternion quaternionEnd, float t) {
        return GLKQuaternion.slerp(this, quaternionEnd, t);
    }

    @Bridge(symbol="GLKQuaternionSlerp", optional=true)
    @ByVal
    private static native GLKQuaternion slerp(@ByVal GLKQuaternion var0, @ByVal GLKQuaternion var1, float var2);

    public void rotateVector3Array(GLKVector3 vectors, @MachineSizedUInt long vectorCount) {
        GLKQuaternion.rotateVector3Array(this, vectors, vectorCount);
    }

    @Bridge(symbol="GLKQuaternionRotateVector3Array", optional=true)
    private static native void rotateVector3Array(@ByVal GLKQuaternion var0, GLKVector3 var1, @MachineSizedUInt long var2);

    public void rotateVector4Array(GLKVector4 vectors, @MachineSizedUInt long vectorCount) {
        GLKQuaternion.rotateVector4Array(this, vectors, vectorCount);
    }

    @Bridge(symbol="GLKQuaternionRotateVector4Array", optional=true)
    private static native void rotateVector4Array(@ByVal GLKQuaternion var0, GLKVector4 var1, @MachineSizedUInt long var2);

    public static GLKQuaternion create(float x, float y, float z, float w) {
        float[] v = new float[]{x, y, z, w};
        return GLKQuaternion.create(v);
    }

    public static GLKQuaternion create(GLKVector3 vector, float scalar) {
        float[] v = new float[]{vector.getV().get(0), vector.getV().get(1), vector.getV().get(2), scalar};
        return GLKQuaternion.create(v);
    }

    public static GLKQuaternion create(float[] values) {
        return new GLKQuaternion(FloatBuffer.wrap(values));
    }

    public static GLKQuaternion createRotation(float radians, float x, float y, float z) {
        float halfAngle = radians * 0.5f;
        float scale = (float)Math.sin(halfAngle);
        float[] q = new float[]{scale * x, scale * y, scale * z, (float)Math.cos(halfAngle)};
        return GLKQuaternion.create(q);
    }

    public static GLKQuaternion createRotation(float radians, GLKVector3 axisVector) {
        return GLKQuaternion.createRotation(radians, axisVector.getV().get(0), axisVector.getV().get(1), axisVector.getV().get(2));
    }

    public GLKQuaternion add(GLKQuaternion quaternionRight) {
        return GLKQuaternion.add(this, quaternionRight);
    }

    public static GLKQuaternion add(GLKQuaternion quaternionLeft, GLKQuaternion quaternionRight) {
        float[] quaternionLeft_q = new float[4];
        float[] quaternionRight_q = new float[4];
        quaternionLeft.getQ().get(quaternionLeft_q);
        quaternionRight.getQ().get(quaternionRight_q);
        float[] q = new float[]{quaternionLeft_q[0] + quaternionRight_q[0], quaternionLeft_q[1] + quaternionRight_q[1], quaternionLeft_q[2] + quaternionRight_q[2], quaternionLeft_q[3] + quaternionRight_q[3]};
        return GLKQuaternion.create(q);
    }

    public GLKQuaternion subtract(GLKQuaternion quaternionRight) {
        return GLKQuaternion.subtract(this, quaternionRight);
    }

    public static GLKQuaternion subtract(GLKQuaternion quaternionLeft, GLKQuaternion quaternionRight) {
        float[] quaternionLeft_q = new float[4];
        float[] quaternionRight_q = new float[4];
        quaternionLeft.getQ().get(quaternionLeft_q);
        quaternionRight.getQ().get(quaternionRight_q);
        float[] q = new float[]{quaternionLeft_q[0] - quaternionRight_q[0], quaternionLeft_q[1] - quaternionRight_q[1], quaternionLeft_q[2] - quaternionRight_q[2], quaternionLeft_q[3] - quaternionRight_q[3]};
        return GLKQuaternion.create(q);
    }

    public GLKQuaternion multiply(GLKQuaternion quaternionRight) {
        return GLKQuaternion.multiply(this, quaternionRight);
    }

    public static GLKQuaternion multiply(GLKQuaternion quaternionLeft, GLKQuaternion quaternionRight) {
        float[] quaternionLeft_q = new float[4];
        float[] quaternionRight_q = new float[4];
        quaternionLeft.getQ().get(quaternionLeft_q);
        quaternionRight.getQ().get(quaternionRight_q);
        float[] q = new float[]{quaternionLeft_q[3] * quaternionRight_q[0] + quaternionLeft_q[0] * quaternionRight_q[3] + quaternionLeft_q[1] * quaternionRight_q[2] - quaternionLeft_q[2] * quaternionRight_q[1], quaternionLeft_q[3] * quaternionRight_q[1] + quaternionLeft_q[1] * quaternionRight_q[3] + quaternionLeft_q[2] * quaternionRight_q[0] - quaternionLeft_q[0] * quaternionRight_q[2], quaternionLeft_q[3] * quaternionRight_q[2] + quaternionLeft_q[2] * quaternionRight_q[3] + quaternionLeft_q[0] * quaternionRight_q[1] - quaternionLeft_q[1] * quaternionRight_q[0], quaternionLeft_q[3] * quaternionRight_q[3] - quaternionLeft_q[0] * quaternionRight_q[0] - quaternionLeft_q[1] * quaternionRight_q[1] - quaternionLeft_q[2] * quaternionRight_q[2]};
        return GLKQuaternion.create(q);
    }

    public float length() {
        float[] quaternion_q = new float[4];
        this.getQ().get(quaternion_q);
        return (float)Math.sqrt(quaternion_q[0] * quaternion_q[0] + quaternion_q[1] * quaternion_q[1] + quaternion_q[2] * quaternion_q[2] + quaternion_q[3] * quaternion_q[3]);
    }

    public GLKQuaternion conjugate() {
        float[] q = new float[]{-this.getQ().get(0), -this.getQ().get(1), -this.getQ().get(2), this.getQ().get(3)};
        return GLKQuaternion.create(q);
    }

    public GLKQuaternion invert() {
        float[] quaternion_q = new float[4];
        this.getQ().get(quaternion_q);
        float scale = 1.0f / (quaternion_q[0] * quaternion_q[0] + quaternion_q[1] * quaternion_q[1] + quaternion_q[2] * quaternion_q[2] + quaternion_q[3] * quaternion_q[3]);
        float[] q = new float[]{-quaternion_q[0] * scale, -quaternion_q[1] * scale, -quaternion_q[2] * scale, quaternion_q[3] * scale};
        return GLKQuaternion.create(q);
    }

    public GLKQuaternion normalize() {
        float[] quaternion_q = new float[4];
        this.getQ().get(quaternion_q);
        float scale = 1.0f / this.length();
        float[] q = new float[]{quaternion_q[0] * scale, quaternion_q[1] * scale, quaternion_q[2] * scale, quaternion_q[3] * scale};
        return GLKQuaternion.create(q);
    }

    public GLKVector3 rotateVector3(GLKVector3 vector) {
        GLKQuaternion rotatedQuaternion = GLKQuaternion.create(vector, 0.0f);
        rotatedQuaternion = this.multiply(rotatedQuaternion).multiply(this.invert());
        return GLKVector3.create(rotatedQuaternion.getQ().get(0), rotatedQuaternion.getQ().get(1), rotatedQuaternion.getQ().get(2));
    }

    public GLKVector4 rotateVector4(GLKVector4 vector) {
        GLKQuaternion rotatedQuaternion = GLKQuaternion.create(vector.getV().get(0), vector.getV().get(1), vector.getV().get(2), 0.0f);
        rotatedQuaternion = this.multiply(rotatedQuaternion).multiply(this.invert());
        return GLKVector4.create(rotatedQuaternion.getQ().get(0), rotatedQuaternion.getQ().get(1), rotatedQuaternion.getQ().get(2), rotatedQuaternion.getQ().get(3));
    }

    static {
        Bro.bind(GLKQuaternion.class);
    }

    public static class GLKQuaternionPtr
    extends Ptr<GLKQuaternion, GLKQuaternionPtr> {
    }
}

