/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.glkit;

import java.nio.FloatBuffer;
import org.robovm.apple.glkit.GLKVector3;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.Struct;
import org.robovm.rt.bro.annotation.Array;
import org.robovm.rt.bro.annotation.StructMember;
import org.robovm.rt.bro.ptr.Ptr;

public class GLKVector4
extends Struct<GLKVector4> {
    public GLKVector4() {
    }

    public GLKVector4(FloatBuffer v) {
        this.setV(v);
    }

    @StructMember(value=0)
    @Array(value={4})
    public native FloatBuffer getV();

    @StructMember(value=0)
    public native GLKVector4 setV(@Array(value={4}) FloatBuffer var1);

    public static GLKVector4 create(float x, float y, float z, float w) {
        float[] v = new float[]{x, y, z, w};
        return GLKVector4.create(v);
    }

    public static GLKVector4 create(float[] values) {
        if (values == null || values.length != 4) {
            throw new IllegalArgumentException();
        }
        return new GLKVector4(FloatBuffer.wrap(values));
    }

    public static GLKVector4 create(GLKVector3 vector, float w) {
        float[] v = new float[]{vector.getV().get(0), vector.getV().get(1), vector.getV().get(2), w};
        return GLKVector4.create(v);
    }

    public GLKVector4 negate() {
        float[] v = new float[]{-this.getV().get(0), -this.getV().get(1), -this.getV().get(2), -this.getV().get(3)};
        return GLKVector4.create(v);
    }

    public GLKVector4 add(GLKVector4 vectorRight) {
        return GLKVector4.add(this, vectorRight);
    }

    public static GLKVector4 add(GLKVector4 vectorLeft, GLKVector4 vectorRight) {
        float[] vectorLeft_v = new float[4];
        float[] vectorRight_v = new float[4];
        vectorLeft.getV().get(vectorLeft_v);
        vectorRight.getV().get(vectorRight_v);
        float[] v = new float[]{vectorLeft_v[0] + vectorRight_v[0], vectorLeft_v[1] + vectorRight_v[1], vectorLeft_v[2] + vectorRight_v[2], vectorLeft_v[3] + vectorRight_v[3]};
        return GLKVector4.create(v);
    }

    public GLKVector4 subtract(GLKVector4 vectorRight) {
        return GLKVector4.subtract(this, vectorRight);
    }

    public static GLKVector4 subtract(GLKVector4 vectorLeft, GLKVector4 vectorRight) {
        float[] vectorLeft_v = new float[4];
        float[] vectorRight_v = new float[4];
        vectorLeft.getV().get(vectorLeft_v);
        vectorRight.getV().get(vectorRight_v);
        float[] v = new float[]{vectorLeft_v[0] - vectorRight_v[0], vectorLeft_v[1] - vectorRight_v[1], vectorLeft_v[2] - vectorRight_v[2], vectorLeft_v[3] - vectorRight_v[3]};
        return GLKVector4.create(v);
    }

    public GLKVector4 multiply(GLKVector4 vectorRight) {
        return GLKVector4.multiply(this, vectorRight);
    }

    public static GLKVector4 multiply(GLKVector4 vectorLeft, GLKVector4 vectorRight) {
        float[] vectorLeft_v = new float[4];
        float[] vectorRight_v = new float[4];
        vectorLeft.getV().get(vectorLeft_v);
        vectorRight.getV().get(vectorRight_v);
        float[] v = new float[]{vectorLeft_v[0] * vectorRight_v[0], vectorLeft_v[1] * vectorRight_v[1], vectorLeft_v[2] * vectorRight_v[2], vectorLeft_v[3] * vectorRight_v[3]};
        return GLKVector4.create(v);
    }

    public GLKVector4 divide(GLKVector4 vectorRight) {
        return GLKVector4.divide(this, vectorRight);
    }

    public static GLKVector4 divide(GLKVector4 vectorLeft, GLKVector4 vectorRight) {
        float[] vectorLeft_v = new float[4];
        float[] vectorRight_v = new float[4];
        vectorLeft.getV().get(vectorLeft_v);
        vectorRight.getV().get(vectorRight_v);
        float[] v = new float[]{vectorLeft_v[0] / vectorRight_v[0], vectorLeft_v[1] / vectorRight_v[1], vectorLeft_v[2] / vectorRight_v[2], vectorLeft_v[3] / vectorRight_v[3]};
        return GLKVector4.create(v);
    }

    public GLKVector4 addScalar(float value) {
        float[] vector_v = new float[4];
        this.getV().get(vector_v);
        float[] v = new float[]{vector_v[0] + value, vector_v[1] + value, vector_v[2] + value, vector_v[3] + value};
        return GLKVector4.create(v);
    }

    public GLKVector4 subtractScalar(float value) {
        float[] vector_v = new float[4];
        this.getV().get(vector_v);
        float[] v = new float[]{vector_v[0] - value, vector_v[1] - value, vector_v[2] - value, vector_v[3] - value};
        return GLKVector4.create(v);
    }

    public GLKVector4 multiplyScalar(float value) {
        float[] vector_v = new float[4];
        this.getV().get(vector_v);
        float[] v = new float[]{vector_v[0] * value, vector_v[1] * value, vector_v[2] * value, vector_v[3] * value};
        return GLKVector4.create(v);
    }

    public GLKVector4 divideScalar(float value) {
        float[] vector_v = new float[4];
        this.getV().get(vector_v);
        float[] v = new float[]{vector_v[0] / value, vector_v[1] / value, vector_v[2] / value, vector_v[3] / value};
        return GLKVector4.create(v);
    }

    public GLKVector4 maximum(GLKVector4 vectorRight) {
        return GLKVector4.maximum(this, vectorRight);
    }

    public static GLKVector4 maximum(GLKVector4 vectorLeft, GLKVector4 vectorRight) {
        float[] vectorLeft_v = new float[4];
        float[] vectorRight_v = new float[4];
        vectorLeft.getV().get(vectorLeft_v);
        vectorRight.getV().get(vectorRight_v);
        GLKVector4 max = (GLKVector4)vectorLeft.copy();
        if (vectorRight_v[0] > vectorLeft_v[0]) {
            max.getV().put(0, vectorRight_v[0]);
        }
        if (vectorRight_v[1] > vectorLeft_v[1]) {
            max.getV().put(1, vectorRight_v[1]);
        }
        if (vectorRight_v[2] > vectorLeft_v[2]) {
            max.getV().put(2, vectorRight_v[2]);
        }
        if (vectorRight_v[3] > vectorLeft_v[3]) {
            max.getV().put(3, vectorRight_v[3]);
        }
        return max;
    }

    public GLKVector4 minimum(GLKVector4 vectorRight) {
        return GLKVector4.minimum(this, vectorRight);
    }

    public static GLKVector4 minimum(GLKVector4 vectorLeft, GLKVector4 vectorRight) {
        float[] vectorLeft_v = new float[4];
        float[] vectorRight_v = new float[4];
        vectorLeft.getV().get(vectorLeft_v);
        vectorRight.getV().get(vectorRight_v);
        GLKVector4 min = (GLKVector4)vectorLeft.copy();
        if (vectorRight_v[0] < vectorLeft_v[0]) {
            min.getV().put(0, vectorRight_v[0]);
        }
        if (vectorRight_v[1] < vectorLeft_v[1]) {
            min.getV().put(1, vectorRight_v[1]);
        }
        if (vectorRight_v[2] < vectorLeft_v[2]) {
            min.getV().put(2, vectorRight_v[2]);
        }
        if (vectorRight_v[3] < vectorLeft_v[3]) {
            min.getV().put(3, vectorRight_v[3]);
        }
        return min;
    }

    public boolean allEqualToVector4(GLKVector4 vectorRight) {
        return GLKVector4.allEqualToVector4(this, vectorRight);
    }

    public static boolean allEqualToVector4(GLKVector4 vectorLeft, GLKVector4 vectorRight) {
        float[] vectorLeft_v = new float[4];
        float[] vectorRight_v = new float[4];
        vectorLeft.getV().get(vectorLeft_v);
        vectorRight.getV().get(vectorRight_v);
        boolean compare = false;
        if (vectorLeft_v[0] == vectorRight_v[0] && vectorLeft_v[1] == vectorRight_v[1] && vectorLeft_v[2] == vectorRight_v[2] && vectorLeft_v[3] == vectorRight_v[3]) {
            compare = true;
        }
        return compare;
    }

    public boolean allEqualToScalar(float value) {
        boolean compare = false;
        if (this.getV().get(0) == value && this.getV().get(1) == value && this.getV().get(2) == value && this.getV().get(3) == value) {
            compare = true;
        }
        return compare;
    }

    public boolean allGreaterThanVector4(GLKVector4 vectorRight) {
        return GLKVector4.allGreaterThanVector4(this, vectorRight);
    }

    public static boolean allGreaterThanVector4(GLKVector4 vectorLeft, GLKVector4 vectorRight) {
        float[] vectorLeft_v = new float[4];
        float[] vectorRight_v = new float[4];
        vectorLeft.getV().get(vectorLeft_v);
        vectorRight.getV().get(vectorRight_v);
        boolean compare = false;
        if (vectorLeft_v[0] > vectorRight_v[0] && vectorLeft_v[1] > vectorRight_v[1] && vectorLeft_v[2] > vectorRight_v[2] && vectorLeft_v[3] > vectorRight_v[3]) {
            compare = true;
        }
        return compare;
    }

    public boolean allGreaterThanScalar(float value) {
        boolean compare = false;
        if (this.getV().get(0) > value && this.getV().get(1) > value && this.getV().get(2) > value && this.getV().get(3) > value) {
            compare = true;
        }
        return compare;
    }

    public boolean allGreaterThanOrEqualToVector4(GLKVector4 vectorRight) {
        return GLKVector4.allGreaterThanOrEqualToVector4(this, vectorRight);
    }

    public static boolean allGreaterThanOrEqualToVector4(GLKVector4 vectorLeft, GLKVector4 vectorRight) {
        float[] vectorLeft_v = new float[4];
        float[] vectorRight_v = new float[4];
        vectorLeft.getV().get(vectorLeft_v);
        vectorRight.getV().get(vectorRight_v);
        boolean compare = false;
        if (vectorLeft_v[0] >= vectorRight_v[0] && vectorLeft_v[1] >= vectorRight_v[1] && vectorLeft_v[2] >= vectorRight_v[2] && vectorLeft_v[3] >= vectorRight_v[3]) {
            compare = true;
        }
        return compare;
    }

    public boolean allGreaterThanOrEqualToScalar(float value) {
        boolean compare = false;
        if (this.getV().get(0) >= value && this.getV().get(1) >= value && this.getV().get(2) >= value && this.getV().get(3) >= value) {
            compare = true;
        }
        return compare;
    }

    public GLKVector4 normalize() {
        float scale = 1.0f / this.length();
        GLKVector4 v = this.multiplyScalar(scale);
        return v;
    }

    public float dotProduct(GLKVector4 vectorRight) {
        return GLKVector4.dotProduct(this, vectorRight);
    }

    public static float dotProduct(GLKVector4 vectorLeft, GLKVector4 vectorRight) {
        float[] vectorLeft_v = new float[4];
        float[] vectorRight_v = new float[4];
        vectorLeft.getV().get(vectorLeft_v);
        vectorRight.getV().get(vectorRight_v);
        return vectorLeft_v[0] * vectorRight_v[0] + vectorLeft_v[1] * vectorRight_v[1] + vectorLeft_v[2] * vectorRight_v[2] + vectorLeft_v[3] * vectorRight_v[3];
    }

    public float length() {
        float[] vector_v = new float[4];
        this.getV().get(vector_v);
        return (float)Math.sqrt(vector_v[0] * vector_v[0] + vector_v[1] * vector_v[1] + vector_v[2] * vector_v[2] + vector_v[3] * vector_v[3]);
    }

    public float distance(GLKVector4 vectorEnd) {
        return GLKVector4.distance(this, vectorEnd);
    }

    public static float distance(GLKVector4 vectorStart, GLKVector4 vectorEnd) {
        return GLKVector4.subtract(vectorEnd, vectorStart).length();
    }

    public GLKVector4 lerp(GLKVector4 vectorEnd, float t) {
        return GLKVector4.lerp(this, vectorEnd, t);
    }

    public static GLKVector4 lerp(GLKVector4 vectorStart, GLKVector4 vectorEnd, float t) {
        float[] vectorStart_v = new float[4];
        float[] vectorEnd_v = new float[4];
        vectorStart.getV().get(vectorStart_v);
        vectorEnd.getV().get(vectorEnd_v);
        float[] v = new float[]{vectorStart_v[0] + (vectorEnd_v[0] - vectorStart_v[0]) * t, vectorStart_v[1] + (vectorEnd_v[1] - vectorStart_v[1]) * t, vectorStart_v[2] + (vectorEnd_v[2] - vectorStart_v[2]) * t, vectorStart_v[3] + (vectorEnd_v[3] - vectorStart_v[3]) * t};
        return GLKVector4.create(v);
    }

    public GLKVector4 crossProduct(GLKVector4 vectorRight) {
        return GLKVector4.crossProduct(this, vectorRight);
    }

    public static GLKVector4 crossProduct(GLKVector4 vectorLeft, GLKVector4 vectorRight) {
        float[] vectorLeft_v = new float[4];
        float[] vectorRight_v = new float[4];
        vectorLeft.getV().get(vectorLeft_v);
        vectorRight.getV().get(vectorRight_v);
        float[] v = new float[]{vectorLeft_v[1] * vectorRight_v[2] - vectorLeft_v[2] * vectorRight_v[1], vectorLeft_v[2] * vectorRight_v[0] - vectorLeft_v[0] * vectorRight_v[2], vectorLeft_v[0] * vectorRight_v[1] - vectorLeft_v[1] * vectorRight_v[0], 0.0f};
        return GLKVector4.create(v);
    }

    public GLKVector4 project(GLKVector4 projectionVector) {
        return GLKVector4.project(this, projectionVector);
    }

    public static GLKVector4 project(GLKVector4 vectorToProject, GLKVector4 projectionVector) {
        float scale = GLKVector4.dotProduct(projectionVector, vectorToProject) / GLKVector4.dotProduct(projectionVector, projectionVector);
        GLKVector4 v = projectionVector.multiplyScalar(scale);
        return v;
    }

    static {
        Bro.bind(GLKVector4.class);
    }

    public static class GLKVector4Ptr
    extends Ptr<GLKVector4, GLKVector4Ptr> {
    }
}

