/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.imageio;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.corefoundation.CFArray;
import org.robovm.apple.corefoundation.CFBoolean;
import org.robovm.apple.corefoundation.CFDictionary;
import org.robovm.apple.corefoundation.CFDictionaryWrapper;
import org.robovm.apple.corefoundation.CFMutableArray;
import org.robovm.apple.corefoundation.CFNumber;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.foundation.NSDate;
import org.robovm.apple.imageio.CGImageMetadata;
import org.robovm.apple.imageio.CGImagePropertyOrientation;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="ImageIO")
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
public class CGImageDestinationCopySourceOptions
extends CFDictionaryWrapper {
    CGImageDestinationCopySourceOptions(CFDictionary data) {
        super(data);
    }

    public CGImageDestinationCopySourceOptions() {
    }

    public boolean has(CFString key) {
        return this.data.containsKey(key);
    }

    public <T extends NativeObject> T get(CFString key, Class<T> type) {
        if (this.has(key)) {
            return this.data.get(key, type);
        }
        return null;
    }

    public CGImageDestinationCopySourceOptions set(CFString key, NativeObject value) {
        this.data.put(key, value);
        return this;
    }

    public CGImageMetadata getMetadata() {
        if (this.has(Keys.DestinationMetadata())) {
            CGImageMetadata val = this.get(Keys.DestinationMetadata(), CGImageMetadata.class);
            return val;
        }
        return null;
    }

    public CGImageDestinationCopySourceOptions setMetadata(CGImageMetadata metadata) {
        this.set(Keys.DestinationMetadata(), metadata);
        return this;
    }

    public boolean mergesMetadata() {
        if (this.has(Keys.DestinationMergeMetadata())) {
            CFBoolean val = this.get(Keys.DestinationMergeMetadata(), CFBoolean.class);
            return val.booleanValue();
        }
        return false;
    }

    public CGImageDestinationCopySourceOptions setMergesMetadata(boolean mergesMetadata) {
        this.set(Keys.DestinationMergeMetadata(), CFBoolean.valueOf(mergesMetadata));
        return this;
    }

    public boolean shouldExcludeXMP() {
        if (this.has(Keys.MetadataShouldExcludeXMP())) {
            CFBoolean val = this.get(Keys.MetadataShouldExcludeXMP(), CFBoolean.class);
            return val.booleanValue();
        }
        return false;
    }

    public CGImageDestinationCopySourceOptions setShouldExcludeXMP(boolean shouldExcludeXMP) {
        this.set(Keys.MetadataShouldExcludeXMP(), CFBoolean.valueOf(shouldExcludeXMP));
        return this;
    }

    public boolean shouldExcludeGPS() {
        if (this.has(Keys.MetadataShouldExcludeGPS())) {
            CFBoolean val = this.get(Keys.MetadataShouldExcludeGPS(), CFBoolean.class);
            return val.booleanValue();
        }
        return false;
    }

    public CGImageDestinationCopySourceOptions setShouldExcludeGPS(boolean shouldExcludeGPS) {
        this.set(Keys.MetadataShouldExcludeGPS(), CFBoolean.valueOf(shouldExcludeGPS));
        return this;
    }

    public String getDateTime() {
        if (this.has(Keys.DestinationDateTime())) {
            CFString val = this.get(Keys.DestinationDateTime(), CFString.class);
            return val.toString();
        }
        return null;
    }

    public CGImageDestinationCopySourceOptions setDateTime(String dateTime) {
        this.set(Keys.DestinationDateTime(), new CFString(dateTime));
        return this;
    }

    public CGImagePropertyOrientation getOrientation() {
        if (this.has(Keys.DestinationOrientation())) {
            CFNumber val = this.get(Keys.DestinationOrientation(), CFNumber.class);
            return CGImagePropertyOrientation.valueOf(val.longValue());
        }
        return null;
    }

    public CGImageDestinationCopySourceOptions setOrientation(CGImagePropertyOrientation orientation) {
        this.set(Keys.DestinationOrientation(), CFNumber.valueOf(orientation.value()));
        return this;
    }

    public CGImageDestinationCopySourceOptions setDateTime(NSDate dateTime) {
        this.set(Keys.DestinationDateTime(), (NativeObject)dateTime);
        return this;
    }

    @Library(value="ImageIO")
    public static class Keys {
        @GlobalValue(symbol="kCGImageDestinationMetadata", optional=true)
        public static native CFString DestinationMetadata();

        @GlobalValue(symbol="kCGImageDestinationMergeMetadata", optional=true)
        public static native CFString DestinationMergeMetadata();

        @GlobalValue(symbol="kCGImageMetadataShouldExcludeXMP", optional=true)
        public static native CFString MetadataShouldExcludeXMP();

        @GlobalValue(symbol="kCGImageMetadataShouldExcludeGPS", optional=true)
        public static native CFString MetadataShouldExcludeGPS();

        @GlobalValue(symbol="kCGImageDestinationDateTime", optional=true)
        public static native CFString DestinationDateTime();

        @GlobalValue(symbol="kCGImageDestinationOrientation", optional=true)
        public static native CFString DestinationOrientation();

        static {
            Bro.bind(Keys.class);
        }
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<CGImageDestinationCopySourceOptions> toObject(Class<? extends CFType> cls, long handle, long flags) {
            CFArray o = (CFArray)CFType.Marshaler.toObject(CFArray.class, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<CGImageDestinationCopySourceOptions> list = new ArrayList<CGImageDestinationCopySourceOptions>();
            int i = 0;
            while ((long)i < o.size()) {
                list.add(new CGImageDestinationCopySourceOptions(o.get(i, CFDictionary.class)));
                ++i;
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<CGImageDestinationCopySourceOptions> l, long flags) {
            if (l == null) {
                return 0L;
            }
            CFMutableArray array = CFMutableArray.create();
            for (CGImageDestinationCopySourceOptions i : l) {
                ((CFArray)array).add(i.getDictionary());
            }
            return CFType.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static CGImageDestinationCopySourceOptions toObject(Class<CGImageDestinationCopySourceOptions> cls, long handle, long flags) {
            CFDictionary o = (CFDictionary)CFType.Marshaler.toObject(CFDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new CGImageDestinationCopySourceOptions(o);
        }

        @MarshalsPointer
        public static long toNative(CGImageDestinationCopySourceOptions o, long flags) {
            if (o == null) {
                return 0L;
            }
            return CFType.Marshaler.toNative(o.data, flags);
        }
    }
}

