/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.mediaplayer;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSDictionaryWrapper;
import org.robovm.apple.foundation.NSMutableArray;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.mediaplayer.MPMediaEntityProperty;
import org.robovm.apple.mediaplayer.MPMediaItemArtwork;
import org.robovm.apple.mediaplayer.MPMediaItemProperty;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="MediaPlayer")
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
public class MPNowPlayingInfo
extends NSDictionaryWrapper {
    MPNowPlayingInfo(NSDictionary data) {
        super(data);
    }

    public MPNowPlayingInfo() {
    }

    public boolean has(NSString key) {
        return this.data.containsKey(key);
    }

    public NSObject get(NSString key) {
        if (this.has(key)) {
            return this.data.get(key);
        }
        return null;
    }

    public MPNowPlayingInfo set(NSString key, NSObject value) {
        this.data.put(key, value);
        return this;
    }

    public double getElapsedPlaybackTime() {
        if (this.has(Keys.ElapsedPlaybackTime())) {
            NSNumber val = (NSNumber)this.get(Keys.ElapsedPlaybackTime());
            return val.doubleValue();
        }
        return 0.0;
    }

    public MPNowPlayingInfo setElapsedPlaybackTime(double elapsedPlaybackTime) {
        this.set(Keys.ElapsedPlaybackTime(), (NSObject)NSNumber.valueOf(elapsedPlaybackTime));
        return this;
    }

    public double getPlaybackRate() {
        if (this.has(Keys.PlaybackRate())) {
            NSNumber val = (NSNumber)this.get(Keys.PlaybackRate());
            return val.doubleValue();
        }
        return 0.0;
    }

    public MPNowPlayingInfo setPlaybackRate(double playbackRate) {
        this.set(Keys.PlaybackRate(), (NSObject)NSNumber.valueOf(playbackRate));
        return this;
    }

    public double getDefaultPlaybackRate() {
        if (this.has(Keys.DefaultPlaybackRate())) {
            NSNumber val = (NSNumber)this.get(Keys.DefaultPlaybackRate());
            return val.doubleValue();
        }
        return 0.0;
    }

    public MPNowPlayingInfo setDefaultPlaybackRate(double defaultPlaybackRate) {
        this.set(Keys.DefaultPlaybackRate(), (NSObject)NSNumber.valueOf(defaultPlaybackRate));
        return this;
    }

    public int getPlaybackQueueIndex() {
        if (this.has(Keys.PlaybackQueueIndex())) {
            NSNumber val = (NSNumber)this.get(Keys.PlaybackQueueIndex());
            return val.intValue();
        }
        return 0;
    }

    public MPNowPlayingInfo setPlaybackQueueIndex(int playbackQueueIndex) {
        this.set(Keys.PlaybackQueueIndex(), (NSObject)NSNumber.valueOf(playbackQueueIndex));
        return this;
    }

    public int getPlaybackQueueCount() {
        if (this.has(Keys.PlaybackQueueCount())) {
            NSNumber val = (NSNumber)this.get(Keys.PlaybackQueueCount());
            return val.intValue();
        }
        return 0;
    }

    public MPNowPlayingInfo setPlaybackQueueCount(int playbackQueueCount) {
        this.set(Keys.PlaybackQueueCount(), (NSObject)NSNumber.valueOf(playbackQueueCount));
        return this;
    }

    public int getChapterNumber() {
        if (this.has(Keys.ChapterNumber())) {
            NSNumber val = (NSNumber)this.get(Keys.ChapterNumber());
            return val.intValue();
        }
        return 0;
    }

    public MPNowPlayingInfo setChapterNumber(int chapterNumber) {
        this.set(Keys.ChapterNumber(), (NSObject)NSNumber.valueOf(chapterNumber));
        return this;
    }

    public int getChapterCount() {
        if (this.has(Keys.ChapterCount())) {
            NSNumber val = (NSNumber)this.get(Keys.ChapterCount());
            return val.intValue();
        }
        return 0;
    }

    public MPNowPlayingInfo setChapterCount(int chapterCount) {
        this.set(Keys.ChapterCount(), (NSObject)NSNumber.valueOf(chapterCount));
        return this;
    }

    public boolean has(MPMediaEntityProperty key) {
        return this.data.containsKey(key.value());
    }

    public NSObject get(MPMediaEntityProperty key) {
        if (this.has(key)) {
            return this.data.get(key.value());
        }
        return null;
    }

    public MPNowPlayingInfo set(MPMediaEntityProperty key, NSObject value) {
        this.data.put((NSObject)key.value(), value);
        return this;
    }

    public long getPersistentID() {
        if (this.has(MPMediaItemProperty.ItemPersistentID)) {
            NSNumber val = (NSNumber)this.get(MPMediaItemProperty.ItemPersistentID);
            return val.longValue();
        }
        return 0L;
    }

    public MPNowPlayingInfo setPersistentID(long id) {
        this.set(MPMediaItemProperty.ItemPersistentID, (NSObject)NSNumber.valueOf(id));
        return this;
    }

    public String getTitle() {
        if (this.has(MPMediaItemProperty.Title)) {
            NSString val = (NSString)this.get(MPMediaItemProperty.Title);
            return val.toString();
        }
        return null;
    }

    public MPNowPlayingInfo setTitle(String title) {
        this.set(MPMediaItemProperty.Title, (NSObject)new NSString(title));
        return this;
    }

    public String getAlbumTitle() {
        if (this.has(MPMediaItemProperty.AlbumTitle)) {
            NSString val = (NSString)this.get(MPMediaItemProperty.AlbumTitle);
            return val.toString();
        }
        return null;
    }

    public MPNowPlayingInfo setAlbumTitle(String albumTitle) {
        this.set(MPMediaItemProperty.AlbumTitle, (NSObject)new NSString(albumTitle));
        return this;
    }

    public String getArtist() {
        if (this.has(MPMediaItemProperty.Artist)) {
            NSString val = (NSString)this.get(MPMediaItemProperty.Artist);
            return val.toString();
        }
        return null;
    }

    public MPNowPlayingInfo setArtist(String artist) {
        this.set(MPMediaItemProperty.Artist, (NSObject)new NSString(artist));
        return this;
    }

    public String getGenre() {
        if (this.has(MPMediaItemProperty.Genre)) {
            NSString val = (NSString)this.get(MPMediaItemProperty.Genre);
            return val.toString();
        }
        return null;
    }

    public MPNowPlayingInfo setGenre(String genre) {
        this.set(MPMediaItemProperty.Genre, (NSObject)new NSString(genre));
        return this;
    }

    public String getComposer() {
        if (this.has(MPMediaItemProperty.Composer)) {
            NSString val = (NSString)this.get(MPMediaItemProperty.Composer);
            return val.toString();
        }
        return null;
    }

    public MPNowPlayingInfo setComposer(String composer) {
        this.set(MPMediaItemProperty.Composer, (NSObject)new NSString(composer));
        return this;
    }

    public double getPlaybackDuration() {
        if (this.has(MPMediaItemProperty.PlaybackDuration)) {
            NSNumber val = (NSNumber)this.get(MPMediaItemProperty.PlaybackDuration);
            return val.doubleValue();
        }
        return 0.0;
    }

    public MPNowPlayingInfo setPlaybackDuration(double playbackDuration) {
        this.set(MPMediaItemProperty.PlaybackDuration, (NSObject)NSNumber.valueOf(playbackDuration));
        return this;
    }

    public int getAlbumTrackNumber() {
        if (this.has(MPMediaItemProperty.AlbumTrackNumber)) {
            NSNumber val = (NSNumber)this.get(MPMediaItemProperty.AlbumTrackNumber);
            return val.intValue();
        }
        return 0;
    }

    public MPNowPlayingInfo setAlbumTrackNumber(int albumTrackNumber) {
        this.set(MPMediaItemProperty.AlbumTrackNumber, (NSObject)NSNumber.valueOf(albumTrackNumber));
        return this;
    }

    public int getAlbumTrackCount() {
        if (this.has(MPMediaItemProperty.AlbumTrackCount)) {
            NSNumber val = (NSNumber)this.get(MPMediaItemProperty.AlbumTrackCount);
            return val.intValue();
        }
        return 0;
    }

    public MPNowPlayingInfo setAlbumTrackCount(int albumTrackCount) {
        this.set(MPMediaItemProperty.AlbumTrackCount, (NSObject)NSNumber.valueOf(albumTrackCount));
        return this;
    }

    public int getDiscNumber() {
        if (this.has(MPMediaItemProperty.DiscNumber)) {
            NSNumber val = (NSNumber)this.get(MPMediaItemProperty.DiscNumber);
            return val.intValue();
        }
        return 0;
    }

    public MPNowPlayingInfo setDiscNumber(int discNumber) {
        this.set(MPMediaItemProperty.DiscNumber, (NSObject)NSNumber.valueOf(discNumber));
        return this;
    }

    public int getDiscCount() {
        if (this.has(MPMediaItemProperty.DiscCount)) {
            NSNumber val = (NSNumber)this.get(MPMediaItemProperty.DiscCount);
            return val.intValue();
        }
        return 0;
    }

    public MPNowPlayingInfo setDiscCount(int discCount) {
        this.set(MPMediaItemProperty.DiscCount, (NSObject)NSNumber.valueOf(discCount));
        return this;
    }

    public MPMediaItemArtwork getArtwork() {
        if (this.has(MPMediaItemProperty.Artwork)) {
            MPMediaItemArtwork val = (MPMediaItemArtwork)this.get(MPMediaItemProperty.Artwork);
            return val;
        }
        return null;
    }

    public MPNowPlayingInfo setArtwork(MPMediaItemArtwork artwork) {
        this.set(MPMediaItemProperty.Artwork, (NSObject)artwork);
        return this;
    }

    @Library(value="MediaPlayer")
    public static class Keys {
        @GlobalValue(symbol="MPNowPlayingInfoPropertyElapsedPlaybackTime", optional=true)
        public static native NSString ElapsedPlaybackTime();

        @GlobalValue(symbol="MPNowPlayingInfoPropertyPlaybackRate", optional=true)
        public static native NSString PlaybackRate();

        @GlobalValue(symbol="MPNowPlayingInfoPropertyDefaultPlaybackRate", optional=true)
        public static native NSString DefaultPlaybackRate();

        @GlobalValue(symbol="MPNowPlayingInfoPropertyPlaybackQueueIndex", optional=true)
        public static native NSString PlaybackQueueIndex();

        @GlobalValue(symbol="MPNowPlayingInfoPropertyPlaybackQueueCount", optional=true)
        public static native NSString PlaybackQueueCount();

        @GlobalValue(symbol="MPNowPlayingInfoPropertyChapterNumber", optional=true)
        public static native NSString ChapterNumber();

        @GlobalValue(symbol="MPNowPlayingInfoPropertyChapterCount", optional=true)
        public static native NSString ChapterCount();

        @GlobalValue(symbol="MPNowPlayingInfoPropertyIsLiveStream", optional=true)
        public static native NSString IsLiveStream();

        @GlobalValue(symbol="MPNowPlayingInfoPropertyAvailableLanguageOptions", optional=true)
        public static native NSString AvailableLanguageOptions();

        @GlobalValue(symbol="MPNowPlayingInfoPropertyCurrentLanguageOptions", optional=true)
        public static native NSString CurrentLanguageOptions();

        @GlobalValue(symbol="MPNowPlayingInfoCollectionIdentifier", optional=true)
        public static native String CollectionIdentifier();

        @GlobalValue(symbol="MPNowPlayingInfoPropertyExternalContentIdentifier", optional=true)
        public static native NSString ExternalContentIdentifier();

        @GlobalValue(symbol="MPNowPlayingInfoPropertyExternalUserProfileIdentifier", optional=true)
        public static native NSString ExternalUserProfileIdentifier();

        @GlobalValue(symbol="MPNowPlayingInfoPropertyServiceIdentifier", optional=true)
        public static native NSString ServiceIdentifier();

        @GlobalValue(symbol="MPNowPlayingInfoPropertyPlaybackProgress", optional=true)
        public static native NSString PlaybackProgress();

        @GlobalValue(symbol="MPNowPlayingInfoPropertyMediaType", optional=true)
        public static native NSString MediaType();

        @GlobalValue(symbol="MPNowPlayingInfoPropertyAssetURL", optional=true)
        public static native NSString AssetURL();

        @GlobalValue(symbol="MPNowPlayingInfoPropertyCurrentPlaybackDate", optional=true)
        public static native NSString CurrentPlaybackDate();

        static {
            Bro.bind(Keys.class);
        }
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<MPNowPlayingInfo> toObject(Class<? extends NSObject> cls, long handle, long flags) {
            NSArray o = (NSArray)NSObject.Marshaler.toObject(NSArray.class, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<MPNowPlayingInfo> list = new ArrayList<MPNowPlayingInfo>();
            for (int i = 0; i < o.size(); ++i) {
                list.add(new MPNowPlayingInfo((NSDictionary)o.get(i)));
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<MPNowPlayingInfo> l, long flags) {
            if (l == null) {
                return 0L;
            }
            NSMutableArray<NSDictionary> array = new NSMutableArray<NSDictionary>();
            for (MPNowPlayingInfo i : l) {
                array.add(i.getDictionary());
            }
            return NSObject.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static MPNowPlayingInfo toObject(Class<MPNowPlayingInfo> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new MPNowPlayingInfo(o);
        }

        @MarshalsPointer
        public static long toNative(MPNowPlayingInfo o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

