/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.metalps;

import org.robovm.rt.bro.ValuedEnum;

public enum MPSDataType implements ValuedEnum
{
    Invalid(0L),
    FloatBit(0x10000000L),
    Float32(0x10000020L),
    Float16(0x10000010L),
    SignedBit(0x20000000L),
    IntBit(0x20000000L),
    Int8(0x20000008L),
    Int16(0x20000010L),
    Int32(0x20000020L),
    UInt8(8L),
    UInt16(16L),
    UInt32(32L),
    NormalizedBit(0x40000000L),
    Unorm1(0x40000001L),
    Unorm8(0x40000008L);

    private final long n;

    private MPSDataType(long n2) {
        this.n = n2;
    }

    public long value() {
        return this.n;
    }

    public static MPSDataType valueOf(long n) {
        for (MPSDataType v : MPSDataType.values()) {
            if (v.n != n) continue;
            return v;
        }
        throw new IllegalArgumentException("No constant with value " + n + " found in " + MPSDataType.class.getName());
    }
}

