/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.metalps;

import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.metal.MTLCommandBuffer;
import org.robovm.apple.metal.MTLDevice;
import org.robovm.apple.metal.MTLResource;
import org.robovm.apple.metal.MTLTextureDescriptor;
import org.robovm.apple.metalps.MPSImage;
import org.robovm.apple.metalps.MPSImageDescriptor;
import org.robovm.apple.metalps.MPSKernel;
import org.robovm.apple.metalps.MPSStateResourceList;
import org.robovm.apple.metalps.MPSStateResourceType;
import org.robovm.apple.metalps.MPSStateTextureInfo;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="MetalPerformanceShaders")
@NativeClass
public class MPSState
extends NSObject {
    protected MPSState() {
    }

    protected MPSState(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected MPSState(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Method(selector="initWithDevice:bufferSize:")
    public MPSState(MTLDevice device, @MachineSizedUInt long bufferSize) {
        super(null);
        this.initObject(this.init(device, bufferSize));
    }

    @Method(selector="initWithDevice:textureDescriptor:")
    public MPSState(MTLDevice device, MTLTextureDescriptor descriptor) {
        super(null);
        this.initObject(this.init(device, descriptor));
    }

    @Method(selector="initWithResource:")
    public MPSState(MTLResource resource) {
        super(null);
        this.initObject(this.init(resource));
    }

    @Method(selector="initWithDevice:resourceList:")
    public MPSState(MTLDevice device, MPSStateResourceList resourceList) {
        super(null);
        this.initObject(this.init(device, resourceList));
    }

    @Method(selector="initWithResources:")
    public MPSState(NSArray<?> resources) {
        super(null);
        this.initObject(this.init(resources));
    }

    public MPSState(MTLCommandBuffer cmdBuf, @MachineSizedUInt long bufferSize) {
        super(null, MPSState.create(cmdBuf, bufferSize));
        MPSState.retain(this.getHandle());
    }

    public MPSState(MTLCommandBuffer cmdBuf, MTLTextureDescriptor descriptor) {
        super(null, MPSState.create(cmdBuf, descriptor));
        MPSState.retain(this.getHandle());
    }

    public MPSState(MTLCommandBuffer cmdBuf) {
        super(null, MPSState.create(cmdBuf));
        MPSState.retain(this.getHandle());
    }

    public MPSState(MTLCommandBuffer commandBuffer, MPSStateResourceList resourceList) {
        super(null, MPSState.create(commandBuffer, resourceList));
        MPSState.retain(this.getHandle());
    }

    @Property(selector="resourceCount")
    @MachineSizedUInt
    public native long getResourceCount();

    @Property(selector="readCount")
    @MachineSizedUInt
    public native long getReadCount();

    @Property(selector="setReadCount:")
    public native void setReadCount(@MachineSizedUInt long var1);

    @Property(selector="isTemporary")
    public native boolean isTemporary();

    @Property(selector="label")
    public native String getLabel();

    @Property(selector="setLabel:")
    public native void setLabel(String var1);

    @Deprecated
    @Property(selector="resource")
    public native MTLResource getResource();

    @Method(selector="initWithDevice:bufferSize:")
    @Pointer
    protected native long init(MTLDevice var1, @MachineSizedUInt long var2);

    @Method(selector="initWithDevice:textureDescriptor:")
    @Pointer
    protected native long init(MTLDevice var1, MTLTextureDescriptor var2);

    @Method(selector="initWithResource:")
    @Pointer
    protected native long init(MTLResource var1);

    @Method(selector="initWithDevice:resourceList:")
    @Pointer
    protected native long init(MTLDevice var1, MPSStateResourceList var2);

    @Method(selector="initWithResources:")
    @Pointer
    protected native long init(NSArray<?> var1);

    @Method(selector="resourceAtIndex:allocateMemory:")
    public native MTLResource getResource(@MachineSizedUInt long var1, boolean var3);

    @Method(selector="bufferSizeAtIndex:")
    @MachineSizedUInt
    public native long bufferSizeAtIndex(@MachineSizedUInt long var1);

    @Method(selector="textureInfoAtIndex:")
    @ByVal
    public native MPSStateTextureInfo textureInfoAtIndex(@MachineSizedUInt long var1);

    @Method(selector="resourceTypeAtIndex:")
    public native MPSStateResourceType resourceTypeAtIndex(@MachineSizedUInt long var1);

    @Method(selector="synchronizeOnCommandBuffer:")
    public native void synchronizeOnCommandBuffer(MTLCommandBuffer var1);

    @Method(selector="resourceSize")
    @MachineSizedUInt
    public native long resourceSize();

    @Method(selector="destinationImageDescriptorForSourceImages:sourceStates:forKernel:suggestedDescriptor:")
    public native MPSImageDescriptor getDestinationImageDescriptor(NSArray<MPSImage> var1, NSArray<MPSState> var2, MPSKernel var3, MPSImageDescriptor var4);

    @Method(selector="temporaryStateWithCommandBuffer:bufferSize:")
    @Pointer
    protected static native long create(MTLCommandBuffer var0, @MachineSizedUInt long var1);

    @Method(selector="temporaryStateWithCommandBuffer:textureDescriptor:")
    @Pointer
    protected static native long create(MTLCommandBuffer var0, MTLTextureDescriptor var1);

    @Method(selector="temporaryStateWithCommandBuffer:")
    @Pointer
    protected static native long create(MTLCommandBuffer var0);

    @Method(selector="temporaryStateWithCommandBuffer:resourceList:")
    @Pointer
    protected static native long create(MTLCommandBuffer var0, MPSStateResourceList var1);

    static {
        ObjCRuntime.bind(MPSState.class);
    }

    public static class MPSStatePtr
    extends Ptr<MPSState, MPSStatePtr> {
    }
}

