/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.security;

import org.robovm.apple.corefoundation.CFAllocator;
import org.robovm.apple.corefoundation.CFArray;
import org.robovm.apple.corefoundation.CFMutableArray;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.corefoundation.OSStatus;
import org.robovm.apple.corefoundation.OSStatusException;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSData;
import org.robovm.apple.security.SSLAuthenticate;
import org.robovm.apple.security.SSLClientCertificateState;
import org.robovm.apple.security.SSLConnectionType;
import org.robovm.apple.security.SSLProtocol;
import org.robovm.apple.security.SSLProtocolSide;
import org.robovm.apple.security.SSLSessionOption;
import org.robovm.apple.security.SSLSessionState;
import org.robovm.apple.security.SecCertificate;
import org.robovm.apple.security.SecIdentity;
import org.robovm.apple.security.SecTrust;
import org.robovm.rt.VM;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.Struct;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.BooleanPtr;
import org.robovm.rt.bro.ptr.BytePtr;
import org.robovm.rt.bro.ptr.FunctionPtr;
import org.robovm.rt.bro.ptr.IntPtr;
import org.robovm.rt.bro.ptr.MachineSizedUIntPtr;
import org.robovm.rt.bro.ptr.Ptr;
import org.robovm.rt.bro.ptr.ShortPtr;
import org.robovm.rt.bro.ptr.VoidPtr;

@Library(value="Security")
public class SSLContext
extends CFType {
    protected SSLContext() {
    }

    public static SSLContext create(SSLProtocolSide protocolSide, SSLConnectionType connectionType) {
        return SSLContext.create0(null, protocolSide, connectionType);
    }

    public SSLSessionState getSessionState() throws OSStatusException {
        IntPtr ptr = new IntPtr();
        OSStatus status = this.getSessionState0(ptr);
        OSStatusException.throwIfNecessary(status);
        return SSLSessionState.valueOf(ptr.get());
    }

    public void setSessionOption(SSLSessionOption option, boolean value) throws OSStatusException {
        OSStatus status = this.setSessionOption0(option, value);
        OSStatusException.throwIfNecessary(status);
    }

    public boolean getSessionOption(SSLSessionOption option) throws OSStatusException {
        BooleanPtr ptr = new BooleanPtr();
        OSStatus status = this.getSessionOption0(option, ptr);
        OSStatusException.throwIfNecessary(status);
        return ptr.get();
    }

    public void setMinProtocolVersion(SSLProtocol minVersion) throws OSStatusException {
        OSStatus status = this.setMinProtocolVersion0(minVersion);
        OSStatusException.throwIfNecessary(status);
    }

    public SSLProtocol getMinProtocolVersion() throws OSStatusException {
        IntPtr ptr = new IntPtr();
        OSStatus status = this.getMinProtocolVersion0(ptr);
        OSStatusException.throwIfNecessary(status);
        return SSLProtocol.valueOf(ptr.get());
    }

    public void setMaxProtocolVersion(SSLProtocol maxVersion) throws OSStatusException {
        OSStatus status = this.setMaxProtocolVersion0(maxVersion);
        OSStatusException.throwIfNecessary(status);
    }

    public SSLProtocol getMaxProtocolVersion() throws OSStatusException {
        IntPtr ptr = new IntPtr();
        OSStatus status = this.getMaxProtocolVersion0(ptr);
        OSStatusException.throwIfNecessary(status);
        return SSLProtocol.valueOf(ptr.get());
    }

    public void setCertificate(SecIdentity identity, SecCertificate ... certificates) throws OSStatusException {
        CFMutableArray arr = CFMutableArray.create();
        ((CFArray)arr).add(identity);
        for (SecCertificate certificate : certificates) {
            ((CFArray)arr).add(certificate);
        }
        OSStatus status = this.setCertificate0(arr);
        OSStatusException.throwIfNecessary(status);
    }

    public void setEncryptionCertificate(SecIdentity identity, SecCertificate ... certificates) throws OSStatusException {
        CFMutableArray arr = CFMutableArray.create();
        ((CFArray)arr).add(identity);
        for (SecCertificate certificate : certificates) {
            ((CFArray)arr).add(certificate);
        }
        OSStatus status = this.setEncryptionCertificate0(arr);
        OSStatusException.throwIfNecessary(status);
    }

    public void setConnection(VoidPtr connection) throws OSStatusException {
        OSStatus status = this.setConnection0(connection);
        OSStatusException.throwIfNecessary(status);
    }

    public VoidPtr getConnection() throws OSStatusException {
        VoidPtr.VoidPtrPtr ptr = new VoidPtr.VoidPtrPtr();
        OSStatus status = this.getConnection0(ptr);
        OSStatusException.throwIfNecessary(status);
        return (VoidPtr)ptr.get();
    }

    public void setPeerDomainName(String peerName) throws OSStatusException {
        byte[] bytes = peerName.getBytes();
        int length = bytes.length;
        long handle = VM.malloc((int)(length + 1));
        VM.memcpy((long)handle, (long)VM.getArrayValuesAddress((Object)bytes), (long)length);
        OSStatus status = this.setPeerDomainName0(handle, length);
        OSStatusException.throwIfNecessary(status);
    }

    public String getPeerDomainName() throws OSStatusException {
        BytePtr peerNamePtr = new BytePtr();
        MachineSizedUIntPtr peerNameLenPtr = new MachineSizedUIntPtr();
        OSStatus status = this.getPeerDomainName0(peerNamePtr, peerNameLenPtr);
        OSStatusException.throwIfNecessary(status);
        return peerNamePtr.toStringZ();
    }

    public void setDatagramHelloCookie(byte[] cookie) throws OSStatusException {
        OSStatus status = this.setDatagramHelloCookie0(VM.getArrayValuesAddress((Object)cookie), cookie.length);
        OSStatusException.throwIfNecessary(status);
    }

    public void setMaxDatagramRecordSize(long maxSize) throws OSStatusException {
        OSStatus status = this.setMaxDatagramRecordSize0(maxSize);
        OSStatusException.throwIfNecessary(status);
    }

    public long getMaxDatagramRecordSize() throws OSStatusException {
        MachineSizedUIntPtr ptr = new MachineSizedUIntPtr();
        OSStatus status = this.getMaxDatagramRecordSize0(ptr);
        OSStatusException.throwIfNecessary(status);
        return ptr.get();
    }

    public SSLProtocol getNegotiatedProtocolVersion() throws OSStatusException {
        IntPtr ptr = new IntPtr();
        OSStatus status = this.getNegotiatedProtocolVersion0(ptr);
        OSStatusException.throwIfNecessary(status);
        return SSLProtocol.valueOf(ptr.get());
    }

    public long getNumberSupportedCiphers() throws OSStatusException {
        MachineSizedUIntPtr ptr = new MachineSizedUIntPtr();
        OSStatus status = this.getNumberSupportedCiphers0(ptr);
        OSStatusException.throwIfNecessary(status);
        return ptr.get();
    }

    public short[] getSupportedCiphers() throws OSStatusException {
        ShortPtr ciphersPtr = new ShortPtr();
        MachineSizedUIntPtr numCiphersPtr = new MachineSizedUIntPtr();
        OSStatus status = this.getSupportedCiphers0(ciphersPtr, numCiphersPtr);
        OSStatusException.throwIfNecessary(status);
        return ciphersPtr.toShortArray((int)numCiphersPtr.get());
    }

    public void setEnabledCiphers(short[] ciphers) throws OSStatusException {
        OSStatus status = this.setEnabledCiphers0(VM.getArrayValuesAddress((Object)ciphers), ciphers.length);
        OSStatusException.throwIfNecessary(status);
    }

    public long getNumberEnabledCiphers() throws OSStatusException {
        MachineSizedUIntPtr ptr = new MachineSizedUIntPtr();
        OSStatus status = this.getNumberEnabledCiphers0(ptr);
        OSStatusException.throwIfNecessary(status);
        return ptr.get();
    }

    public short[] getEnabledCiphers() throws OSStatusException {
        ShortPtr ciphersPtr = new ShortPtr();
        MachineSizedUIntPtr numCiphersPtr = new MachineSizedUIntPtr();
        OSStatus status = this.getEnabledCiphers0(ciphersPtr, numCiphersPtr);
        OSStatusException.throwIfNecessary(status);
        return ciphersPtr.toShortArray((int)numCiphersPtr.get());
    }

    public SecTrust getPeerTrust() throws OSStatusException {
        SecTrust.SecTrustPtr ptr = new SecTrust.SecTrustPtr();
        OSStatus status = this.getPeerTrust0(ptr);
        OSStatusException.throwIfNecessary(status);
        return (SecTrust)ptr.get();
    }

    public void setPeerID(String peerID) throws OSStatusException {
        byte[] bytes = peerID.getBytes();
        int length = bytes.length;
        long handle = VM.malloc((int)(length + 1));
        VM.memcpy((long)handle, (long)VM.getArrayValuesAddress((Object)bytes), (long)length);
        OSStatus status = this.setPeerID0(handle, length);
        OSStatusException.throwIfNecessary(status);
    }

    public String getPeerID() throws OSStatusException {
        BytePtr.BytePtrPtr peerIDPtr = new BytePtr.BytePtrPtr();
        MachineSizedUIntPtr peerIDLenPtr = new MachineSizedUIntPtr();
        OSStatus status = this.getPeerID0(peerIDPtr, peerIDLenPtr);
        OSStatusException.throwIfNecessary(status);
        return ((BytePtr)peerIDPtr.get()).toStringZ();
    }

    public short getNegotiatedCipher() throws OSStatusException {
        ShortPtr ptr = new ShortPtr();
        OSStatus status = this.getNegotiatedCipher0(ptr);
        OSStatusException.throwIfNecessary(status);
        return ptr.get();
    }

    public void setClientSideAuthenticate(SSLAuthenticate auth) throws OSStatusException {
        OSStatus status = this.setClientSideAuthenticate0(auth);
        OSStatusException.throwIfNecessary(status);
    }

    public void addDistinguishedName(NSData derDN) throws OSStatusException {
        if (derDN == null) {
            throw new NullPointerException("derDN");
        }
        OSStatus status = this.addDistinguishedName0(VM.getArrayValuesAddress((Object)derDN.getBytes()), derDN.getLength());
        OSStatusException.throwIfNecessary(status);
    }

    public NSArray<NSData> getDistinguishedNames() throws OSStatusException {
        NSArray.NSArrayPtr<NSData> ptr = new NSArray.NSArrayPtr<NSData>();
        OSStatus status = this.getDistinguishedNames0(ptr);
        OSStatusException.throwIfNecessary(status);
        return (NSArray)ptr.get();
    }

    public SSLClientCertificateState getClientCertificateState() throws OSStatusException {
        IntPtr ptr = new IntPtr();
        OSStatus status = this.getClientCertificateState0(ptr);
        OSStatusException.throwIfNecessary(status);
        return SSLClientCertificateState.valueOf(ptr.get());
    }

    public void handshake() throws OSStatusException {
        OSStatus status = this.handshake0();
        OSStatusException.throwIfNecessary(status);
    }

    public long write(byte[] data) throws OSStatusException {
        MachineSizedUIntPtr ptr = new MachineSizedUIntPtr();
        OSStatus status = this.write0(VM.getArrayValuesAddress((Object)data), data.length, ptr);
        OSStatusException.throwIfNecessary(status);
        return ptr.get();
    }

    public byte[] read(int dataLength) throws OSStatusException {
        BytePtr dataPtr = (BytePtr)Struct.allocate(BytePtr.class, (int)dataLength);
        MachineSizedUIntPtr processedPtr = new MachineSizedUIntPtr();
        OSStatus status = this.read0(dataPtr, dataLength, processedPtr);
        OSStatusException.throwIfNecessary(status);
        return dataPtr.toByteArray((int)processedPtr.get());
    }

    public int getBufferedReadSize() throws OSStatusException {
        MachineSizedUIntPtr ptr = new MachineSizedUIntPtr();
        OSStatus status = this.getBufferedReadSize0(ptr);
        OSStatusException.throwIfNecessary(status);
        return (int)ptr.get();
    }

    public int getDatagramWriteSize() throws OSStatusException {
        MachineSizedUIntPtr ptr = new MachineSizedUIntPtr();
        OSStatus status = this.getDatagramWriteSize0(ptr);
        OSStatusException.throwIfNecessary(status);
        return (int)ptr.get();
    }

    public void closeContext() throws OSStatusException {
        OSStatus status = this.closeContext0();
        OSStatusException.throwIfNecessary(status);
    }

    @Deprecated
    @GlobalValue(symbol="kSSLSessionConfig_default", optional=true)
    public static native String kSSLSessionConfig_default();

    @Deprecated
    @GlobalValue(symbol="kSSLSessionConfig_ATSv1", optional=true)
    public static native String kSSLSessionConfig_ATSv1();

    @Deprecated
    @GlobalValue(symbol="kSSLSessionConfig_ATSv1_noPFS", optional=true)
    public static native String kSSLSessionConfig_ATSv1_noPFS();

    @Deprecated
    @GlobalValue(symbol="kSSLSessionConfig_standard", optional=true)
    public static native String kSSLSessionConfig_standard();

    @Deprecated
    @GlobalValue(symbol="kSSLSessionConfig_RC4_fallback", optional=true)
    public static native String kSSLSessionConfig_RC4_fallback();

    @Deprecated
    @GlobalValue(symbol="kSSLSessionConfig_TLSv1_fallback", optional=true)
    public static native String kSSLSessionConfig_TLSv1_fallback();

    @Deprecated
    @GlobalValue(symbol="kSSLSessionConfig_TLSv1_RC4_fallback", optional=true)
    public static native String kSSLSessionConfig_TLSv1_RC4_fallback();

    @Deprecated
    @GlobalValue(symbol="kSSLSessionConfig_legacy", optional=true)
    public static native String kSSLSessionConfig_legacy();

    @Deprecated
    @GlobalValue(symbol="kSSLSessionConfig_legacy_DHE", optional=true)
    public static native String kSSLSessionConfig_legacy_DHE();

    @Deprecated
    @GlobalValue(symbol="kSSLSessionConfig_anonymous", optional=true)
    public static native String kSSLSessionConfig_anonymous();

    @Deprecated
    @GlobalValue(symbol="kSSLSessionConfig_3DES_fallback", optional=true)
    public static native String kSSLSessionConfig_3DES_fallback();

    @Deprecated
    @GlobalValue(symbol="kSSLSessionConfig_TLSv1_3DES_fallback", optional=true)
    public static native String kSSLSessionConfig_TLSv1_3DES_fallback();

    @Deprecated
    @Bridge(symbol="SSLContextGetTypeID", optional=true)
    @MachineSizedUInt
    public static native long getClassTypeID();

    @Deprecated
    @Bridge(symbol="SSLCreateContext", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    protected static native SSLContext create0(CFAllocator var0, SSLProtocolSide var1, SSLConnectionType var2);

    @Deprecated
    @Bridge(symbol="SSLGetSessionState", optional=true)
    protected native OSStatus getSessionState0(IntPtr var1);

    @Deprecated
    @Bridge(symbol="SSLSetSessionOption", optional=true)
    protected native OSStatus setSessionOption0(SSLSessionOption var1, boolean var2);

    @Deprecated
    @Bridge(symbol="SSLGetSessionOption", optional=true)
    protected native OSStatus getSessionOption0(SSLSessionOption var1, BooleanPtr var2);

    @Deprecated
    @Bridge(symbol="SSLSetIOFuncs", optional=true)
    protected native OSStatus setIOFunctions0(FunctionPtr var1, FunctionPtr var2);

    @Deprecated
    @Bridge(symbol="SSLSetSessionConfig", optional=true)
    protected native OSStatus setSessionConfig0(String var1);

    @Deprecated
    @Bridge(symbol="SSLSetProtocolVersionMin", optional=true)
    protected native OSStatus setMinProtocolVersion0(SSLProtocol var1);

    @Deprecated
    @Bridge(symbol="SSLGetProtocolVersionMin", optional=true)
    protected native OSStatus getMinProtocolVersion0(IntPtr var1);

    @Deprecated
    @Bridge(symbol="SSLSetProtocolVersionMax", optional=true)
    protected native OSStatus setMaxProtocolVersion0(SSLProtocol var1);

    @Deprecated
    @Bridge(symbol="SSLGetProtocolVersionMax", optional=true)
    protected native OSStatus getMaxProtocolVersion0(IntPtr var1);

    @Deprecated
    @Bridge(symbol="SSLSetCertificate", optional=true)
    protected native OSStatus setCertificate0(CFArray var1);

    @Deprecated
    @Bridge(symbol="SSLSetConnection", optional=true)
    protected native OSStatus setConnection0(VoidPtr var1);

    @Deprecated
    @Bridge(symbol="SSLGetConnection", optional=true)
    protected native OSStatus getConnection0(VoidPtr.VoidPtrPtr var1);

    @Deprecated
    @Bridge(symbol="SSLSetPeerDomainName", optional=true)
    protected native OSStatus setPeerDomainName0(@Pointer long var1, @MachineSizedUInt long var3);

    @Deprecated
    @Bridge(symbol="SSLGetPeerDomainNameLength", optional=true)
    protected native OSStatus getPeerDomainNameLength0(MachineSizedUIntPtr var1);

    @Deprecated
    @Bridge(symbol="SSLGetPeerDomainName", optional=true)
    protected native OSStatus getPeerDomainName0(BytePtr var1, MachineSizedUIntPtr var2);

    @Deprecated
    @Bridge(symbol="SSLCopyRequestedPeerNameLength", optional=true)
    protected native OSStatus copyRequestedPeerNameLength0(MachineSizedUIntPtr var1);

    @Deprecated
    @Bridge(symbol="SSLCopyRequestedPeerName", optional=true)
    protected native OSStatus copyRequestedPeerName0(BytePtr var1, MachineSizedUIntPtr var2);

    @Deprecated
    @Bridge(symbol="SSLSetDatagramHelloCookie", optional=true)
    protected native OSStatus setDatagramHelloCookie0(@Pointer long var1, @MachineSizedUInt long var3);

    @Deprecated
    @Bridge(symbol="SSLSetMaxDatagramRecordSize", optional=true)
    protected native OSStatus setMaxDatagramRecordSize0(@MachineSizedUInt long var1);

    @Deprecated
    @Bridge(symbol="SSLGetMaxDatagramRecordSize", optional=true)
    protected native OSStatus getMaxDatagramRecordSize0(MachineSizedUIntPtr var1);

    @Deprecated
    @Bridge(symbol="SSLGetNegotiatedProtocolVersion", optional=true)
    protected native OSStatus getNegotiatedProtocolVersion0(IntPtr var1);

    @Deprecated
    @Bridge(symbol="SSLGetNumberSupportedCiphers", optional=true)
    protected native OSStatus getNumberSupportedCiphers0(MachineSizedUIntPtr var1);

    @Deprecated
    @Bridge(symbol="SSLGetSupportedCiphers", optional=true)
    protected native OSStatus getSupportedCiphers0(ShortPtr var1, MachineSizedUIntPtr var2);

    @Deprecated
    @Bridge(symbol="SSLGetNumberEnabledCiphers", optional=true)
    protected native OSStatus getNumberEnabledCiphers0(MachineSizedUIntPtr var1);

    @Deprecated
    @Bridge(symbol="SSLSetEnabledCiphers", optional=true)
    protected native OSStatus setEnabledCiphers0(@Pointer long var1, @MachineSizedUInt long var3);

    @Deprecated
    @Bridge(symbol="SSLGetEnabledCiphers", optional=true)
    protected native OSStatus getEnabledCiphers0(ShortPtr var1, MachineSizedUIntPtr var2);

    @Deprecated
    @Bridge(symbol="SSLSetSessionTicketsEnabled", optional=true)
    protected native OSStatus setSessionTicketsEnabled0(boolean var1);

    @Deprecated
    @Bridge(symbol="SSLCopyPeerTrust", optional=true)
    protected native OSStatus getPeerTrust0(SecTrust.SecTrustPtr var1);

    @Deprecated
    @Bridge(symbol="SSLSetPeerID", optional=true)
    protected native OSStatus setPeerID0(@Pointer long var1, @MachineSizedUInt long var3);

    @Deprecated
    @Bridge(symbol="SSLGetPeerID", optional=true)
    protected native OSStatus getPeerID0(BytePtr.BytePtrPtr var1, MachineSizedUIntPtr var2);

    @Deprecated
    @Bridge(symbol="SSLGetNegotiatedCipher", optional=true)
    protected native OSStatus getNegotiatedCipher0(ShortPtr var1);

    @Deprecated
    @Bridge(symbol="SSLSetALPNProtocols", optional=true)
    protected native OSStatus setALPNProtocols0(NSArray<?> var1);

    @Deprecated
    @Bridge(symbol="SSLCopyALPNProtocols", optional=true)
    protected native OSStatus getALPNProtocols0(NSArray.NSArrayPtr<NSData> var1);

    @Deprecated
    @Bridge(symbol="SSLSetOCSPResponse", optional=true)
    protected native OSStatus setOCSPResponse0(NSData var1);

    @Deprecated
    @Bridge(symbol="SSLSetEncryptionCertificate", optional=true)
    protected native OSStatus setEncryptionCertificate0(CFArray var1);

    @Deprecated
    @Bridge(symbol="SSLSetClientSideAuthenticate", optional=true)
    protected native OSStatus setClientSideAuthenticate0(SSLAuthenticate var1);

    @Deprecated
    @Bridge(symbol="SSLAddDistinguishedName", optional=true)
    protected native OSStatus addDistinguishedName0(@Pointer long var1, @MachineSizedUInt long var3);

    @Deprecated
    @Bridge(symbol="SSLCopyDistinguishedNames", optional=true)
    protected native OSStatus getDistinguishedNames0(NSArray.NSArrayPtr<NSData> var1);

    @Deprecated
    @Bridge(symbol="SSLGetClientCertificateState", optional=true)
    protected native OSStatus getClientCertificateState0(IntPtr var1);

    @Deprecated
    @Bridge(symbol="SSLHandshake", optional=true)
    protected native OSStatus handshake0();

    @Deprecated
    @Bridge(symbol="SSLReHandshake", optional=true)
    protected native OSStatus reHandshake0();

    @Deprecated
    @Bridge(symbol="SSLWrite", optional=true)
    protected native OSStatus write0(@Pointer long var1, @MachineSizedUInt long var3, MachineSizedUIntPtr var5);

    @Deprecated
    @Bridge(symbol="SSLRead", optional=true)
    protected native OSStatus read0(BytePtr var1, @MachineSizedUInt long var2, MachineSizedUIntPtr var4);

    @Deprecated
    @Bridge(symbol="SSLGetBufferedReadSize", optional=true)
    protected native OSStatus getBufferedReadSize0(MachineSizedUIntPtr var1);

    @Deprecated
    @Bridge(symbol="SSLGetDatagramWriteSize", optional=true)
    protected native OSStatus getDatagramWriteSize0(MachineSizedUIntPtr var1);

    @Deprecated
    @Bridge(symbol="SSLClose", optional=true)
    protected native OSStatus closeContext0();

    @Deprecated
    @Bridge(symbol="SSLSetError", optional=true)
    protected native OSStatus setError0(OSStatus var1);

    static {
        Bro.bind(SSLContext.class);
    }

    public static class SSLContextPtr
    extends Ptr<SSLContext, SSLContextPtr> {
    }
}

