/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.security;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.corefoundation.CFArray;
import org.robovm.apple.corefoundation.CFDictionary;
import org.robovm.apple.corefoundation.CFDictionaryWrapper;
import org.robovm.apple.corefoundation.CFMutableArray;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.foundation.NSData;
import org.robovm.apple.security.SecCertificate;
import org.robovm.apple.security.SecIdentity;
import org.robovm.apple.security.SecTrust;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="Security")
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
public class SecImportItem
extends CFDictionaryWrapper {
    SecImportItem(CFDictionary data) {
        super(data);
    }

    public boolean has(CFString key) {
        return this.data.containsKey(key);
    }

    public <T extends NativeObject> T get(CFString key, Class<T> type) {
        if (this.has(key)) {
            return this.data.get(key, type);
        }
        return null;
    }

    public String getLabel() {
        if (this.has(Keys.Label())) {
            CFString val = this.get(Keys.Label(), CFString.class);
            return val.toString();
        }
        return null;
    }

    public NSData getKeyID() {
        if (this.has(Keys.KeyID())) {
            NSData val = this.get(Keys.KeyID(), NSData.class);
            return val;
        }
        return null;
    }

    public SecTrust getTrust() {
        if (this.has(Keys.Trust())) {
            SecTrust val = this.get(Keys.Trust(), SecTrust.class);
            return val;
        }
        return null;
    }

    public List<SecCertificate> getCertChain() {
        if (this.has(Keys.CertChain())) {
            CFArray val = this.get(Keys.CertChain(), CFArray.class);
            return val.toList(SecCertificate.class);
        }
        return null;
    }

    public SecIdentity getIdentity() {
        if (this.has(Keys.Identity())) {
            SecIdentity val = this.get(Keys.Identity(), SecIdentity.class);
            return val;
        }
        return null;
    }

    @Library(value="Security")
    public static class Keys {
        @GlobalValue(symbol="kSecImportItemLabel", optional=true)
        public static native CFString Label();

        @GlobalValue(symbol="kSecImportItemKeyID", optional=true)
        public static native CFString KeyID();

        @GlobalValue(symbol="kSecImportItemTrust", optional=true)
        public static native CFString Trust();

        @GlobalValue(symbol="kSecImportItemCertChain", optional=true)
        public static native CFString CertChain();

        @GlobalValue(symbol="kSecImportItemIdentity", optional=true)
        public static native CFString Identity();

        static {
            Bro.bind(Keys.class);
        }
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<SecImportItem> toObject(Class<? extends CFType> cls, long handle, long flags) {
            CFArray o = (CFArray)CFType.Marshaler.toObject(CFArray.class, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<SecImportItem> list = new ArrayList<SecImportItem>();
            int i = 0;
            while ((long)i < o.size()) {
                list.add(new SecImportItem(o.get(i, CFDictionary.class)));
                ++i;
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<SecImportItem> l, long flags) {
            if (l == null) {
                return 0L;
            }
            CFMutableArray array = CFMutableArray.create();
            for (SecImportItem i : l) {
                ((CFArray)array).add(i.getDictionary());
            }
            return CFType.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static SecImportItem toObject(Class<SecImportItem> cls, long handle, long flags) {
            CFDictionary o = (CFDictionary)CFType.Marshaler.toObject(CFDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new SecImportItem(o);
        }

        @MarshalsPointer
        public static long toNative(SecImportItem o, long flags) {
            if (o == null) {
                return 0L;
            }
            return CFType.Marshaler.toNative(o.data, flags);
        }
    }
}

