/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.systemconfiguration;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.robovm.rt.bro.Struct;
import org.robovm.rt.bro.annotation.Array;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.StructMember;
import org.robovm.rt.bro.ptr.Ptr;

class sockaddr_in6
extends Struct<sockaddr_in6> {
    private static final byte AF_INET6 = 30;

    public sockaddr_in6() {
        this.sin6_len((byte)sockaddr_in6.sizeOf());
        this.sin6_family((byte)30);
    }

    public sockaddr_in6(InetSocketAddress address) {
        this();
        this.sin6_port((short)address.getPort());
        InetAddress addr = address.getAddress();
        if (!(addr instanceof Inet6Address)) {
            throw new IllegalArgumentException("address must be a valid IPv6 address!");
        }
        this.sin6_addr(addr.getAddress());
        this.sin6_scope_id(((Inet6Address)addr).getScopeId());
    }

    @StructMember(value=0)
    public native byte sin6_len();

    @StructMember(value=0)
    public native sockaddr_in6 sin6_len(byte var1);

    @StructMember(value=1)
    public native byte sin6_family();

    @StructMember(value=1)
    public native sockaddr_in6 sin6_family(byte var1);

    @StructMember(value=2)
    public native short sin6_port();

    @StructMember(value=2)
    public native sockaddr_in6 sin6_port(short var1);

    @StructMember(value=3)
    @MachineSizedUInt
    public native long sin6_flowinfo();

    @StructMember(value=3)
    public native sockaddr_in6 sin6_flowinfo(@MachineSizedUInt long var1);

    @StructMember(value=4)
    @Array(value={16})
    public native byte[] sin6_addr();

    @StructMember(value=4)
    public native sockaddr_in6 sin6_addr(@Array(value={16}) byte[] var1);

    @StructMember(value=5)
    @MachineSizedUInt
    public native long sin6_scope_id();

    @StructMember(value=5)
    public native sockaddr_in6 sin6_scope_id(@MachineSizedUInt long var1);

    public InetSocketAddress toInetSocketAddress() {
        try {
            Inet6Address address = Inet6Address.getByAddress(null, this.sin6_addr(), (int)this.sin6_scope_id());
            return new InetSocketAddress(address, (int)this.sin6_port());
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static class sockaddr_in6Ptr
    extends Ptr<sockaddr_in6, sockaddr_in6Ptr> {
    }
}

