/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.uikit;

import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.uikit.UITraitCollection;
import org.robovm.objc.ObjCClass;
import org.robovm.objc.ObjCObject;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.Selector;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.annotation.Variadic;

@Library(value="UIKit")
public class UIAppearance {
    private static final Selector appearance;
    private static final Selector appearanceWhenContainedIn;
    private static final Selector appearanceForTraitCollection;
    private static final Selector appearanceForTraitCollectionWhenContainedIn;

    @Bridge
    @Pointer
    private static native long objc_appearance(ObjCClass var0, Selector var1);

    @Bridge
    @Variadic(value=2)
    @Pointer
    private static native long objc_appearanceWhenContainedIn(ObjCClass var0, Selector var1, ObjCClass var2, ObjCClass var3, ObjCClass var4, ObjCClass var5, ObjCClass var6, ObjCClass var7, ObjCClass var8, ObjCClass var9, ObjCClass var10, ObjCClass var11, @Pointer long var12);

    @Bridge
    @Pointer
    private static native long objc_appearanceForTraitCollection(ObjCClass var0, Selector var1, UITraitCollection var2);

    @Bridge
    @Variadic(value=3)
    @Pointer
    private static native long objc_appearanceForTraitCollectionWhenContainedIn(ObjCClass var0, Selector var1, UITraitCollection var2, ObjCClass var3, ObjCClass var4, ObjCClass var5, ObjCClass var6, ObjCClass var7, ObjCClass var8, ObjCClass var9, ObjCClass var10, ObjCClass var11, ObjCClass var12, @Pointer long var13);

    private static ObjCClass toObjCClass(Class<?>[] array, int index) {
        return array.length > index ? ObjCClass.getByType(array[index]) : null;
    }

    public static <T extends NSObject> T getAppearance(Class<T> type, Class<?> ... containedIn) {
        ObjCClass objCClass = ObjCClass.getByType(type);
        long proxyHandle = 0L;
        if (containedIn == null || containedIn.length == 0) {
            proxyHandle = UIAppearance.objc_appearance(objCClass, appearance);
        } else {
            if (containedIn.length > 10) {
                throw new IllegalArgumentException("A maximum of 10 container classes is supported");
            }
            ObjCClass c01 = UIAppearance.toObjCClass(containedIn, 0);
            ObjCClass c02 = UIAppearance.toObjCClass(containedIn, 1);
            ObjCClass c03 = UIAppearance.toObjCClass(containedIn, 2);
            ObjCClass c04 = UIAppearance.toObjCClass(containedIn, 3);
            ObjCClass c05 = UIAppearance.toObjCClass(containedIn, 4);
            ObjCClass c06 = UIAppearance.toObjCClass(containedIn, 5);
            ObjCClass c07 = UIAppearance.toObjCClass(containedIn, 6);
            ObjCClass c08 = UIAppearance.toObjCClass(containedIn, 7);
            ObjCClass c09 = UIAppearance.toObjCClass(containedIn, 8);
            ObjCClass c10 = UIAppearance.toObjCClass(containedIn, 9);
            proxyHandle = UIAppearance.objc_appearanceWhenContainedIn(objCClass, appearanceWhenContainedIn, c01, c02, c03, c04, c05, c06, c07, c08, c09, c10, 0L);
        }
        return (T)((NSObject)ObjCObject.toObjCObject(type, (long)proxyHandle, (int)0, (boolean)true));
    }

    public static <T extends NSObject> T getAppearanceForTraitCollection(Class<T> type, UITraitCollection trait, Class<?> ... containedIn) {
        ObjCClass objCClass = ObjCClass.getByType(type);
        long proxyHandle = 0L;
        if (containedIn == null || containedIn.length == 0) {
            proxyHandle = UIAppearance.objc_appearanceForTraitCollection(objCClass, appearanceForTraitCollection, trait);
        } else {
            if (containedIn.length > 10) {
                throw new IllegalArgumentException("A maximum of 10 container classes is supported");
            }
            ObjCClass c01 = UIAppearance.toObjCClass(containedIn, 0);
            ObjCClass c02 = UIAppearance.toObjCClass(containedIn, 1);
            ObjCClass c03 = UIAppearance.toObjCClass(containedIn, 2);
            ObjCClass c04 = UIAppearance.toObjCClass(containedIn, 3);
            ObjCClass c05 = UIAppearance.toObjCClass(containedIn, 4);
            ObjCClass c06 = UIAppearance.toObjCClass(containedIn, 5);
            ObjCClass c07 = UIAppearance.toObjCClass(containedIn, 6);
            ObjCClass c08 = UIAppearance.toObjCClass(containedIn, 7);
            ObjCClass c09 = UIAppearance.toObjCClass(containedIn, 8);
            ObjCClass c10 = UIAppearance.toObjCClass(containedIn, 9);
            proxyHandle = UIAppearance.objc_appearanceForTraitCollectionWhenContainedIn(objCClass, appearanceForTraitCollectionWhenContainedIn, trait, c01, c02, c03, c04, c05, c06, c07, c08, c09, c10, 0L);
        }
        return (T)((NSObject)ObjCObject.toObjCObject(type, (long)proxyHandle, (int)0, (boolean)true));
    }

    static {
        ObjCRuntime.bind(UIAppearance.class);
        appearance = Selector.register((String)"appearance");
        appearanceWhenContainedIn = Selector.register((String)"appearanceWhenContainedIn:");
        appearanceForTraitCollection = Selector.register((String)"appearanceForTraitCollection:");
        appearanceForTraitCollectionWhenContainedIn = Selector.register((String)"appearanceForTraitCollection:whenContainedIn:");
    }
}

