/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.uikit;

import java.io.UnsupportedEncodingException;
import org.robovm.apple.coregraphics.CGRect;
import org.robovm.apple.foundation.Foundation;
import org.robovm.apple.foundation.FoundationLogPrintStream;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSNotification;
import org.robovm.apple.foundation.NSNotificationCenter;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSOperationQueue;
import org.robovm.apple.foundation.NSSet;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.foundation.NSURL;
import org.robovm.apple.foundation.NSUserActivity;
import org.robovm.apple.foundation.NSValue;
import org.robovm.apple.uikit.NSValueExtensions;
import org.robovm.apple.uikit.UIApplicationDelegate;
import org.robovm.apple.uikit.UIApplicationLaunchOptions;
import org.robovm.apple.uikit.UIApplicationOpenURLOptions;
import org.robovm.apple.uikit.UIApplicationShortcutItem;
import org.robovm.apple.uikit.UIApplicationState;
import org.robovm.apple.uikit.UIBackgroundRefreshStatus;
import org.robovm.apple.uikit.UIContentSizeCategory;
import org.robovm.apple.uikit.UIEvent;
import org.robovm.apple.uikit.UIImage;
import org.robovm.apple.uikit.UIInterfaceOrientation;
import org.robovm.apple.uikit.UIInterfaceOrientationMask;
import org.robovm.apple.uikit.UILocalNotification;
import org.robovm.apple.uikit.UIRemoteNotificationType;
import org.robovm.apple.uikit.UIResponder;
import org.robovm.apple.uikit.UIScene;
import org.robovm.apple.uikit.UISceneActivationRequestOptions;
import org.robovm.apple.uikit.UISceneDestructionRequestOptions;
import org.robovm.apple.uikit.UISceneSession;
import org.robovm.apple.uikit.UIStateRestoring;
import org.robovm.apple.uikit.UIStatusBarAnimation;
import org.robovm.apple.uikit.UIStatusBarStyle;
import org.robovm.apple.uikit.UIUserInterfaceLayoutDirection;
import org.robovm.apple.uikit.UIUserNotificationSettings;
import org.robovm.apple.uikit.UIWindow;
import org.robovm.objc.ObjCClass;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.Selector;
import org.robovm.objc.annotation.Block;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.objc.block.VoidBlock1;
import org.robovm.objc.block.VoidBooleanBlock;
import org.robovm.rt.VM;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.Struct;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedSInt;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.ptr.BytePtr;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="UIKit")
@NativeClass
public class UIApplication
extends UIResponder {
    private static UIWindow KEY_WINDOW = null;

    public UIApplication() {
    }

    protected UIApplication(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected UIApplication(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Property(selector="sharedApplication")
    public static native UIApplication getSharedApplication();

    @Property(selector="delegate")
    public native UIApplicationDelegate getDelegate();

    @Property(selector="setDelegate:", strongRef=true)
    public native void setDelegate(UIApplicationDelegate var1);

    @Deprecated
    @Property(selector="isIgnoringInteractionEvents")
    public native boolean isIgnoringInteractionEvents();

    @Property(selector="isIdleTimerDisabled")
    public native boolean isIdleTimerDisabled();

    @Property(selector="setIdleTimerDisabled:")
    public native void setIdleTimerDisabled(boolean var1);

    @Deprecated
    @Property(selector="keyWindow")
    public native UIWindow getKeyWindow();

    @Property(selector="windows")
    public native NSArray<UIWindow> getWindows();

    @Deprecated
    @Property(selector="isNetworkActivityIndicatorVisible")
    public native boolean isNetworkActivityIndicatorVisible();

    @Deprecated
    @Property(selector="setNetworkActivityIndicatorVisible:")
    public native void setNetworkActivityIndicatorVisible(boolean var1);

    @Deprecated
    @Property(selector="statusBarStyle")
    public native UIStatusBarStyle getStatusBarStyle();

    @Deprecated
    @Property(selector="isStatusBarHidden")
    public native boolean isStatusBarHidden();

    @Deprecated
    @Property(selector="statusBarOrientation")
    public native UIInterfaceOrientation getStatusBarOrientation();

    @Deprecated
    @Property(selector="statusBarOrientationAnimationDuration")
    public native double getStatusBarOrientationAnimationDuration();

    @Deprecated
    @Property(selector="statusBarFrame")
    @ByVal
    public native CGRect getStatusBarFrame();

    @Property(selector="applicationIconBadgeNumber")
    @MachineSizedSInt
    public native long getApplicationIconBadgeNumber();

    @Property(selector="setApplicationIconBadgeNumber:")
    public native void setApplicationIconBadgeNumber(@MachineSizedSInt long var1);

    @Property(selector="applicationSupportsShakeToEdit")
    public native boolean supportsShakeToEdit();

    @Property(selector="setApplicationSupportsShakeToEdit:")
    public native void setSupportsShakeToEdit(boolean var1);

    @Property(selector="applicationState")
    public native UIApplicationState getApplicationState();

    @Property(selector="backgroundTimeRemaining")
    public native double getBackgroundTimeRemaining();

    @Property(selector="backgroundRefreshStatus")
    public native UIBackgroundRefreshStatus getBackgroundRefreshStatus();

    @Property(selector="isProtectedDataAvailable")
    public native boolean isProtectedDataAvailable();

    @Property(selector="userInterfaceLayoutDirection")
    public native UIUserInterfaceLayoutDirection getUserInterfaceLayoutDirection();

    @Property(selector="preferredContentSizeCategory")
    public native String getPreferredContentSizeCategory();

    @Property(selector="connectedScenes")
    public native NSSet<UIScene> getConnectedScenes();

    @Property(selector="openSessions")
    public native NSSet<UISceneSession> getOpenSessions();

    @Property(selector="supportsMultipleScenes")
    public native boolean supportsMultipleScenes();

    @Property(selector="isRegisteredForRemoteNotifications")
    public native boolean isRegisteredForRemoteNotifications();

    @Deprecated
    @Property(selector="scheduledLocalNotifications")
    public native NSArray<UILocalNotification> getScheduledLocalNotifications();

    @Deprecated
    @Property(selector="setScheduledLocalNotifications:")
    public native void setScheduledLocalNotifications(NSArray<UILocalNotification> var1);

    @Deprecated
    @Property(selector="currentUserNotificationSettings")
    public native UIUserNotificationSettings getCurrentUserNotificationSettings();

    @Property(selector="shortcutItems")
    public native NSArray<UIApplicationShortcutItem> getShortcutItems();

    @Property(selector="setShortcutItems:")
    public native void setShortcutItems(NSArray<UIApplicationShortcutItem> var1);

    @Property(selector="supportsAlternateIcons")
    public native boolean supportsAlternateIcons();

    @Property(selector="alternateIconName")
    public native String getAlternateIconName();

    @Deprecated
    @Property(selector="setStatusBarOrientation:")
    public native void setStatusBarOrientation(UIInterfaceOrientation var1);

    @Deprecated
    @Property(selector="setStatusBarStyle:")
    public native void setStatusBarStyle(UIStatusBarStyle var1);

    @Deprecated
    @Property(selector="setStatusBarHidden:")
    public native void setStatusBarHidden(boolean var1);

    public static <P extends UIApplication, D extends NSObject> void main(String[] args, Class<P> principalClass, Class<D> delegateClass) {
        int argc = args.length;
        BytePtr.BytePtrPtr argv = null;
        if (argc > 0) {
            argv = (BytePtr.BytePtrPtr)Struct.allocate(BytePtr.BytePtrPtr.class, (int)argc);
            for (int i = 0; i < argc; ++i) {
                BytePtr arg = BytePtr.toBytePtrAsciiZ((String)args[i]);
                ((BytePtr.BytePtrPtr)argv.next((long)i)).set((NativeObject)arg);
            }
        }
        String principalClassName = null;
        if (principalClass != null) {
            principalClassName = ObjCClass.getByType(principalClass).getName();
        }
        String delegateClassName = null;
        if (delegateClass != null) {
            delegateClassName = ObjCClass.getByType(delegateClass).getName();
        }
        if (System.getenv("ROBOVM_LAUNCH_MODE") == null) {
            if (!(System.err instanceof FoundationLogPrintStream)) {
                System.setErr(new FoundationLogPrintStream());
            }
            if (!(System.out instanceof FoundationLogPrintStream)) {
                System.setOut(new FoundationLogPrintStream());
            }
        }
        NSNotificationCenter.getDefaultCenter().addObserver(UIWindow.DidBecomeKeyNotification(), null, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

            public void invoke(NSNotification a) {
                KEY_WINDOW = (UIWindow)a.getObject();
            }
        });
        NSNotificationCenter.getDefaultCenter().addObserver(UIWindow.DidResignKeyNotification(), null, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

            public void invoke(NSNotification a) {
                if (a.getObject() == KEY_WINDOW) {
                    KEY_WINDOW = null;
                }
            }
        });
        try {
            UIApplication.preloadClasses();
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
        UIApplication.main(argc, argv, principalClassName, delegateClassName);
    }

    private static void preloadClasses() throws UnsupportedEncodingException {
        byte[] data = VM.getRuntimeData((String)(UIApplication.class.getName() + ".preloadClasses"));
        if (data != null) {
            String[] customClasses;
            for (String customClass : customClasses = new String(data, "UTF8").split(",")) {
                try {
                    Class<?> cls = Class.forName(customClass);
                    ObjCClass.registerCustomClass(cls);
                }
                catch (Throwable t) {
                    Foundation.log("Failed to preload class " + customClass + ": " + t.getMessage());
                    t.printStackTrace();
                }
            }
        }
    }

    @GlobalValue(symbol="UIContentSizeCategoryDidChangeNotification", optional=true)
    public static native NSString ContentSizeCategoryDidChangeNotification();

    @GlobalValue(symbol="UIContentSizeCategoryNewValueKey", optional=true)
    protected static native NSString ContentSizeCategoryNewValueKey();

    @GlobalValue(symbol="UIBackgroundTaskInvalid", optional=true)
    @MachineSizedUInt
    public static native long getInvalidBackgroundTask();

    @Deprecated
    @GlobalValue(symbol="UIMinimumKeepAliveTimeout", optional=true)
    public static native double getMinimumKeepAliveTimeout();

    @GlobalValue(symbol="UIApplicationBackgroundFetchIntervalMinimum", optional=true)
    public static native double getBackgroundFetchIntervalMinimum();

    @GlobalValue(symbol="UIApplicationBackgroundFetchIntervalNever", optional=true)
    public static native double getBackgroundFetchIntervalNever();

    @GlobalValue(symbol="UIApplicationDidEnterBackgroundNotification", optional=true)
    public static native NSString DidEnterBackgroundNotification();

    @GlobalValue(symbol="UIApplicationWillEnterForegroundNotification", optional=true)
    public static native NSString WillEnterForegroundNotification();

    @GlobalValue(symbol="UIApplicationDidFinishLaunchingNotification", optional=true)
    public static native NSString DidFinishLaunchingNotification();

    @GlobalValue(symbol="UIApplicationDidBecomeActiveNotification", optional=true)
    public static native NSString DidBecomeActiveNotification();

    @GlobalValue(symbol="UIApplicationWillResignActiveNotification", optional=true)
    public static native NSString WillResignActiveNotification();

    @GlobalValue(symbol="UIApplicationDidReceiveMemoryWarningNotification", optional=true)
    public static native NSString DidReceiveMemoryWarningNotification();

    @GlobalValue(symbol="UIApplicationWillTerminateNotification", optional=true)
    public static native NSString WillTerminateNotification();

    @GlobalValue(symbol="UIApplicationSignificantTimeChangeNotification", optional=true)
    public static native NSString SignificantTimeChangeNotification();

    @Deprecated
    @GlobalValue(symbol="UIApplicationWillChangeStatusBarOrientationNotification", optional=true)
    public static native NSString WillChangeStatusBarOrientationNotification();

    @Deprecated
    @GlobalValue(symbol="UIApplicationDidChangeStatusBarOrientationNotification", optional=true)
    public static native NSString DidChangeStatusBarOrientationNotification();

    @Deprecated
    @GlobalValue(symbol="UIApplicationStatusBarOrientationUserInfoKey", optional=true)
    protected static native NSString StatusBarOrientationUserInfoKey();

    @Deprecated
    @GlobalValue(symbol="UIApplicationWillChangeStatusBarFrameNotification", optional=true)
    public static native NSString WillChangeStatusBarFrameNotification();

    @Deprecated
    @GlobalValue(symbol="UIApplicationDidChangeStatusBarFrameNotification", optional=true)
    public static native NSString DidChangeStatusBarFrameNotification();

    @Deprecated
    @GlobalValue(symbol="UIApplicationStatusBarFrameUserInfoKey", optional=true)
    protected static native NSString StatusBarFrameUserInfoKey();

    @GlobalValue(symbol="UIApplicationBackgroundRefreshStatusDidChangeNotification", optional=true)
    public static native NSString BackgroundRefreshStatusDidChangeNotification();

    @GlobalValue(symbol="UIApplicationProtectedDataWillBecomeUnavailable", optional=true)
    public static native NSString ProtectedDataWillBecomeUnavailableNotification();

    @GlobalValue(symbol="UIApplicationProtectedDataDidBecomeAvailable", optional=true)
    public static native NSString ProtectedDataDidBecomeAvailableNotification();

    @GlobalValue(symbol="UIApplicationOpenSettingsURLString", optional=true)
    public static native String getOpenSettingsURLString();

    @GlobalValue(symbol="UIApplicationUserDidTakeScreenshotNotification", optional=true)
    public static native NSString UserDidTakeScreenshotNotification();

    @Bridge(symbol="UIApplicationMain", optional=true)
    protected static native int main(int var0, BytePtr.BytePtrPtr var1, String var2, String var3);

    @Deprecated
    @Method(selector="beginIgnoringInteractionEvents")
    public native void beginIgnoringInteractionEvents();

    @Deprecated
    @Method(selector="endIgnoringInteractionEvents")
    public native void endIgnoringInteractionEvents();

    @Deprecated
    @Method(selector="openURL:")
    public native boolean openURL(NSURL var1);

    @Method(selector="canOpenURL:")
    public native boolean canOpenURL(NSURL var1);

    @Method(selector="openURL:options:completionHandler:")
    public native void openURL(NSURL var1, UIApplicationOpenURLOptions var2, @Block VoidBooleanBlock var3);

    @Method(selector="sendEvent:")
    public native void sendEvent(UIEvent var1);

    @Method(selector="sendAction:to:from:forEvent:")
    public native boolean sendAction(Selector var1, NSObject var2, NSObject var3, UIEvent var4);

    @Method(selector="supportedInterfaceOrientationsForWindow:")
    public native UIInterfaceOrientationMask getSupportedInterfaceOrientations(UIWindow var1);

    @Method(selector="beginBackgroundTaskWithExpirationHandler:")
    @MachineSizedUInt
    public native long beginBackgroundTask(@Block Runnable var1);

    @Method(selector="beginBackgroundTaskWithName:expirationHandler:")
    @MachineSizedUInt
    public native long beginBackgroundTask(String var1, @Block Runnable var2);

    @Method(selector="endBackgroundTask:")
    public native void endBackgroundTask(@MachineSizedUInt long var1);

    @Deprecated
    @Method(selector="setMinimumBackgroundFetchInterval:")
    public native void setMinimumBackgroundFetchInterval(double var1);

    @Method(selector="requestSceneSessionActivation:userActivity:options:errorHandler:")
    public native void requestSceneSessionActivation(UISceneSession var1, NSUserActivity var2, UISceneActivationRequestOptions var3, @Block VoidBlock1<NSError> var4);

    @Method(selector="requestSceneSessionDestruction:options:errorHandler:")
    public native void requestSceneSessionDestruction(UISceneSession var1, UISceneDestructionRequestOptions var2, @Block VoidBlock1<NSError> var3);

    @Method(selector="requestSceneSessionRefresh:")
    public native void requestSceneSessionRefresh(UISceneSession var1);

    @Method(selector="registerForRemoteNotifications")
    public native void registerForRemoteNotifications();

    @Method(selector="unregisterForRemoteNotifications")
    public native void unregisterForRemoteNotifications();

    @Deprecated
    @Method(selector="registerForRemoteNotificationTypes:")
    public native void registerForRemoteNotificationTypes(UIRemoteNotificationType var1);

    @Deprecated
    @Method(selector="enabledRemoteNotificationTypes")
    public native UIRemoteNotificationType getEnabledRemoteNotificationTypes();

    @Deprecated
    @Method(selector="presentLocalNotificationNow:")
    public native void presentLocalNotificationNow(UILocalNotification var1);

    @Deprecated
    @Method(selector="scheduleLocalNotification:")
    public native void scheduleLocalNotification(UILocalNotification var1);

    @Deprecated
    @Method(selector="cancelLocalNotification:")
    public native void cancelLocalNotification(UILocalNotification var1);

    @Deprecated
    @Method(selector="cancelAllLocalNotifications")
    public native void cancelAllLocalNotifications();

    @Deprecated
    @Method(selector="registerUserNotificationSettings:")
    public native void registerUserNotificationSettings(UIUserNotificationSettings var1);

    @Method(selector="beginReceivingRemoteControlEvents")
    public native void beginReceivingRemoteControlEvents();

    @Method(selector="endReceivingRemoteControlEvents")
    public native void endReceivingRemoteControlEvents();

    @Deprecated
    @Method(selector="setNewsstandIconImage:")
    public native void setNewsstandIconImage(UIImage var1);

    @Method(selector="setAlternateIconName:completionHandler:")
    public native void setAlternateIcon(String var1, @Block VoidBlock1<NSError> var2);

    @Method(selector="extendStateRestoration")
    public native void extendStateRestoration();

    @Method(selector="completeStateRestoration")
    public native void completeStateRestoration();

    @Method(selector="ignoreSnapshotOnNextApplicationLaunch")
    public native void ignoreSnapshotOnNextApplicationLaunch();

    @Method(selector="registerObjectForStateRestoration:restorationIdentifier:")
    public static native void registerObjectForStateRestoration(UIStateRestoring var0, String var1);

    @Deprecated
    @Method(selector="setStatusBarOrientation:animated:")
    public native void setStatusBarOrientation(UIInterfaceOrientation var1, boolean var2);

    @Deprecated
    @Method(selector="setStatusBarStyle:animated:")
    public native void setStatusBarStyle(UIStatusBarStyle var1, boolean var2);

    @Deprecated
    @Method(selector="setStatusBarHidden:withAnimation:")
    public native void setStatusBarHidden(boolean var1, UIStatusBarAnimation var2);

    @Deprecated
    @Method(selector="setKeepAliveTimeout:handler:")
    public native boolean setKeepAliveTimeout(double var1, @Block Runnable var3);

    @Deprecated
    @Method(selector="clearKeepAliveTimeout")
    public native void clearKeepAliveTimeout();

    static {
        ObjCRuntime.bind(UIApplication.class);
    }

    public static class UIApplicationPtr
    extends Ptr<UIApplication, UIApplicationPtr> {
    }

    public static class Notifications {
        public static NSObject observeDidEnterBackground(final Runnable block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(UIApplication.DidEnterBackgroundNotification(), null, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.run();
                }
            });
        }

        public static NSObject observeWillEnterForeground(final Runnable block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(UIApplication.WillEnterForegroundNotification(), null, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.run();
                }
            });
        }

        public static NSObject observeDidFinishLaunching(final VoidBlock1<UIApplicationLaunchOptions> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(UIApplication.DidFinishLaunchingNotification(), null, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    if (a.getUserInfo() != null) {
                        block.invoke((Object)new UIApplicationLaunchOptions(a.getUserInfo()));
                    } else {
                        block.invoke(null);
                    }
                }
            });
        }

        public static NSObject observeDidBecomeActive(final Runnable block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(UIApplication.DidBecomeActiveNotification(), null, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.run();
                }
            });
        }

        public static NSObject observeWillResignActive(final Runnable block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(UIApplication.WillResignActiveNotification(), null, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.run();
                }
            });
        }

        public static NSObject observeDidReceiveMemoryWarning(final Runnable block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(UIApplication.DidReceiveMemoryWarningNotification(), null, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.run();
                }
            });
        }

        public static NSObject observeWillTerminate(final Runnable block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(UIApplication.WillTerminateNotification(), null, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.run();
                }
            });
        }

        public static NSObject observeSignificantTimeChange(final Runnable block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(UIApplication.SignificantTimeChangeNotification(), null, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.run();
                }
            });
        }

        public static NSObject observeWillChangeStatusBarOrientation(final VoidBlock1<UIInterfaceOrientation> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(UIApplication.WillChangeStatusBarOrientationNotification(), null, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    NSNumber val = (NSNumber)a.getUserInfo().get(UIApplication.StatusBarOrientationUserInfoKey());
                    block.invoke((Object)UIInterfaceOrientation.valueOf(val.intValue()));
                }
            });
        }

        public static NSObject observeDidChangeStatusBarOrientation(final VoidBlock1<UIInterfaceOrientation> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(UIApplication.DidChangeStatusBarOrientationNotification(), null, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    NSNumber val = (NSNumber)a.getUserInfo().get(UIApplication.StatusBarOrientationUserInfoKey());
                    block.invoke((Object)UIInterfaceOrientation.valueOf(val.intValue()));
                }
            });
        }

        public static NSObject observeWillChangeStatusBarFrame(final VoidBlock1<CGRect> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(UIApplication.WillChangeStatusBarFrameNotification(), null, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    NSValue val = (NSValue)a.getUserInfo().get(UIApplication.StatusBarFrameUserInfoKey());
                    block.invoke((Object)NSValueExtensions.getRectValue(val));
                }
            });
        }

        public static NSObject observeDidChangeStatusBarFrame(final VoidBlock1<CGRect> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(UIApplication.DidChangeStatusBarFrameNotification(), null, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    NSValue val = (NSValue)a.getUserInfo().get(UIApplication.StatusBarFrameUserInfoKey());
                    block.invoke((Object)NSValueExtensions.getRectValue(val));
                }
            });
        }

        public static NSObject observeBackgroundRefreshStatusDidChange(final Runnable block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(UIApplication.BackgroundRefreshStatusDidChangeNotification(), null, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.run();
                }
            });
        }

        public static NSObject observeProtectedDataWillBecomeUnavailable(final Runnable block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(UIApplication.ProtectedDataWillBecomeUnavailableNotification(), null, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.run();
                }
            });
        }

        public static NSObject observeProtectedDataDidBecomeAvailable(final Runnable block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(UIApplication.ProtectedDataDidBecomeAvailableNotification(), null, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.run();
                }
            });
        }

        public static NSObject observeContentSizeCategoryDidChange(final VoidBlock1<UIContentSizeCategory> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(UIApplication.ContentSizeCategoryDidChangeNotification(), null, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    NSString val = (NSString)a.getUserInfo().get(UIApplication.ContentSizeCategoryNewValueKey());
                    block.invoke((Object)UIContentSizeCategory.valueOf(val));
                }
            });
        }

        public static NSObject observeUserDidTakeScreenshot(final Runnable block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(UIApplication.UserDidTakeScreenshotNotification(), null, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.run();
                }
            });
        }
    }
}

