/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.uikit;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.robovm.apple.coregraphics.CGRect;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSCoder;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSSet;
import org.robovm.apple.uikit.UIControlContentHorizontalAlignment;
import org.robovm.apple.uikit.UIControlContentVerticalAlignment;
import org.robovm.apple.uikit.UIControlEvents;
import org.robovm.apple.uikit.UIControlState;
import org.robovm.apple.uikit.UIEvent;
import org.robovm.apple.uikit.UITouch;
import org.robovm.apple.uikit.UIView;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.Selector;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="UIKit")
@NativeClass
public class UIControl
extends UIView {
    private static final Selector handleTouchEvent;
    private static final Selector handleEvent;

    public UIControl() {
    }

    @Deprecated
    protected UIControl(long handle) {
        super(handle);
    }

    protected UIControl(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected UIControl(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Method(selector="initWithFrame:")
    public UIControl(@ByVal CGRect frame) {
        super(frame);
    }

    @Method(selector="initWithCoder:")
    public UIControl(NSCoder coder) {
        super(coder);
    }

    @Property(selector="isEnabled")
    public native boolean isEnabled();

    @Property(selector="setEnabled:")
    public native void setEnabled(boolean var1);

    @Property(selector="isSelected")
    public native boolean isSelected();

    @Property(selector="setSelected:")
    public native void setSelected(boolean var1);

    @Property(selector="isHighlighted")
    public native boolean isHighlighted();

    @Property(selector="setHighlighted:")
    public native void setHighlighted(boolean var1);

    @Property(selector="contentVerticalAlignment")
    public native UIControlContentVerticalAlignment getContentVerticalAlignment();

    @Property(selector="setContentVerticalAlignment:")
    public native void setContentVerticalAlignment(UIControlContentVerticalAlignment var1);

    @Property(selector="contentHorizontalAlignment")
    public native UIControlContentHorizontalAlignment getContentHorizontalAlignment();

    @Property(selector="setContentHorizontalAlignment:")
    public native void setContentHorizontalAlignment(UIControlContentHorizontalAlignment var1);

    @Property(selector="effectiveContentHorizontalAlignment")
    public native UIControlContentHorizontalAlignment getEffectiveContentHorizontalAlignment();

    @Property(selector="state")
    public native UIControlState getState();

    @Property(selector="isTracking")
    public native boolean isTracking();

    @Property(selector="isTouchInside")
    public native boolean isTouchInside();

    @Property(selector="allTargets")
    public native NSSet<?> getAllTargets();

    @Property(selector="allControlEvents")
    public native UIControlEvents getAllControlEvents();

    public void addOnTouchDownListener(OnTouchDownListener l) {
        this.addListener(l, UIControlEvents.TouchDown);
    }

    public void addOnTouchDownRepeatListener(OnTouchDownRepeatListener l) {
        this.addListener(l, UIControlEvents.TouchDownRepeat);
    }

    public void addOnTouchDragInsideListener(OnTouchDragInsideListener l) {
        this.addListener(l, UIControlEvents.TouchDragInside);
    }

    public void addOnTouchDragOutsideListener(OnTouchDragOutsideListener l) {
        this.addListener(l, UIControlEvents.TouchDragOutside);
    }

    public void addOnTouchDragEnterListener(OnTouchDragEnterListener l) {
        this.addListener(l, UIControlEvents.TouchDragEnter);
    }

    public void addOnTouchDragExitListener(OnTouchDragExitListener l) {
        this.addListener(l, UIControlEvents.TouchDragExit);
    }

    public void addOnTouchUpInsideListener(OnTouchUpInsideListener l) {
        this.addListener(l, UIControlEvents.TouchUpInside);
    }

    public void addOnTouchUpOutsideListener(OnTouchUpOutsideListener l) {
        this.addListener(l, UIControlEvents.TouchUpOutside);
    }

    public void addOnTouchCancelListener(OnTouchCancelListener l) {
        this.addListener(l, UIControlEvents.TouchCancel);
    }

    public void addOnValueChangedListener(OnValueChangedListener l) {
        this.addListener(l, UIControlEvents.ValueChanged);
    }

    public void addOnEditingDidBegin(OnEditingDidBeginListener l) {
        this.addListener(l, UIControlEvents.EditingDidBegin);
    }

    public void addOnEditingChangedListener(OnEditingChangedListener l) {
        this.addListener(l, UIControlEvents.EditingChanged);
    }

    public void addOnEditingDidEndListener(OnEditingDidEndListener l) {
        this.addListener(l, UIControlEvents.EditingDidEnd);
    }

    public void addOnEditingDidEndOnExitListener(OnEditingDidEndOnExitListener l) {
        this.addListener(l, UIControlEvents.EditingDidEndOnExit);
    }

    public void addOnPrimaryActionTriggeredListener(OnPrimaryActionTriggeredListener l) {
        this.addListener(l, UIControlEvents.PrimaryActionTriggered);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ListenerWrapper> getListeners(boolean create) {
        Class<UIControl> clazz = UIControl.class;
        synchronized (UIControl.class) {
            LinkedList listeners = (LinkedList)this.getAssociatedObject(UIControl.class.getName() + ".listeners");
            if (listeners == null && create) {
                listeners = new LinkedList();
                this.setAssociatedObject(UIControl.class.getName() + ".listeners", listeners);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return listeners;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addListener(Listener listener, UIControlEvents controlEvent) {
        List<ListenerWrapper> listeners;
        Selector selector = handleTouchEvent;
        if (listener instanceof OnValueChangedListener || listener instanceof OnEditingChangedListener || listener instanceof OnEditingDidBeginListener || listener instanceof OnEditingDidEndListener || listener instanceof OnEditingDidEndOnExitListener || listener instanceof OnPrimaryActionTriggeredListener) {
            selector = handleEvent;
        }
        ListenerWrapper wrapper = new ListenerWrapper(listener, controlEvent, selector);
        List<ListenerWrapper> list = listeners = this.getListeners(true);
        synchronized (list) {
            listeners.add(wrapper);
        }
        this.addTarget(wrapper, selector, controlEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(Listener listener) {
        List<ListenerWrapper> listeners = this.getListeners(false);
        if (listeners == null) {
            return;
        }
        List<ListenerWrapper> list = listeners;
        synchronized (list) {
            Iterator<ListenerWrapper> it = listeners.iterator();
            while (it.hasNext()) {
                ListenerWrapper wrapper = it.next();
                if (wrapper.listener != listener) continue;
                this.removeTarget(wrapper, wrapper.selector, wrapper.controlEvent);
                it.remove();
                break;
            }
        }
    }

    @Method(selector="beginTrackingWithTouch:withEvent:")
    public native boolean beginTracking(UITouch var1, UIEvent var2);

    @Method(selector="continueTrackingWithTouch:withEvent:")
    public native boolean continueTracking(UITouch var1, UIEvent var2);

    @Method(selector="endTrackingWithTouch:withEvent:")
    public native void endTracking(UITouch var1, UIEvent var2);

    @Method(selector="cancelTrackingWithEvent:")
    public native void cancelTracking(UIEvent var1);

    @Method(selector="addTarget:action:forControlEvents:")
    public native void addTarget(NSObject var1, Selector var2, UIControlEvents var3);

    @Method(selector="removeTarget:action:forControlEvents:")
    public native void removeTarget(NSObject var1, Selector var2, UIControlEvents var3);

    @Method(selector="actionsForTarget:forControlEvent:")
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public native List<String> getActions(NSObject var1, UIControlEvents var2);

    @Method(selector="sendAction:to:forEvent:")
    public native void sendAction(Selector var1, NSObject var2, UIEvent var3);

    @Method(selector="sendActionsForControlEvents:")
    public native void sendControlEventsActions(UIControlEvents var1);

    static {
        ObjCRuntime.bind(UIControl.class);
        handleTouchEvent = Selector.register((String)"handleTouchEvent");
        handleEvent = Selector.register((String)"handleEvent");
    }

    protected static interface Listener {
    }

    public static interface OnValueChangedListener
    extends Listener {
        public void onValueChanged(UIControl var1);
    }

    public static interface OnEditingChangedListener
    extends Listener {
        public void onEditingChanged(UIControl var1);
    }

    public static interface OnEditingDidBeginListener
    extends Listener {
        public void onEditingDidBegin(UIControl var1);
    }

    public static interface OnEditingDidEndListener
    extends Listener {
        public void onEditingDidEnd(UIControl var1);
    }

    public static interface OnEditingDidEndOnExitListener
    extends Listener {
        public void onEditingDidEndOnExit(UIControl var1);
    }

    public static interface OnPrimaryActionTriggeredListener
    extends Listener {
        public void onPrimaryActionTriggered(UIControl var1);
    }

    private static class ListenerWrapper
    extends NSObject {
        private final Listener listener;
        private final UIControlEvents controlEvent;
        private final Selector selector;

        private ListenerWrapper(Listener listener, UIControlEvents controlEvent, Selector selector) {
            this.listener = listener;
            this.controlEvent = controlEvent;
            this.selector = selector;
        }

        @Method(selector="handleTouchEvent")
        private void handleTouchEvent(UIControl control, UIEvent event) {
            if (this.controlEvent == UIControlEvents.TouchDown) {
                ((OnTouchDownListener)this.listener).onTouchDown(control, event);
            } else if (this.controlEvent == UIControlEvents.TouchUpInside) {
                ((OnTouchUpInsideListener)this.listener).onTouchUpInside(control, event);
            } else if (this.controlEvent == UIControlEvents.TouchUpOutside) {
                ((OnTouchUpOutsideListener)this.listener).onTouchUpOutside(control, event);
            } else if (this.controlEvent == UIControlEvents.TouchCancel) {
                ((OnTouchCancelListener)this.listener).onTouchCancel(control, event);
            } else if (this.controlEvent == UIControlEvents.TouchDownRepeat) {
                ((OnTouchDownRepeatListener)this.listener).onTouchDownRepeat(control, event);
            } else if (this.controlEvent == UIControlEvents.TouchDragEnter) {
                ((OnTouchDragEnterListener)this.listener).onTouchDragEnter(control, event);
            } else if (this.controlEvent == UIControlEvents.TouchDragExit) {
                ((OnTouchDragExitListener)this.listener).onTouchDragExit(control, event);
            } else if (this.controlEvent == UIControlEvents.TouchDragInside) {
                ((OnTouchDragInsideListener)this.listener).onTouchDragInside(control, event);
            } else if (this.controlEvent == UIControlEvents.TouchDragOutside) {
                ((OnTouchDragOutsideListener)this.listener).onTouchDragOutside(control, event);
            }
        }

        @Method(selector="handleEvent")
        private void handleEvent(UIControl control) {
            if (this.controlEvent == UIControlEvents.ValueChanged) {
                ((OnValueChangedListener)this.listener).onValueChanged(control);
            } else if (this.controlEvent == UIControlEvents.EditingChanged) {
                ((OnEditingChangedListener)this.listener).onEditingChanged(control);
            } else if (this.controlEvent == UIControlEvents.EditingDidBegin) {
                ((OnEditingDidBeginListener)this.listener).onEditingDidBegin(control);
            } else if (this.controlEvent == UIControlEvents.EditingDidEnd) {
                ((OnEditingDidEndListener)this.listener).onEditingDidEnd(control);
            } else if (this.controlEvent == UIControlEvents.EditingDidEndOnExit) {
                ((OnEditingDidEndOnExitListener)this.listener).onEditingDidEndOnExit(control);
            } else if (this.controlEvent == UIControlEvents.PrimaryActionTriggered) {
                ((OnPrimaryActionTriggeredListener)this.listener).onPrimaryActionTriggered(control);
            }
        }
    }

    public static interface OnTouchCancelListener
    extends Listener {
        public void onTouchCancel(UIControl var1, UIEvent var2);
    }

    public static interface OnTouchUpOutsideListener
    extends Listener {
        public void onTouchUpOutside(UIControl var1, UIEvent var2);
    }

    public static interface OnTouchUpInsideListener
    extends Listener {
        public void onTouchUpInside(UIControl var1, UIEvent var2);
    }

    public static interface OnTouchDragExitListener
    extends Listener {
        public void onTouchDragExit(UIControl var1, UIEvent var2);
    }

    public static interface OnTouchDragEnterListener
    extends Listener {
        public void onTouchDragEnter(UIControl var1, UIEvent var2);
    }

    public static interface OnTouchDragOutsideListener
    extends Listener {
        public void onTouchDragOutside(UIControl var1, UIEvent var2);
    }

    public static interface OnTouchDragInsideListener
    extends Listener {
        public void onTouchDragInside(UIControl var1, UIEvent var2);
    }

    public static interface OnTouchDownRepeatListener
    extends Listener {
        public void onTouchDownRepeat(UIControl var1, UIEvent var2);
    }

    public static interface OnTouchDownListener
    extends Listener {
        public void onTouchDown(UIControl var1, UIEvent var2);
    }

    public static class UIControlPtr
    extends Ptr<UIControl, UIControlPtr> {
    }
}

